/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.Classpath;
import org.eclipse.dali.internal.utility.CollectionTools;

public class ClasspathTests
extends TestCase {
    private static final String JAVA_HOME = System.getProperty("java.home");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.ClasspathTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.ClasspathTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ClasspathTests(String name) {
        super(name);
    }

    public void testCompressed() {
        String path = "";
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;;;;C:\\jdk\\jaws.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;;;")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\..\\jdk\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk1\\jdk2\\jdk3\\..\\..\\..\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
    }

    public void testConvertToClassName() {
        String fileName = "java/lang/String.class";
        File file = new File(fileName);
        String className = Classpath.convertToClassName((File)file);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClasspathTests.assertEquals((String)clazz.getName(), (String)className);
    }

    public void testConvertToClass() throws ClassNotFoundException {
        String fileName = "java/lang/String.class";
        File file = new File(fileName);
        Class javaClass = Classpath.convertToClass((File)file);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClasspathTests.assertEquals((Object)clazz, (Object)javaClass);
    }

    public void testConvertToArchiveClassFileEntryName() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String fileName = Classpath.convertToArchiveClassFileEntryName((Class)clazz);
        ClasspathTests.assertEquals((String)"java/lang/String.class", (String)fileName);
    }

    public void testConvertToClassFileName() {
        char sc = File.separatorChar;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String fileName = Classpath.convertToClassFileName((Class)clazz);
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.class"), (String)fileName);
    }

    public void testConvertToJavaFileName() {
        char sc = File.separatorChar;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String fileName = Classpath.convertToJavaFileName((String)clazz.getName());
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.java"), (String)fileName);
    }

    public void testConvertToURLs() {
        URL[] entries = new Classpath(this.morph("C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).urls();
        int i = 0;
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/rt.jar"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/i18n.jar"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/jaws.jar"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/foo/classes"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/bar/bar.jar"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((int)i, (int)entries.length);
    }

    public void testEntries() {
        Classpath cp = new Classpath(this.morph("C:\\jdk\\rt.jar;;.;C:\\jdk\\i18n.jar;;;C:\\jdk\\jaws.jar;;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\bar\\bar.jar;"));
        Classpath.Entry[] entries = cp.getEntries();
        int i = 0;
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("."), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\jaws.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\foo\\classes"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((int)i, (int)entries.length);
        cp = cp.compressed();
        entries = cp.getEntries();
        i = 0;
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("."), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\jaws.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\foo\\classes"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((int)i, (int)entries.length);
    }

    public void testEntryForFileNamed() {
        Classpath.Entry entry = null;
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;rt.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;rt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\rt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath("rt.jar").entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rtrtrt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rtrtrt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"path entry should not be found", null, (Object)entry);
    }

    public void testLocationForClass() {
        Class<?> javaClass;
        File entry;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.dali.internal.utility.Classpath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((entry = new File(Classpath.locationFor(javaClass = clazz))).isFile() || entry.isDirectory()) {
            ClasspathTests.assertTrue((boolean)entry.exists());
        }
        if (entry.isDirectory()) {
            ClasspathTests.assertTrue((boolean)new File(entry, Classpath.convertToClassFileName(javaClass)).exists());
        }
    }

    public void testRtJarName() throws IOException {
        File rtFile = new File(Classpath.rtJarName());
        ClasspathTests.assertTrue((String)"rt.jar does not exist", (boolean)rtFile.exists());
        JarFile rtJarFile = new JarFile(rtFile);
        JarEntry entry = rtJarFile.getJarEntry("java/lang/Object.class");
        rtJarFile.close();
        ClasspathTests.assertTrue((String)"bogus rt.jar", (entry != null ? 1 : 0) != 0);
    }

    public void testJREClassNames() {
        Object[] objectArray = Classpath.bootClasspath().classNames();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClasspathTests.assertTrue((String)"Vector is missing from JRE class names", (boolean)CollectionTools.contains((Object[])objectArray, (Object)clazz.getName()));
        Object[] objectArray2 = Classpath.bootClasspath().classNames();
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClasspathTests.assertTrue((String)"File is missing from JRE class names", (boolean)CollectionTools.contains((Object[])objectArray2, (Object)clazz2.getName()));
    }

    public void testJavaExtensionDirectoryNames() {
        char sep = File.separatorChar;
        String stdExtDirName = String.valueOf(JAVA_HOME) + sep + "lib" + sep + "ext";
        ClasspathTests.assertTrue((String)("standard extension dir name missing: " + stdExtDirName), (boolean)CollectionTools.contains((Object[])Classpath.javaExtensionDirectoryNames(), (Object)stdExtDirName));
    }

    public void testJavaExtensionDirectories() {
        char sep = File.separatorChar;
        File stdExtDir = new File(String.valueOf(JAVA_HOME) + sep + "lib" + sep + "ext");
        ClasspathTests.assertTrue((String)("standard extension dir missing: " + stdExtDir.getParent()), (boolean)CollectionTools.contains((Object[])Classpath.javaExtensionDirectories(), (Object)stdExtDir));
    }

    public void testJavaExtensionClasspathEntries() {
        char sep = File.separatorChar;
        String jdk = System.getProperty("java.version");
        if (jdk.startsWith("1.4") || jdk.startsWith("1.5")) {
            ArrayList<String> jarNames = new ArrayList<String>();
            Classpath.Entry[] entries = Classpath.javaExtensionClasspath().getEntries();
            int i = 0;
            while (i < entries.length) {
                jarNames.add(entries[i].fileName());
                ++i;
            }
            String stdExtJarName = String.valueOf(JAVA_HOME) + sep + "lib" + sep + "ext" + sep + "dnsns.jar";
            ClasspathTests.assertTrue((String)("jdk 1.4.x standard extension jar missing: " + stdExtJarName), (boolean)jarNames.contains(stdExtJarName));
        } else {
            ClasspathTests.fail((String)"we need to update this test for the current jdk");
        }
    }

    public void testJavaExtensionClassNames() {
        String jdk = System.getProperty("java.version");
        if (jdk.startsWith("1.4") || jdk.startsWith("1.5")) {
            String className = "sun.net.spi.nameservice.dns.DNSNameService";
            ClasspathTests.assertTrue((String)("jdk 1.4.x standard extension class missing: " + className), (boolean)CollectionTools.contains((Object[])Classpath.javaExtensionClasspath().classNames(), (Object)className));
        } else {
            ClasspathTests.fail((String)"we need to update this test for the current jdk");
        }
    }

    public void testJavaClasspathClassNames() {
        String className = ((Object)((Object)this)).getClass().getName();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl.getClass().getName().startsWith("sun.misc")) {
            ClasspathTests.assertTrue((String)("class missing: " + className), (boolean)CollectionTools.contains((Object[])Classpath.javaClasspath().classNames(), (Object)className));
        }
    }

    private String morph(String path) {
        String result = path;
        result = result.replace('\\', File.separatorChar);
        result = result.replace(';', File.pathSeparatorChar);
        if (!CollectionTools.contains((Object[])File.listRoots(), (Object)new File("C:\\"))) {
            result = result.replaceAll("C:", "");
        }
        return result;
    }

    private String morphURL(String url) {
        String result = url;
        if (!CollectionTools.contains((Object[])File.listRoots(), (Object)new File("C:\\"))) {
            result = result.replaceAll("/C:", "");
        }
        return result;
    }
}

