/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.HashBag;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.ArrayIterator;

public final class NameTools {
    public static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    public static final Set JAVA_RESERVED_WORDS_SET = CollectionTools.set(JAVA_RESERVED_WORDS);

    public static String uniqueJavaNameFor(String rootName, Iterator existingNames) {
        Set existingNames2 = CollectionTools.set(existingNames);
        existingNames2.addAll(JAVA_RESERVED_WORDS_SET);
        return NameTools.uniqueNameFor(rootName, existingNames2, rootName);
    }

    public static String uniqueJavaNameFor(String rootName, Collection existingNames) {
        HashSet existingNames2 = new HashSet(existingNames);
        existingNames2.addAll(JAVA_RESERVED_WORDS_SET);
        return NameTools.uniqueNameFor(rootName, existingNames2, rootName);
    }

    public static String uniqueNameFor(String rootName, Iterator existingNames) {
        return NameTools.uniqueNameFor(rootName, CollectionTools.set(existingNames));
    }

    public static String uniqueNameFor(String rootName, Collection existingNames) {
        return NameTools.uniqueNameFor(rootName, existingNames, rootName);
    }

    public static String uniqueNameForIgnoreCase(String rootName, Iterator existingNames) {
        return NameTools.uniqueNameForIgnoreCase(rootName, CollectionTools.set(existingNames));
    }

    public static String uniqueNameForIgnoreCase(String rootName, Collection existingNames) {
        return NameTools.uniqueNameFor(rootName, NameTools.convertToLowerCase(existingNames), rootName.toLowerCase());
    }

    private static String uniqueNameFor(String rootName, Collection existingNames, String templateName) {
        if (!existingNames.contains(templateName)) {
            return rootName;
        }
        String uniqueName = templateName;
        int suffix = 2;
        while (existingNames.contains(String.valueOf(uniqueName) + suffix)) {
            ++suffix;
        }
        return rootName.concat(String.valueOf(suffix));
    }

    private static Collection convertToLowerCase(Collection strings) {
        HashBag result = new HashBag(strings.size());
        Iterator stream = strings.iterator();
        while (stream.hasNext()) {
            result.add(((String)stream.next()).toLowerCase());
        }
        return result;
    }

    public static String buildQualifiedDatabaseObjectName(String catalog, String schema, String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (catalog == null && schema == null) {
            return name;
        }
        StringBuffer sb = new StringBuffer(100);
        if (catalog != null) {
            sb.append(catalog);
            sb.append('.');
        }
        if (schema != null) {
            sb.append(schema);
        }
        sb.append('.');
        sb.append(name);
        return sb.toString();
    }

    public static Iterator javaReservedWords() {
        return new ArrayIterator(JAVA_RESERVED_WORDS);
    }

    public static String convertToJavaIdentifier(String string) {
        return NameTools.convertToJavaIdentifier(string, '_');
    }

    public static String convertToJavaIdentifier(String string, char c) {
        if (string.length() == 0) {
            return string;
        }
        if (JAVA_RESERVED_WORDS_SET.contains(string)) {
            return StringTools.capitalize(string);
        }
        return new String(NameTools.convertToJavaIdentifierInternal(string.toCharArray(), c));
    }

    public static char[] convertToJavaIdentifier(char[] string) {
        return NameTools.convertToJavaIdentifier(string, '_');
    }

    public static char[] convertToJavaIdentifier(char[] string, char c) {
        int length = string.length;
        if (length == 0) {
            return string;
        }
        if (JAVA_RESERVED_WORDS_SET.contains(new String(string))) {
            return StringTools.capitalize(string);
        }
        return NameTools.convertToJavaIdentifierInternal(string, c);
    }

    private static char[] convertToJavaIdentifierInternal(char[] string, char c) {
        if (!Character.isJavaIdentifierStart(string[0])) {
            if (!Character.isJavaIdentifierStart(c)) {
                throw new IllegalArgumentException("invalid Java identifier start char: '" + c + "'");
            }
            string[0] = c;
        }
        if (!Character.isJavaIdentifierPart(c)) {
            throw new IllegalArgumentException("invalid Java identifier part char: '" + c + "'");
        }
        int i = string.length;
        while (i-- > 1) {
            if (Character.isJavaIdentifierPart(string[i])) continue;
            string[i] = c;
        }
        return string;
    }

    private NameTools() {
        throw new UnsupportedOperationException();
    }
}

