/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.core.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.eclipse.wtp.jsf.core.internal.Messages;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.adapter.MaintainDefaultImplementationAdapter;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.impl.JSFLibraryRegistryPackageImpl;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryResourceFactoryImpl;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryResourceImpl;
import org.eclipse.wtp.jsf.core.jsflibraryregistry.PluginProvidedJSFLibraryCreationHelper;
import org.osgi.framework.BundleContext;

public class JSFCorePlugin
extends WTPPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wtp.jsf.core";
    public static final String FACET_ID = "wtp.jsf";
    private static JSFCorePlugin plugin;
    private static final String JSF_LIBRARY_REGISTRY_URL = ".metadata/.plugins/org.eclipse.wtp.jsf.core/JSFLibraryRegistry.xml";
    private static final String JSF_LIBRARY_REGISTRY_NSURI = "http://www.eclipse.org/webtools/jsf/schema/jsflibraryregistry.xsd";
    public static final String LIB_EXT_PT = "jsfLibraries";
    private JSFLibraryRegistryResourceImpl jsfLibraryRegistryResource = null;
    private JSFLibraryRegistry jsfLibraryRegistry = null;

    public JSFCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.loadJSFLibraryRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        this.saveJSFLibraryRegistry();
        super.stop(context);
        plugin = null;
    }

    public static JSFCorePlugin getDefault() {
        return plugin;
    }

    public JSFLibraryRegistry getJSFLibraryRegistry() {
        return this.jsfLibraryRegistry;
    }

    public void loadJSFLibraryRegistry() {
        try {
            URL jsfLibRegURL = new URL(Platform.getInstanceLocation().getURL(), JSF_LIBRARY_REGISTRY_URL);
            URI jsfLibRegURI = URI.createURI((String)jsfLibRegURL.toString());
            EPackage.Registry.INSTANCE.put((Object)JSF_LIBRARY_REGISTRY_NSURI, (Object)JSFLibraryRegistryPackageImpl.init());
            JSFLibraryRegistryResourceFactoryImpl resourceFactory = new JSFLibraryRegistryResourceFactoryImpl();
            this.jsfLibraryRegistryResource = (JSFLibraryRegistryResourceImpl)resourceFactory.createResource(jsfLibRegURI);
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DISABLE_NOTIFY", Boolean.TRUE);
                this.jsfLibraryRegistryResource.load(options);
                this.jsfLibraryRegistry = (JSFLibraryRegistry)this.jsfLibraryRegistryResource.getContents().get(0);
                this.loadJSFLibraryExtensions();
            }
            catch (IOException ioe) {
                JSFCorePlugin.log(1, Messages.JSFLibraryRegistry_NoLoadCreatingNew, ioe);
                this.jsfLibraryRegistry = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibraryRegistry();
                this.jsfLibraryRegistryResource.getContents().add((Object)this.jsfLibraryRegistry);
                this.loadJSFLibraryExtensions();
            }
            if (this.jsfLibraryRegistry != null) {
                this.jsfLibraryRegistry.eAdapters().add((Object)MaintainDefaultImplementationAdapter.getInstance());
            }
        }
        catch (MalformedURLException mue) {
            JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorCreatingURL, mue);
        }
    }

    private void loadJSFLibraryExtensions() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, LIB_EXT_PT);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    PluginProvidedJSFLibraryCreationHelper newLibCreator = new PluginProvidedJSFLibraryCreationHelper(ext.getConfigurationElements()[j]);
                    JSFLibrary newLib = newLibCreator.create();
                    if (newLib != null) {
                        this.jsfLibraryRegistry.addJSFLibrary(newLib);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorLoadingFromExtPt, e);
        }
    }

    public boolean saveJSFLibraryRegistry() {
        boolean saved = false;
        if (this.jsfLibraryRegistryResource != null) {
            try {
                this.jsfLibraryRegistryResource.save(Collections.EMPTY_MAP);
                saved = true;
            }
            catch (IOException ioe) {
                JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorSaving, ioe);
            }
        } else {
            JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorSaving);
        }
        return saved;
    }

    public static void log(Exception e, String msg) {
        ILog log = JSFCorePlugin.getDefault().getLog();
        log.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void log(int severity, String message, Throwable ex) {
        JSFCorePlugin.getDefault().getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, message, ex));
    }

    public static void log(int severity, String message) {
        JSFCorePlugin.log(severity, message, null);
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }
}

