/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.BaseSectionPartCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.MessageBundleSelectionDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;

public class AddMessageBundleCommand
extends BaseSectionPartCommand {
    private Object model;
    private IProject currentProject;
    private List currentResourceBundleList;

    public AddMessageBundleCommand(String label, ISSESectionPart sectionPart) {
        super(label, sectionPart);
        this.model = sectionPart.getModel();
    }

    public AddMessageBundleCommand(String label, IStructuredModel model) {
        super(label, model);
        this.model = model;
    }

    protected void doExecute() {
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = EditorPlugin.getActiveWorkbenchWindow();
        shell = workbenchWindow.getShell() != null ? workbenchWindow.getShell() : new Shell();
        this.currentResourceBundleList = this.getResourceBundleList();
        MessageBundleSelectionDialog dialog = new MessageBundleSelectionDialog(shell, this.getJavaProject(), this.currentResourceBundleList);
        if (dialog.open() == 0) {
            String newValue = (String)dialog.getResult()[0];
            this.createNewResourceBundle(newValue);
        }
    }

    private void createNewResourceBundle(String newResourceBundleString) {
        IDOMDocument document = ((IDOMModel)this.model).getDocument();
        NodeWrapUtil documentWrapUtil = new NodeWrapUtil((IDOMNode)document);
        NodeWrapUtil facesConfigWrap = new NodeWrapUtil((IDOMNode)documentWrapUtil.getChildNode("faces-config"));
        if (facesConfigWrap != null) {
            IDOMNode applicationNode = (IDOMNode)facesConfigWrap.getChildNode("application");
            if (applicationNode == null) {
                applicationNode = facesConfigWrap.createChildNode("application", false, null, FacesConfigOrderHelper.getInstance());
            }
            NodeWrapUtil applicationNodeUtil = new NodeWrapUtil(applicationNode);
            applicationNodeUtil.createChildNode("message-bundle", false, newResourceBundleString, FacesConfigOrderHelper.getInstance());
        }
    }

    private List getResourceBundleList() {
        IDOMNode applicationNode;
        IDOMDocument document = ((IDOMModel)this.model).getDocument();
        NodeWrapUtil documentWrapUtil = new NodeWrapUtil((IDOMNode)document);
        NodeWrapUtil facesConfigWrap = new NodeWrapUtil((IDOMNode)documentWrapUtil.getChildNode("faces-config"));
        if (facesConfigWrap != null && (applicationNode = (IDOMNode)facesConfigWrap.getChildNode("application")) != null) {
            NodeWrapUtil applicationWrap = new NodeWrapUtil(applicationNode);
            List resourceBundles = applicationWrap.getChildNodes("message-bundle");
            return resourceBundles;
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        this.currentProject = this.getProject();
        try {
            if (this.currentProject != null && this.currentProject.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)this.currentProject);
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected IProject getProject() {
        if (this.currentProject != null) {
            return this.currentProject;
        }
        if (this.model instanceof IStructuredModel) {
            this.currentProject = StructuredModelUtil.getProjectFor((IStructuredModel)this.model);
        }
        return this.currentProject;
    }
}

