/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.logging.Logger;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFPage;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.impl.PageflowNodeImpl;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.WebrootUtil;

public class OpenEditorCommand
extends Command {
    private PageflowNodeImpl child = null;
    private EditPart part;
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = EditorPlugin.getLogger(clazz);
    }

    public boolean canExecute() {
        return true;
    }

    public OpenEditorCommand(EditPart part) {
        super(EditorResources.getInstance().getString("Pageflow.Commands.OpenEditorCommand.Label"));
        this.part = part;
    }

    public void setChild(PageflowNodeImpl child) {
        this.child = child;
    }

    public PageflowNodeImpl getChild() {
        return this.child;
    }

    private void executeOpenPFPage() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String pagePath = ((PFPage)this.part.getModel()).getPath();
        if (pagePath != null && pagePath.length() > 0) {
            String resourceName = WebrootUtil.getProjectPath((EObject)this.part.getModel(), pagePath);
            Path resourcePath = new Path(resourceName);
            if (resourcePath.getFileExtension() != null && WebrootUtil.isValidWebFile((IPath)resourcePath)) {
                IFile file = (IFile)workspaceRoot.findMember((IPath)resourcePath);
                this.openExistingJSFFile(file);
            } else {
                EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFTitle", "Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFFolderInfo");
            }
        } else {
            EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFTitle", "Pageflow.PageflowEditor.Alert.confirmCreateNewJSFFile");
        }
    }

    private void openExistingJSFFile(final IFile file) {
        if (file != null && file.exists()) {
            Display display = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        log.error("Pageflow.PageflowEditor.Error.canNotOpenEditor4JSF", (Throwable)e);
                        EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFTitle", "Pageflow.PageflowEditor.Error.CanNotOpenEditor4JSF");
                    }
                }
            });
        } else {
            String pagePath = ((PFPage)this.part.getModel()).getPath();
            EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFTitle", "Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFInfo", (Object)pagePath);
        }
    }

    public void execute() {
        if (this.part.getModel() instanceof PFPage) {
            this.executeOpenPFPage();
        }
    }
}

