/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ClassButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusInfo;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Property;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.PropertyRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;

public class EditPropertyGeneralGroup
extends DialogFieldGroup {
    private PropertyRecorder propertyRecorder;
    private StringDialogField propertyNameField;
    private ClassButtonDialogField propertyClassField;
    private StringDialogField defaultValueField;
    private StringDialogField suggestedValueField;
    private IProject currentProject;
    private static EditorResources resource = EditorResources.getInstance();

    public EditPropertyGeneralGroup(PropertyRecorder propertyRecorder) {
        this.propertyRecorder = propertyRecorder;
    }

    public void initialize() {
        this.propertyNameField = new StringDialogField();
        this.propertyNameField.setLabelText(resource.getString("ComponentsPage.PropertiesSection.Wizard.Page.General.PropertyName"));
        this.propertyNameField.setText(this.propertyRecorder.getPropertyName());
        this.propertyNameField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.propertyNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditPropertyGeneralGroup.this.propertyRecorder.setPropertyName(EditPropertyGeneralGroup.this.propertyNameField.getText());
            }
        });
        this.propertyClassField = new ClassButtonDialogField(this.getProject());
        this.propertyClassField.setLabelText(resource.getString("ComponentsPage.PropertiesSection.Wizard.Page.General.PropertyClass"));
        this.propertyClassField.setText(this.propertyRecorder.getPropertyClass());
        this.propertyClassField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.propertyClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditPropertyGeneralGroup.this.propertyRecorder.setPropertyClass(EditPropertyGeneralGroup.this.propertyClassField.getText());
            }
        });
        this.propertyClassField.setAutoOpenResource(false);
        this.defaultValueField = new StringDialogField();
        this.defaultValueField.setLabelText(resource.getString("ComponentsPage.PropertiesSection.Wizard.Page.General.DefaultValue"));
        this.defaultValueField.setText(this.propertyRecorder.getDefaultValue());
        this.defaultValueField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.defaultValueField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditPropertyGeneralGroup.this.propertyRecorder.setDefaultValue(EditPropertyGeneralGroup.this.defaultValueField.getText());
            }
        });
        this.suggestedValueField = new StringDialogField();
        this.suggestedValueField.setLabelText(resource.getString("ComponentsPage.PropertiesSection.Wizard.Page.General.SuggestedValue"));
        this.suggestedValueField.setText(this.propertyRecorder.getSuggestedValue());
        this.suggestedValueField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.suggestedValueField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditPropertyGeneralGroup.this.propertyRecorder.setSuggestedValue(EditPropertyGeneralGroup.this.suggestedValueField.getText());
            }
        });
    }

    protected IProject getProject() {
        IDOMNode node;
        Property property;
        if (this.currentProject == null && (property = this.propertyRecorder.getProperty()) != null && (node = property.getNode()) != null) {
            this.currentProject = StructuredModelUtil.getProjectFor((IStructuredModel)node.getModel());
        }
        return this.currentProject;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
        this.propertyClassField.setProject(project);
    }

    public void refreshData() {
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        parent.setLayout((Layout)gl);
        this.propertyNameField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.propertyClassField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.defaultValueField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.defaultValueField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.suggestedValueField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.propertyClassField.getTextControl(toolkit, parent));
    }

    public IStatus[] validateDialogFields() {
        StatusInfo nameStatus = new StatusInfo();
        StatusInfo classStatus = new StatusInfo();
        IStatus[] status = new IStatus[]{nameStatus, classStatus};
        if (this.propertyNameField.getText().length() == 0) {
            nameStatus.setError(resource.getString("ComponentsPage.PropertiesSection.Wizard.Page.EditPropertyGeneralGroup.Error.NameEmpty"));
        }
        if (this.propertyClassField.getText().length() == 0) {
            classStatus.setError(resource.getString("ComponentsPage.PropertiesSection.Wizard.Page.EditPropertyGeneralGroup.Error.ClassEmpty"));
        }
        return status;
    }
}

