/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldBase;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.SWTUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.IDialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ListEntriesRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.TypeSelectionDialogUtil;

public class ListEntriesEditGroup
extends DialogFieldGroup
implements IDialogFieldGroup {
    private static EditorResources resource = EditorResources.getInstance();
    private StringButtonDialogField valueClassField;
    private DialogField valuesTitle;
    private FormToolkit toolkit;
    private Composite parent;
    private static final int VALUE_COL_WIDTH = 250;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private ListEntriesRecorder listEntries;
    private IProject currentProject;
    private Table listTable;
    private Button addButton;
    private Button removeButton;
    private Button editButton;

    public ListEntriesEditGroup(ListEntriesRecorder listEntries) {
        this.listEntries = listEntries;
    }

    public void initialize() {
        this.valueClassField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                TypeSelectionDialogUtil.handleFindType(((StringButtonDialogField)field).getTextControl(ListEntriesEditGroup.this.toolkit, ListEntriesEditGroup.this.parent), ListEntriesEditGroup.this.getProject());
            }
        });
        this.valueClassField.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.MapType.ValueClass"));
        this.valuesTitle = new DialogFieldBase();
        this.valuesTitle.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.MapTable.Title"));
    }

    public void refreshData() {
        if (this.listEntries != null) {
            this.clearAll();
            this.valueClassField.setTextWithoutUpdate(this.listEntries.getValueClass());
            Iterator iter = this.listEntries.getListEntries().iterator();
            while (iter.hasNext()) {
                ListEntriesRecorder.ListEntry mapEntry = (ListEntriesRecorder.ListEntry)iter.next();
                this.addListItem(mapEntry);
            }
        }
        this.updateButtonsStatus();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.parent = parent;
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        this.layoutListTypeSelectionSection(toolkit, parent);
        this.createAndLayoutListValueSection(toolkit, parent);
    }

    private void layoutListTypeSelectionSection(FormToolkit toolkit, Composite container) {
        Composite typeSelectionSection = null;
        if (toolkit != null) {
            typeSelectionSection = toolkit.createComposite(container);
            toolkit.paintBordersFor(typeSelectionSection);
        } else {
            typeSelectionSection = SWTUtils.createComposite((Composite)container, (int)0);
        }
        GridData gd = new GridData(768);
        typeSelectionSection.setLayoutData((Object)gd);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        typeSelectionSection.setLayout((Layout)gl);
        this.valueClassField.doFillIntoGrid(toolkit, typeSelectionSection, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.valueClassField.getTextControl(toolkit, container));
    }

    private void createAndLayoutListValueSection(FormToolkit toolkit, Composite parent) {
        Composite listValueSection = null;
        if (toolkit != null) {
            listValueSection = toolkit.createComposite(parent);
            toolkit.paintBordersFor(listValueSection);
        } else {
            listValueSection = SWTUtils.createComposite((Composite)parent, (int)0);
        }
        GridData gd = new GridData(1808);
        listValueSection.setLayoutData((Object)gd);
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        listValueSection.setLayout((Layout)gl);
        this.valuesTitle.doFillIntoGrid(toolkit, listValueSection, numberOfColumns);
        this.listTable = toolkit == null ? new Table(listValueSection, 68352) : new Table(listValueSection, 66304);
        this.listTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListEntriesEditGroup.this.updateButtonsStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ListEntriesEditGroup.this.updateButtonsStatus();
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        this.listTable.setLayoutData((Object)gd);
        this.listTable.setHeaderVisible(true);
        this.listTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(250));
        this.listTable.setLayout((Layout)layout);
        TableColumn valueCol = new TableColumn(this.listTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        valueCol.setText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.MapTable.Value"));
        valueCol.setResizable(true);
        Composite operationContainer = null;
        operationContainer = toolkit != null ? toolkit.createComposite(listValueSection) : SWTUtils.createComposite((Composite)listValueSection, (int)0);
        gd = new GridData(1040);
        operationContainer.setLayoutData((Object)gd);
        gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        this.addButton = null;
        this.addButton = toolkit != null ? toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Add.Name"), 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Add.Name"));
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.addButton.setLayoutData((Object)gd);
        this.editButton = null;
        this.editButton = toolkit != null ? toolkit.createButton(operationContainer, resource.getString("ListEntriesEditGroup.Edit"), 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)resource.getString("ListEntriesEditGroup.Edit"));
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = null;
        this.removeButton = toolkit != null ? toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Remove.Name"), 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Remove.Name"));
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
    }

    public void setInput(Object newInput) {
        if (newInput instanceof ListEntriesRecorder) {
            this.listEntries = (ListEntriesRecorder)newInput;
            this.refreshData();
        }
    }

    public Object getInput() {
        return this.listEntries;
    }

    private IProject getProject() {
        if (this.currentProject == null && this.listEntries.getBean() != null) {
            this.currentProject = StructuredModelUtil.getProjectFor(this.listEntries.getBean().getNode());
        }
        return this.currentProject;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
    }

    public void addListItem(ListEntriesRecorder.ListEntry listEntry) {
        TableItem item = null;
        item = new TableItem(this.listTable, 0);
        if (listEntry._valueType.equalsIgnoreCase("null-value")) {
            item.setText(0, "[null-value]");
        } else {
            item.setText(0, listEntry._value);
        }
        item.setData((Object)listEntry);
        this.listTable.setSelection(this.listTable.getItemCount());
    }

    public void updateTableItem(TableItem item, ListEntriesRecorder.ListEntry listEntry) {
        if (listEntry._valueType.equalsIgnoreCase("null-value")) {
            item.setText(0, "[null-value]");
        } else {
            item.setText(0, listEntry._value);
        }
        item.setData((Object)listEntry);
    }

    public void updateButtonsStatus() {
        if (this.listTable.getSelectionCount() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Table getListTable() {
        return this.listTable;
    }

    public StringDialogField getValueClassField() {
        return this.valueClassField;
    }

    public void clearAll() {
        this.valueClassField.setTextWithoutUpdate("");
        this.getListTable().removeAll();
        this.updateButtonsStatus();
    }

    public int findListEntry(IDOMNode node) {
        int itemIndex = -1;
        if (node != null) {
            TableItem[] items = this.listTable.getItems();
            int i = 0;
            while (i < this.listTable.getItemCount()) {
                if (((ListEntriesRecorder.ListEntry)items[i].getData())._node == node) {
                    itemIndex = i;
                    break;
                }
                ++i;
            }
        }
        return itemIndex;
    }

    public void addListEntry(IDOMNode node) {
        if (node != null && this.findListEntry(node) == -1) {
            this.addListItem(this.listEntries.addListEntry(node));
        }
    }

    public void removeListEntry(IDOMNode node) {
        int itemIndex;
        if (node != null && (itemIndex = this.findListEntry(node)) >= 0) {
            this.listTable.remove(itemIndex);
            this.listTable.select(itemIndex - 1);
            this.updateButtonsStatus();
        }
    }

    public void updateListEntry(IDOMNode node) {
        int itemIndex;
        if (node != null && (itemIndex = this.findListEntry(node)) >= 0) {
            TableItem item = this.listTable.getItem(itemIndex);
            ListEntriesRecorder.ListEntry listEntry = (ListEntriesRecorder.ListEntry)item.getData();
            this.listEntries.updateListEntry(listEntry, node);
            if (listEntry._valueType.equalsIgnoreCase("null-value")) {
                item.setText(0, "[null-value]");
            } else {
                item.setText(0, listEntry._value);
            }
            item.setData((Object)listEntry);
            this.listTable.setSelection(itemIndex);
        }
    }
}

