/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.AddElementCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.FactoryContentLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.FactoryResources;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.OthersPageBaseSection;

public class FactorySection
extends OthersPageBaseSection {
    private static FactoryResources factoryResource = FactoryResources.getInstance();
    private String childTagName;
    protected INodeSelectionListener fNodeSelectionListener;

    public FactorySection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor, String childTagName) {
        super(parent, managedForm, toolkit, factoryResource.getHelpContextID(childTagName), factoryResource.getHelpToolTip(childTagName), "factory", childTagName);
        this.page = editor;
        this.childTagName = childTagName;
        this.setText(factoryResource.getSectionText(this.childTagName));
        this.setDescription(factoryResource.getSectionDescription(this.childTagName));
    }

    protected void addButtonSelected(SelectionEvent e) {
        AddElementCommand addCommand = new AddElementCommand(factoryResource.getAddCommandLabel(this.childTagName), this.getSectionPart(), "factory", this.childTagName);
        addCommand.execute();
    }

    protected void setContentLabelProvider() {
        FactoryContentLabelProvider provider = new FactoryContentLabelProvider(this.childTagName);
        this.setLabelProvider(provider);
        this.setContentProvider((IContentProvider)provider);
    }

    public INodeSelectionListener getNodeSelectionListener() {
        if (this.fNodeSelectionListener == null) {
            this.fNodeSelectionListener = new SSENodeSelectionListener();
        }
        return this.fNodeSelectionListener;
    }

    class SSENodeSelectionListener
    implements INodeSelectionListener {
        SSENodeSelectionListener() {
        }

        public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
        }
    }
}

