/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.Separator;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.SWTUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedPropertyRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.JavaClassUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.ManagedBeanUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.SelectionUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.NewPage;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.AddEditManagedBeanPropertyDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.IManagedBeanDataSource;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.ManagedBeanConfiguration;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.NewClassWizardPage;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.WizardsResources;

public class ManagedBeanPropertyWizardPage
extends NewPage {
    private static final int DESCRIPTION_TEXT_HEIGHT = 60;
    private static final int PROPERTY_NAME_COL_WIDTH = 160;
    private static final int PROPERTY_TYPE_COL_WIDTH = 160;
    private static final int PROPERTY_VALUE_COL_WIDTH = 160;
    private static final int DEFAULT_WIDTHHINT = 10;
    private Text managedBeanNameText;
    private Combo scopeCombo;
    private Text managedBeanDescriptionText;
    private Table propertyTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Group propertySection;
    private String helpID = null;
    private ManagedBeanConfiguration managedBeanConfig;
    private List managedBeanProperties;
    private IProject currentProject;
    private String defaultScope;

    public ManagedBeanPropertyWizardPage(IStructuredSelection selection) {
        super("ManagedBeanPropertyWizardPage");
        this.defaultScope = SelectionUtil.getScope(selection);
        this.setTitle(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Title"));
        this.setDescription(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Description"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        container.setLayout((Layout)gl);
        GridData gridData = new GridData(1808);
        container.setLayoutData((Object)gridData);
        this.createGeneralSection(container);
        this.createPropertySection(container);
        this.setControl((Control)container);
        this.setPageComplete(true);
        if (this.helpID != null) {
            EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), this.helpID);
        }
        this.setSkippable(false);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(null, composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    private void createGeneralSection(Composite container) {
        Group generalSection = new Group(container, 0);
        generalSection.setText(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.General"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        generalSection.setLayout((Layout)gl);
        GridData gridData = new GridData(768);
        generalSection.setLayoutData((Object)gridData);
        SWTUtils.createLabel((Composite)generalSection, (String)WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.ManagedBeanName"), (int)1);
        this.managedBeanNameText = SWTUtils.createTextBox((Composite)generalSection, (int)1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 10;
        this.managedBeanNameText.setLayoutData((Object)gd);
        this.managedBeanNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ManagedBeanPropertyWizardPage.this.dialogChanged();
                if (ManagedBeanPropertyWizardPage.this.isValidManagedBeanName(true)) {
                    ManagedBeanPropertyWizardPage.this.setPageComplete(true);
                } else {
                    ManagedBeanPropertyWizardPage.this.setPageComplete(false);
                }
            }
        });
        SWTUtils.createLabel((Composite)generalSection, (String)WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.ManagedBeanScope"), (int)1);
        this.scopeCombo = SWTUtils.createCombo((Composite)generalSection, (String[])ManagedBean.scopeItems, (int)1);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 10;
        this.scopeCombo.setLayoutData((Object)gd);
        Label labelDesp = SWTUtils.createLabel((Composite)generalSection, (String)WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.ManagedBeanDescription"), (int)1);
        gd = new GridData(2);
        labelDesp.setLayoutData((Object)gd);
        this.managedBeanDescriptionText = SWTUtils.createTextBoxScrollable((Composite)generalSection, (int)1, (int)-1, (int)60);
    }

    private void createPropertySection(Composite container) {
        this.propertySection = new Group(container, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.propertySection.setLayout((Layout)gl);
        GridData gridData = new GridData(1808);
        this.propertySection.setLayoutData((Object)gridData);
        this.propertySection.setText(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.ManagedBeanProperty"));
        this.propertyTable = new Table((Composite)this.propertySection, 67584);
        gridData = new GridData(1808);
        gridData.widthHint = 10;
        this.propertyTable.setLayoutData((Object)gridData);
        this.propertyTable.setHeaderVisible(true);
        this.propertyTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.propertyTable.setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(160));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(160));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(160));
        this.propertyTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanPropertyWizardPage.this.updatePropertyButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeanPropertyWizardPage.this.updatePropertyButtons();
            }
        });
        TableColumn propertyCol = new TableColumn(this.propertyTable, 0);
        propertyCol.setText(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.PropertyName"));
        TableColumn typeCol = new TableColumn(this.propertyTable, 0);
        typeCol.setText(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Type"));
        TableColumn valueCol = new TableColumn(this.propertyTable, 0);
        valueCol.setText(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Value"));
        Composite buttonGroup = new Composite((Composite)this.propertySection, 0);
        buttonGroup.setLayout((Layout)new GridLayout());
        gridData = new GridData(272);
        gridData.widthHint = 96;
        buttonGroup.setLayoutData((Object)gridData);
        this.addButton = new Button(buttonGroup, 0);
        this.addButton.addSelectionListener((SelectionListener)new AddButtonSelectionListener());
        this.addButton.setLayoutData((Object)new GridData(776));
        this.addButton.setText(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Button.Add"));
        this.editButton = new Button(buttonGroup, 0);
        this.editButton.addSelectionListener((SelectionListener)new EditButtonSelectionListener());
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.setText(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Button.Edit"));
        this.removeButton = new Button(buttonGroup, 0);
        this.removeButton.addSelectionListener((SelectionListener)new RemoveButtonSelectionListener());
        this.removeButton.setLayoutData((Object)new GridData(770));
        this.removeButton.setText(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Button.Remove"));
    }

    protected void doAddButtonWidgetSelected() {
        AddEditManagedBeanPropertyDialog dlgPropertyEdit = new AddEditManagedBeanPropertyDialog(this.getShell(), null, this.currentProject, true);
        if (dlgPropertyEdit.open() == 0) {
            ManagedPropertyRecorder property = dlgPropertyEdit.getManagedPropertyRecorder();
            TableItem itemDuplicate = this.getPropertyTableItem(property.getPropertyName());
            if (itemDuplicate != null) {
                if (EditorPlugin.getAlerts().confirm("ManagedBeanPropertyWizardPage.Alert.OverwriteProperty.Title", "ManagedBeanPropertyWizardPage.Alert.OverwriteProperty.Information")) {
                    ManagedPropertyRecorder oldProperty = (ManagedPropertyRecorder)itemDuplicate.getData();
                    oldProperty.setPropertyClass(property.getPropertyClass());
                    itemDuplicate.setText(1, property.getPropertyClass());
                }
            } else {
                TableItem item = new TableItem(this.propertyTable, 0);
                item.setText(0, property.getPropertyName());
                item.setText(1, property.getPropertyClass());
                item.setText(2, property.getValue());
                item.setData((Object)property);
            }
            this.updatePropertyButtons();
        }
    }

    private TableItem getPropertyTableItem(String propertyName) {
        if (this.propertyTable.getItemCount() > 0) {
            TableItem[] items = this.propertyTable.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getText(0).equalsIgnoreCase(propertyName)) {
                    return items[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected void doRemoveButtonWidgetSelected() {
        if (this.propertyTable.getItemCount() <= 0) {
            return;
        }
        int selectionIndex = this.propertyTable.getSelectionIndex();
        if (selectionIndex == -1) {
            selectionIndex = 0;
        }
        if (EditorPlugin.getAlerts().confirm("ManagedBeanPropertyWizardPage.Alert.RemoveProperty.Title", "ManagedBeanPropertyWizardPage.Alert.RemoveProperty.Information")) {
            this.propertyTable.remove(selectionIndex);
        }
        this.updatePropertyButtons();
    }

    protected void doEditButtonWidgetSelected() {
        if (this.propertyTable.getItemCount() <= 0) {
            return;
        }
        TableItem[] selItems = this.propertyTable.getSelection();
        TableItem editItem = selItems.length > 0 ? selItems[0] : this.propertyTable.getItem(0);
        ManagedPropertyRecorder property = (ManagedPropertyRecorder)editItem.getData();
        AddEditManagedBeanPropertyDialog dlgPropertyEdit = new AddEditManagedBeanPropertyDialog(this.getShell(), property, this.currentProject, this.getManagedBeanConfiguration().isPropertyDefinitionEditable());
        if (dlgPropertyEdit.open() == 0) {
            property = dlgPropertyEdit.getManagedPropertyRecorder();
            if (this.getManagedBeanConfiguration().isPropertyDefinitionEditable()) {
                editItem.setText(0, property.getPropertyName());
                editItem.setText(1, property.getPropertyClass());
                editItem.setText(2, property.getValue());
            }
        }
        this.updatePropertyButtons();
    }

    private boolean isValidManagedBeanName(boolean reportError) {
        if (this.managedBeanNameText.getText().length() == 0) {
            if (reportError) {
                this.updateStatus(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Warning.MissingManagedBeanName"));
            }
            return false;
        }
        if (JavaClassUtils.hasIllegalCharacters(this.managedBeanNameText.getText())) {
            if (reportError) {
                this.updateStatus(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Warning.InvalidManagedBeanName"));
            }
            return false;
        }
        if (ManagedBeanUtils.isBeanDuplicate(this.currentProject, this.managedBeanNameText.getText())) {
            if (reportError) {
                this.updateStatus(WizardsResources.getInstance().getString("ManagedBeanPropertyWizardPage.Warning.DuplicateManagedBeanName"));
            }
            return false;
        }
        this.updateStatus(null);
        return true;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        this.initialize();
    }

    private void updatePropertyButtons() {
        if (this.propertyTable != null && this.propertyTable.getSelectionCount() == 1) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void loadPropertyData() {
        List mbProperties = null;
        this.propertyTable.removeAll();
        if (this.getPreviousPage() instanceof IManagedBeanDataSource) {
            mbProperties = ((IManagedBeanDataSource)this.getPreviousPage()).getManagedBeanProperty();
        }
        if (mbProperties == null) {
            return;
        }
        if (!mbProperties.isEmpty()) {
            this.propertyTable.removeAll();
            Object[] data = mbProperties.toArray();
            int i = 0;
            while (i < data.length) {
                TableItem item = new TableItem(this.propertyTable, 0);
                ManagedPropertyRecorder property = (ManagedPropertyRecorder)data[i];
                item.setText(0, property.getPropertyName());
                item.setText(1, property.getPropertyClass());
                item.setText(2, property.getValue());
                item.setData((Object)property);
                ++i;
            }
            this.managedBeanProperties = mbProperties;
        }
    }

    private boolean loadManagedBeanConfiguration() {
        ManagedBeanConfiguration mbConfigPrev = null;
        if (this.getPreviousPage() instanceof IManagedBeanDataSource) {
            mbConfigPrev = ((IManagedBeanDataSource)this.getPreviousPage()).getConfiguration();
        }
        if (mbConfigPrev == null) {
            return false;
        }
        ManagedBeanConfiguration mbConfig = this.getManagedBeanConfiguration();
        mbConfig.setFacesConfigFile(mbConfigPrev.getFacesConfigFile());
        if (!this.equalConfiguration(mbConfig, mbConfigPrev)) {
            mbConfig.setProject(mbConfigPrev.getProject());
            mbConfig.setClassName(mbConfigPrev.getClassName());
            mbConfig.setName(mbConfigPrev.getName());
            mbConfig.setPropertyEditable(mbConfigPrev.isPropertyDefinitionEditable());
            return true;
        }
        return false;
    }

    private boolean equalConfiguration(ManagedBeanConfiguration mbConfig, ManagedBeanConfiguration mbConfigPrev) {
        if (mbConfigPrev.getProject() != mbConfig.getProject()) {
            return false;
        }
        if (mbConfigPrev.getName() == null && mbConfig.getName() != null || mbConfigPrev.getName() != null && mbConfig.getName() == null || mbConfigPrev.getName() != null && mbConfig.getName() != null && !mbConfigPrev.getName().equals(mbConfig.getName())) {
            return false;
        }
        return !(mbConfigPrev.getClassName() == null && mbConfig.getClassName() != null || mbConfigPrev.getClassName() != null && mbConfig.getClassName() == null) && (mbConfigPrev.getClassName() == null || mbConfig.getClassName() == null || mbConfigPrev.getClassName().equals(mbConfig.getClassName()));
    }

    protected void dialogChanged() {
    }

    protected void initialize() {
        if (this.propertySection != null) {
            if (this.getPreviousPage() instanceof NewClassWizardPage) {
                this.propertySection.setVisible(true);
            } else {
                this.propertySection.setVisible(false);
            }
        }
        if (this.loadManagedBeanConfiguration()) {
            this.currentProject = this.managedBeanConfig.getProject();
            this.managedBeanNameText.setText(this.managedBeanConfig.getName());
            this.scopeCombo.setText(this.defaultScope);
            this.loadPropertyData();
            this.addButton.setEnabled(true);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    public ManagedBeanConfiguration getManagedBeanConfiguration() {
        if (this.managedBeanConfig == null) {
            this.managedBeanConfig = new ManagedBeanConfiguration();
        }
        this.managedBeanConfig.setName(this.managedBeanNameText.getText());
        this.managedBeanConfig.setScope(this.scopeCombo.getText());
        this.managedBeanConfig.setDescription(this.managedBeanDescriptionText.getText());
        return this.managedBeanConfig;
    }

    public List getManagedBeanProperty() {
        if (this.managedBeanProperties == null) {
            this.managedBeanProperties = new ArrayList();
        }
        this.managedBeanProperties.clear();
        if (this.propertyTable.getItemCount() > 0) {
            TableItem[] items = this.propertyTable.getItems();
            int i = 0;
            while (i < items.length) {
                this.managedBeanProperties.add(items[i].getData());
                ++i;
            }
        }
        return this.managedBeanProperties;
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        ManagedBeanConfiguration config = this.getManagedBeanConfiguration();
        data.add(new String[]{WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Summary.ManagedBeanName"), config.getName()});
        data.add(new String[]{WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Summary.ManagedBeanScope"), config.getScope()});
        return data;
    }

    public void setDefaultScope(String scope) {
        this.defaultScope = scope;
    }

    private class AddButtonSelectionListener
    extends SelectionAdapter {
        private AddButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ManagedBeanPropertyWizardPage.this.doAddButtonWidgetSelected();
        }
    }

    private class RemoveButtonSelectionListener
    extends SelectionAdapter {
        private RemoveButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ManagedBeanPropertyWizardPage.this.doRemoveButtonWidgetSelected();
        }
    }

    private class EditButtonSelectionListener
    extends SelectionAdapter {
        private EditButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ManagedBeanPropertyWizardPage.this.doEditButtonWidgetSelected();
        }
    }
}

