/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;

public class StatusUtil {
    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1 == null && s2 == null) {
            return null;
        }
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus getMostSevere(IStatus[] status) {
        if (status == null) {
            return null;
        }
        IStatus max = null;
        int i = 0;
        while (i < status.length) {
            IStatus curr = status[i];
            if (curr != null) {
                if (curr.matches(4)) {
                    return curr;
                }
                if (max == null || curr.getSeverity() > max.getSeverity()) {
                    max = curr;
                }
            }
            ++i;
        }
        if (max == null) {
            return null;
        }
        return max;
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        if (status == null) {
            page.setMessage(null);
            page.setErrorMessage(null);
        } else {
            String message = status.getMessage();
            switch (status.getSeverity()) {
                case 0: {
                    page.setMessage(message, 0);
                    page.setErrorMessage(null);
                    break;
                }
                case 2: {
                    page.setMessage(message, 2);
                    page.setErrorMessage(null);
                    break;
                }
                case 1: {
                    page.setMessage(message, 1);
                    page.setErrorMessage(null);
                    break;
                }
                default: {
                    if (message.length() == 0) {
                        message = null;
                    }
                    page.setMessage(null);
                    page.setErrorMessage(message);
                }
            }
        }
    }
}

