/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.SWTUtils;

public abstract class CollapsableSection {
    protected FormToolkit toolkit;
    protected Section section;
    protected ScrolledComposite scomp;
    protected String title;
    protected int expansionStyle;

    public CollapsableSection(FormToolkit toolkit, ScrolledComposite scomp, String title, boolean bCollapsed) {
        this.toolkit = toolkit;
        this.scomp = scomp;
        this.title = title;
        this.expansionStyle = 10;
        this.expansionStyle = bCollapsed ? (this.expansionStyle |= 0x20) : (this.expansionStyle |= 0x40);
    }

    public abstract void setCollapsableContent(Composite var1);

    public Control createControl(Composite parent, int horizontalSpan) {
        this.section = this.toolkit.createSection(parent, this.expansionStyle);
        this.section.clientVerticalSpacing = 5;
        this.section.setText(this.title);
        this.toolkit.createCompositeSeparator((Composite)this.section);
        this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent event) {
                SWTUtils.computeScrollArea(CollapsableSection.this.scomp, (Composite)CollapsableSection.this.scomp.getContent());
            }
        });
        Composite content = new Composite((Composite)this.section, 0);
        this.setCollapsableContent(content);
        this.section.setClient((Control)content);
        GridData gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        this.section.setLayoutData((Object)gd);
        return this.section;
    }

    public void setExpanded(boolean expanded) {
        if (this.section != null) {
            this.section.setExpanded(expanded);
            SWTUtils.computeScrollArea(this.scomp, (Composite)this.scomp.getContent());
        }
    }

    public Section getSection() {
        return this.section;
    }
}

