/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.utils;

import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PluginImageHelper {
    private static PluginImageHelper instance = null;
    private HashMap imageDescRegistry = null;
    private static final String PLUGIN_SEPARATOR = "^";

    public static synchronized PluginImageHelper getInstance() {
        if (instance == null) {
            instance = new PluginImageHelper();
        }
        return instance;
    }

    private Image createImage(String resource, String pluginId) {
        ImageDescriptor desc = this.getImageDescriptor(resource, pluginId);
        Image image = null;
        if (desc != null) {
            image = desc.createImage();
            if (!desc.equals(ImageDescriptor.getMissingImageDescriptor())) {
                String thePluginId = pluginId;
                if (thePluginId == null) {
                    return null;
                }
                String key = String.valueOf(thePluginId) + PLUGIN_SEPARATOR + resource;
                this.getImageRegistry().put(key, image);
            }
        }
        return image;
    }

    private ImageDescriptor createImageDescriptor(String imageFilePath, String pluginId) {
        String thePluginId = pluginId;
        if (thePluginId == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)thePluginId, (String)imageFilePath);
        if (imageDescriptor != null) {
            String key = String.valueOf(thePluginId) + PLUGIN_SEPARATOR + imageFilePath;
            this.getImageDescriptorRegistry().put(key, imageDescriptor);
        } else {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public Image getImage(String resource) {
        return this.getImage(resource, null);
    }

    public Image getImage(String resource, String pluginId) {
        String thePluginId = pluginId;
        if (thePluginId == null) {
            return null;
        }
        String key = String.valueOf(thePluginId) + PLUGIN_SEPARATOR + resource;
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            image = this.createImage(resource, pluginId);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String resource) {
        return this.getImageDescriptor(resource, null);
    }

    public ImageDescriptor getImageDescriptor(String resource, String pluginId) {
        ImageDescriptor imageDescriptor = null;
        String thePluginId = pluginId;
        if (thePluginId == null) {
            return null;
        }
        String key = String.valueOf(thePluginId) + PLUGIN_SEPARATOR + resource;
        Object o = this.getImageDescriptorRegistry().get(key);
        imageDescriptor = o == null ? this.createImageDescriptor(resource, pluginId) : (ImageDescriptor)o;
        return imageDescriptor;
    }

    private HashMap getImageDescriptorRegistry() {
        if (this.imageDescRegistry == null) {
            this.imageDescRegistry = new HashMap();
        }
        return this.imageDescRegistry;
    }

    private ImageRegistry getImageRegistry() {
        return JFaceResources.getImageRegistry();
    }
}

