/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.common.dialogfield;

import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RadiosDialogField
extends DialogFieldBase {
    private static final String INDEXKEY = "INDEX";
    private Composite group;
    private String[] items;
    private Button[] button;
    private int selectIndex = -1;
    private boolean fireEvent = true;

    public void setItems(String[] items) {
        this.items = items;
        this.button = new Button[this.items.length];
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(toolkit, parent);
        requiredLabel.setLayoutData((Object)RadiosDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)RadiosDialogField.gridDataForLabel(1));
        this.group = this.getGroup(toolkit, parent);
        this.group.setLayoutData((Object)RadiosDialogField.gridDataForGroup(nColumns - 2));
        return new Control[]{requiredLabel, label, this.group};
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForGroup(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.group)) {
            this.group.setFocus();
        }
        return true;
    }

    public Composite getGroup(FormToolkit toolkit, Composite parent) {
        if (this.group == null) {
            this.assertCompositeNotNull(parent);
            this.group = toolkit != null ? toolkit.createComposite(parent) : new Composite(parent, 0);
            RowLayout layout = new RowLayout();
            layout.marginBottom = 0;
            this.group.setLayout((Layout)layout);
            int i = 0;
            while (i < this.items.length) {
                if (toolkit != null) {
                    this.button[i] = toolkit.createButton(this.group, this.items[i], 16);
                } else {
                    this.button[i] = new Button(this.group, 16);
                    this.button[i].setText(this.items[i]);
                }
                this.button[i].setData(INDEXKEY, (Object)new Integer(i));
                this.button[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (RadiosDialogField.this.fireEvent) {
                            RadiosDialogField.this.selectIndex = (Integer)e.widget.getData(RadiosDialogField.INDEXKEY);
                            if (((Button)e.widget).getSelection()) {
                                RadiosDialogField.this.dialogFieldChangedAndApplied();
                            }
                        }
                    }
                });
                ++i;
            }
        }
        return this.group;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.group)) {
            this.group.setEnabled(this.isEnabled());
        }
    }

    public void setSelectedIndex(int index) {
        this.selectIndex = index;
        if (this.isOkToUse((Control)this.group)) {
            if (this.selectIndex >= 0 && this.selectIndex < this.items.length) {
                this.button[this.selectIndex].setSelection(true);
            } else {
                int i = 0;
                while (i < this.items.length) {
                    if (this.button[i].getSelection()) {
                        this.button[i].setSelection(false);
                    }
                    ++i;
                }
            }
        }
        this.dialogFieldChangedAndApplied();
    }

    public void setSelectedIndexWithoutUpdate(int index) {
        this.selectIndex = index;
        if (this.isOkToUse((Control)this.group)) {
            this.fireEvent = false;
            if (this.selectIndex >= 0 && this.selectIndex < this.items.length) {
                this.button[this.selectIndex].setSelection(true);
            } else {
                int i = 0;
                while (i < this.items.length) {
                    if (this.button[i].getSelection()) {
                        this.button[i].setSelection(false);
                    }
                    ++i;
                }
            }
            this.fireEvent = true;
        }
    }

    public int getSelectedIndex() {
        return this.selectIndex;
    }

    public void handleGrabHorizontal() {
        LayoutUtil.setGrabHorizontal((Control)this.group, true);
    }
}

