/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.facesconfig.edit.provider.FacesConfigEditPlugin;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.PossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.ValidationMessage;
import org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues.MethodBindingType;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ActionType
extends MethodBindingType
implements IPossibleValues {
    protected static final ImageDescriptor MISSING_IMAGE = ImageDescriptor.getMissingImageDescriptor();
    private static final String IMAGE_NAME = "/icons/full/obj16/NavigationCaseType.gif";
    private ImageDescriptor imageDescriptor;
    private List validationMessages;

    public boolean isValidValue(String value) {
        if (value != null && value.length() > 0) {
            return true;
        }
        ValidationMessage msg = new ValidationMessage(Messages.ActionType_invalid_value);
        this.getValidationMessages().add(msg);
        return false;
    }

    public List getValidationMessages() {
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList();
        }
        return this.validationMessages;
    }

    public List getPossibleValues() {
        ArrayList ret = new ArrayList();
        IWorkspaceContextResolver wr = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this.getStructuredDocumentContext());
        if (wr != null) {
            IFile jsp = (IFile)wr.getResource();
            List rules = JSFAppConfigManager.getInstance((IProject)wr.getProject()).getNavigationRulesForPage(jsp);
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                NavigationRuleType rule = (NavigationRuleType)it.next();
                ret.addAll(this.createProposals(rule));
            }
        }
        return ret;
    }

    private List createProposals(NavigationRuleType rule) {
        ArrayList<PossibleValue> ret = new ArrayList<PossibleValue>();
        EList cases = rule.getNavigationCase();
        Iterator it = cases.iterator();
        while (it.hasNext()) {
            NavigationCaseType navCase = (NavigationCaseType)it.next();
            ret.add(this.createProposal(rule, navCase));
        }
        return ret;
    }

    private PossibleValue createProposal(NavigationRuleType rule, NavigationCaseType navCase) {
        PossibleValue pv = null;
        try {
            String value = null;
            String ruleDisp = null;
            String navDisplay = null;
            String navAction = null;
            String toViewId = null;
            if (navCase.getFromOutcome() != null) {
                value = navCase.getFromOutcome().getTextContent();
            }
            if (navCase.getToViewId() != null) {
                toViewId = navCase.getToViewId().getTextContent();
            }
            if (rule.getFromViewId() != null) {
                ruleDisp = rule.getFromViewId().getTextContent();
            }
            if (navCase.getDisplayName() != null && navCase.getDisplayName().size() > 0) {
                navDisplay = ((DisplayNameType)navCase.getDisplayName().get(0)).getTextContent();
            }
            if (navCase.getFromAction() != null) {
                navAction = navCase.getFromAction().getTextContent();
            }
            if (navDisplay == null || navDisplay.trim().equals("")) {
                navDisplay = NLS.bind((String)Messages.ActionType_navcase_display, (Object[])new String[]{value, toViewId});
            }
            if (value != null) {
                pv = new PossibleValue(value, navDisplay);
                pv.setIcon(this.getNavCaseImageDescriptor());
                pv.setAdditionalInformation("from-outcome: " + value + "<br>to-view-id: " + toViewId + "<br>from-view-id: " + ruleDisp + "<br>from-action: " + (navAction == null ? "null" : navAction));
            }
        }
        catch (NullPointerException nullPointerException) {}
        return pv;
    }

    private ImageDescriptor getNavCaseImageDescriptor() {
        ImageDescriptor ret = super.getImage();
        if (ret != null && ret != MISSING_IMAGE) {
            return ret;
        }
        if (this.imageDescriptor == null) {
            this.imageDescriptor = this.getImageDesc(IMAGE_NAME);
        }
        return this.imageDescriptor;
    }

    private ImageDescriptor getImageDesc(String img) {
        ImageDescriptor desc;
        block3: {
            try {
                Bundle bundle = FacesConfigEditPlugin.getPlugin().getBundle();
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(img), null);
                desc = ImageDescriptor.createFromURL((URL)url);
                if (desc != MISSING_IMAGE) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return desc;
    }
}

