/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.operators;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.core.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.core.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.core.internal.types.LiteralType;
import org.eclipse.jst.jsf.core.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.core.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.core.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.el.operators.ArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.DiagnosticFactory;

class ModArithmeticBinaryOperator
extends ArithmeticBinaryOperator {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    ModArithmeticBinaryOperator() {
    }

    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return IntegerLiteralType.ZERO;
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDouble;".equals(boxedFirstArg) || "Ljava.math.BigDouble;".equals(boxedSecondArg) || "Ljava.lang.Float;".equals(boxedFirstArg) || "Ljava.lang.Float;".equals(boxedSecondArg) || "Ljava.lang.String;".equals(boxedFirstArg) || "Ljava.lang.String;".equals(boxedSecondArg)) {
            return this.performDouble(firstArg, secondArg);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.performBigInteger(firstArg, secondArg);
        }
        return this.performLong(firstArg, secondArg);
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return DiagnosticFactory.create_BINARY_OP_BOTH_OPERANDS_NULL("modulo");
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDouble;".equals(boxedFirstArg) || "Ljava.math.BigDouble;".equals(boxedSecondArg) || "Ljava.lang.Float;".equals(boxedFirstArg) || "Ljava.lang.Float;".equals(boxedSecondArg) || "Ljava.lang.String;".equals(boxedFirstArg) || "Ljava.lang.String;".equals(boxedSecondArg)) {
            return this.validateDouble(firstArg, secondArg);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.validateBigInteger(firstArg, secondArg);
        }
        return this.validateLong(firstArg, secondArg);
    }

    private ValueType performDouble(ValueType firstArg, ValueType secondArg) {
        Number secondValue;
        block11: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                secondValue = null;
                if (!(secondArg instanceof LiteralType)) break block11;
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((secondValue = literalType.coerceToNumber((Class)clazz)).doubleValue() != 0.0) break block11;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        Number firstValue = null;
        if (firstArg instanceof LiteralType) {
            LiteralType literalType = (LiteralType)firstArg;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            firstValue = literalType.coerceToNumber((Class)clazz);
        }
        if (firstValue != null && secondValue != null) {
            return new FloatLiteralType(firstValue.doubleValue() % secondValue.doubleValue());
        }
        return new ValueType("D", 2);
    }

    private ValueType performBigInteger(ValueType firstArg, ValueType secondArg) {
        block6: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                if (!(secondArg instanceof LiteralType)) break block6;
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.math.BigInteger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!literalType.coerceToNumber((Class)clazz).equals(BigInteger.ZERO)) break block6;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        return new ValueType("Ljava.math.BigInteger;", 2);
    }

    private ValueType performLong(ValueType firstArg, ValueType secondArg) {
        Number secondValue;
        block11: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                secondValue = null;
                if (!(secondArg instanceof LiteralType)) break block11;
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((secondValue = literalType.coerceToNumber((Class)clazz)).longValue() != 0L) break block11;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        Number firstValue = null;
        if (firstArg instanceof LiteralType) {
            LiteralType literalType = (LiteralType)firstArg;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            firstValue = literalType.coerceToNumber((Class)clazz);
        }
        if (firstValue != null && secondValue != null) {
            return new IntegerLiteralType(firstValue.longValue() % secondValue.longValue());
        }
        return new ValueType("J", 2);
    }

    private Diagnostic validateDouble(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            Number secondValue = null;
            if (secondArg instanceof LiteralType) {
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((secondValue = literalType.coerceToNumber((Class)clazz)).doubleValue() == 0.0) {
                    return DiagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
                }
            }
            Number firstValue = null;
            if (firstArg instanceof LiteralType) {
                LiteralType literalType = (LiteralType)firstArg;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                firstValue = literalType.coerceToNumber((Class)clazz);
            }
            if (firstValue != null && secondValue != null) {
                return DiagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME("modulo", Double.toString(firstValue.doubleValue() % secondValue.doubleValue()));
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return DiagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION("modulo");
        }
    }

    private Diagnostic validateBigInteger(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            if (secondArg instanceof LiteralType) {
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.math.BigInteger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (literalType.coerceToNumber((Class)clazz).equals(BigInteger.ZERO)) {
                    return DiagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
                }
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return DiagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION("modulo");
        }
    }

    private Diagnostic validateLong(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            Number secondValue = null;
            if (secondArg instanceof LiteralType) {
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((secondValue = literalType.coerceToNumber((Class)clazz)).longValue() == 0L) {
                    return DiagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
                }
            }
            Number firstValue = null;
            if (firstArg instanceof LiteralType) {
                LiteralType literalType = (LiteralType)firstArg;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                firstValue = literalType.coerceToNumber((Class)clazz);
            }
            if (firstValue != null && secondValue != null) {
                return DiagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME("modulo", Long.toString(firstValue.longValue() % secondValue.longValue()));
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return DiagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION("modulo");
        }
    }

    protected Long doRealOperation(Long firstArg, Long secondArg) {
        return new Long(firstArg % secondArg);
    }

    protected Double doRealOperation(Double firstArg, Double secondArg) {
        return new Double(firstArg % secondArg);
    }

    protected BigDecimal doRealOperation(BigDecimal firstArg, BigDecimal secondArg) {
        return new BigDecimal(firstArg.doubleValue() % secondArg.doubleValue());
    }

    protected String getOperatorName() {
        return "modulo";
    }
}

