/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.rte;

import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionCategory;

public final class EngineeringOption
implements Cloneable {
    public static final byte BOOLEAN_OPTION = 0;
    public static final byte INTEGER_OPTION = 1;
    public static final byte STRING_OPTION = 2;
    public static final byte ENUM_OPTION = 3;
    private String id = "generated." + this.hashCode();
    private String name;
    private String desc;
    private EngineeringOptionCategory category = null;
    private boolean booleanValue;
    private int intValue;
    private String stringValue;
    private byte type;
    private EnumLiteral[] choices;

    public EngineeringOption(String name, String description, boolean initialValue) {
        this.initOption(null, name, description, initialValue, null);
    }

    public EngineeringOption(String id, String name, String description, boolean initialValue, EngineeringOptionCategory category) {
        this.initOption(id, name, description, initialValue, category);
    }

    public EngineeringOption(String name, String description, String initialValue) {
        this.initOption(null, name, description, initialValue, null);
    }

    public EngineeringOption(String id, String name, String description, String initialValue, EngineeringOptionCategory category) {
        this.initOption(id, name, description, initialValue, category);
    }

    public EngineeringOption(String name, String description, int initialValue) {
        this.initOption(null, name, description, initialValue, null);
    }

    public EngineeringOption(String id, String name, String description, int initialValue, EngineeringOptionCategory category) {
        this.initOption(id, name, description, initialValue, category);
    }

    public EngineeringOption(String name, String description, int initialValue, EnumLiteral[] choices) {
        this.initOption(null, name, description, initialValue, choices, null);
    }

    public EngineeringOption(String id, String name, String description, int initialValue, EnumLiteral[] choices, EngineeringOptionCategory category) {
        this.initOption(id, name, description, initialValue, choices, category);
    }

    public String getOptionName() {
        return this.name;
    }

    public String getOptionDescription() {
        return this.desc;
    }

    public byte getOptionType() {
        return this.type;
    }

    public EnumLiteral[] getEnumLiterals() {
        if (this.type != 3) {
            throw new RuntimeException("Invalid Call");
        }
        return this.choices;
    }

    public boolean getBoolean() {
        if (this.type != 0) {
            throw new RuntimeException("Invalid Call");
        }
        return this.booleanValue;
    }

    public int getInt() {
        if (this.type != 1 && this.type != 3) {
            throw new RuntimeException("Invalid Call");
        }
        return this.intValue;
    }

    public String getString() {
        if (this.type != 2) {
            throw new RuntimeException("Invalid Call");
        }
        return this.stringValue;
    }

    public void setBoolean(boolean value) {
        if (this.type != 0) {
            throw new RuntimeException("Invalid Call");
        }
        this.booleanValue = value;
    }

    public void setInt(int value) {
        if (this.type != 1 && this.type != 3) {
            throw new RuntimeException("Invalid Call");
        }
        this.intValue = value;
    }

    public void setString(String value) {
        if (this.type != 2) {
            throw new RuntimeException("Invalid Call");
        }
        this.stringValue = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EngineeringOptionCategory getCategory() {
        return this.category;
    }

    public void setCategory(EngineeringOptionCategory category) {
        this.category = category;
    }

    private void initOption(String id, String name, String description, boolean initialValue, EngineeringOptionCategory category) {
        this.type = 0;
        if (id != null) {
            this.id = id;
        }
        this.name = name;
        this.desc = description;
        this.booleanValue = initialValue;
        this.category = category;
    }

    public void initOption(String id, String name, String description, String initialValue, EngineeringOptionCategory category) {
        this.type = (byte)2;
        if (id != null) {
            this.id = id;
        }
        this.name = name;
        this.desc = description;
        this.stringValue = initialValue;
        this.category = category;
    }

    public void initOption(String id, String name, String description, int initialValue, EngineeringOptionCategory category) {
        this.type = 1;
        if (id != null) {
            this.id = id;
        }
        this.name = name;
        this.desc = description;
        this.intValue = initialValue;
        this.category = category;
    }

    public void initOption(String id, String name, String description, int initialValue, EnumLiteral[] choices, EngineeringOptionCategory category) {
        this.type = (byte)3;
        if (id != null) {
            this.id = id;
        }
        this.name = name;
        this.desc = description;
        this.intValue = initialValue;
        this.choices = choices;
        this.category = category;
    }

    public static final class EnumLiteral {
        private String name;
        private String desc;

        public EnumLiteral(String name, String description) {
            this.name = name;
            this.desc = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

