/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class BP1600
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1600(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                if (this.validator.isOneWayResponse(entryContext)) {
                    throw new AssertionNotApplicableException();
                }
                throw new AssertionFailException("The log message is empty or invalid.");
            }
            Element element = doc.getDocumentElement();
            if (!element.getLocalName().equals("Envelope") || !this.isSOAPNamespace(element.getNamespaceURI())) {
                throw new AssertionFailException("The top element is not soap:Envelope");
            }
            Collection envelopeNamespaces = this.collectNamespaces(element.getAttributes());
            envelopeNamespaces.add("http://www.w3.org/2000/xmlns/");
            Attr notValidAttr = this.getNotValidAttr(element.getAttributes(), envelopeNamespaces);
            if (notValidAttr != null) {
                throw new AssertionFailException("The attribute " + notValidAttr.getNodeName() + " is not namespace-qualified");
            }
            if ((element = XMLUtils.getFirstChild(element)) != null && element.getLocalName().equals("Header") && this.isSOAPNamespace(element.getNamespaceURI())) {
                Element headerEntry = XMLUtils.getFirstChild(element);
                while (headerEntry != null) {
                    Collection headerEntryNamespaces = this.collectNamespaces(headerEntry.getAttributes());
                    if (!envelopeNamespaces.contains(headerEntry.getNamespaceURI()) && !headerEntryNamespaces.contains(headerEntry.getNamespaceURI())) {
                        throw new AssertionFailException("The header entry " + headerEntry.getNodeName() + " is not namespace-qualified");
                    }
                    headerEntry = XMLUtils.getNextSibling(headerEntry);
                }
                element = XMLUtils.getNextSibling(element);
            }
            if (element == null || !element.getLocalName().equals("Body") || !this.isSOAPNamespace(element.getNamespaceURI())) {
                throw new AssertionFailException("The soap:Body element is not presented or follows an additional sub element of soap:Envelope");
            }
            element = XMLUtils.getNextSibling(element);
            while (element != null) {
                if (element.getLocalName().equals("Header") && this.isSOAPNamespace(element.getNamespaceURI())) {
                    throw new AssertionFailException("The soap:Header element cannot follow the soap:Body element");
                }
                Collection elementNamespaces = this.collectNamespaces(element.getAttributes());
                if (!envelopeNamespaces.contains(element.getNamespaceURI()) && !elementNamespaces.contains(element.getNamespaceURI())) {
                    throw new AssertionFailException("The sub envelope element " + element.getNodeName() + " is not namespace-qualified");
                }
                element = XMLUtils.getNextSibling(element);
            }
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private Collection collectNamespaces(NamedNodeMap attrs) {
        HashSet<String> ns = new HashSet<String>();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                if (attr.getNamespaceURI() != null && attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                    ns.add(attr.getValue());
                }
                ++i;
            }
        }
        return ns;
    }

    private Attr getNotValidAttr(NamedNodeMap attrs, Collection ns) {
        Attr ret = null;
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                if (attr.getNamespaceURI() == null || !ns.contains(attr.getNamespaceURI())) {
                    ret = attr;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    private boolean isSOAPNamespace(String ns) {
        if (ns == null) {
            return false;
        }
        return ns.equals("http://schemas.xmlsoap.org/soap/envelope/");
    }
}

