/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogFileType;

public class CatalogFileTypeRegistryReader {
    private static CatalogFileTypeRegistryReader _instance;
    static final String ATT_DESCRIPTION = "description";
    static final String ATT_EXTENSIONS = "extensions";
    static final String ATT_ICON = "icon";
    static final String ATT_ID = "id";
    static final String EXTENSION_POINT_ID = "catalogFileType";
    static final String TAG_NAME = "fileType";
    private HashMap hashMap = new HashMap();

    private static CatalogFileTypeRegistryReader getInstance() {
        if (_instance == null) {
            _instance = new CatalogFileTypeRegistryReader();
        }
        return _instance;
    }

    public static Collection getXMLCatalogFileTypes() {
        return CatalogFileTypeRegistryReader.getInstance().hashMap.values();
    }

    public CatalogFileTypeRegistryReader() {
        this.readRegistry();
    }

    private void readElement(IConfigurationElement element) {
        String id;
        if (element.getName().equals(TAG_NAME) && (id = element.getAttribute(ATT_ID)) != null) {
            XMLCatalogFileType fileType = (XMLCatalogFileType)this.hashMap.get(id);
            if (fileType == null) {
                fileType = new XMLCatalogFileType();
                this.hashMap.put(id, fileType);
            }
            if (fileType.description == null) {
                String description;
                fileType.description = description = element.getAttribute(ATT_DESCRIPTION);
            }
            fileType.addExtensions(element.getAttribute(ATT_EXTENSIONS));
        }
    }

    private void readRegistry() {
        this.readRegistry(EXTENSION_POINT_ID);
    }

    private void readRegistry(String extensionPointId) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint("org.eclipse.wst.xml.ui", extensionPointId);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }
}

