/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.viewers;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;

public class BrowserViewer
extends ContentViewer {
    protected Browser browser;
    protected byte[] content;

    public void init(Composite parent) {
        this.browser = new Browser(parent, 2048);
        this.browser.setLayoutData((Object)new GridData(1808));
    }

    public void setContent(byte[] b) {
        this.content = b;
        if (b == null || b.length == 0) {
            this.browser.setText(Messages.htmlViewInvalid);
        } else {
            byte cr = 13;
            byte lf = 10;
            int trimFront = 0;
            int trimBack = 0;
            int len = b.length - 1;
            while (b[trimFront] == cr || b[trimFront] == lf) {
                ++trimFront;
            }
            while (b[len - trimBack] == cr || b[len - trimBack] == lf) {
                ++trimBack;
            }
            if (trimFront + trimBack > 0) {
                byte[] temp = b;
                b = new byte[temp.length - trimBack - trimFront];
                int i = trimFront;
                while (i < temp.length - trimBack) {
                    b[i - trimFront] = temp[i];
                    ++i;
                }
            }
            this.browser.setText(new String(b));
        }
    }

    public byte[] getContent() {
        return this.content;
    }

    public void dispose() {
        this.browser.dispose();
        this.browser = null;
        this.content = null;
    }
}

