/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.actions;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.actions.LinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public abstract class NodeAction
extends LinkAction {
    protected NodeManager nodeManager_;
    private boolean requiresTreeViewRefresh_;
    private boolean requiresNodeSelection_;
    private boolean requiresViewSelection_;
    private boolean requiresStatusUpdate_;

    public NodeAction(Controller controller, NodeManager nodeManager) {
        super(controller);
        this.nodeManager_ = nodeManager;
        this.requiresTreeViewRefresh_ = false;
        this.requiresNodeSelection_ = false;
        this.requiresViewSelection_ = false;
        this.requiresStatusUpdate_ = false;
    }

    protected boolean processLinkParameters(HttpServletRequest request) {
        String nodeIdString = request.getParameter("nodeId");
        try {
            Integer.parseInt(nodeIdString);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.propertyTable_.put("nodeId", nodeIdString);
        return true;
    }

    protected final boolean isStaleNode(int nodeId) {
        return this.nodeManager_.getNode(nodeId) == null;
    }

    protected final boolean makeNodeVisible(Node node) {
        this.requiresTreeViewRefresh_ = node.getNodeManager().makeNodeVisible(node);
        return this.requiresTreeViewRefresh_;
    }

    protected final void setSelectedNodeId(int nodeId) {
        if (this.nodeManager_.getSelectedNodeId() != nodeId) {
            this.requiresNodeSelection_ = true;
            this.nodeManager_.setSelectedNodeId(nodeId);
        }
    }

    protected final void setSelectedViewId(int viewId) {
        Node selectedNode = this.nodeManager_.getSelectedNode();
        if (selectedNode.getViewId() != viewId) {
            this.requiresViewSelection_ = true;
            selectedNode.setViewId(viewId);
        }
    }

    public boolean requiresTreeViewRefresh() {
        return this.requiresTreeViewRefresh_;
    }

    public boolean requiresNodeSelection() {
        return this.requiresNodeSelection_;
    }

    public boolean requiresViewSelection() {
        return this.requiresViewSelection_;
    }

    public boolean requiresStatusUpdate() {
        return this.requiresStatusUpdate_;
    }

    protected abstract String getActionLinkForHistory();
}

