/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;
import org.eclipse.wst.common.frameworks.internal.ui.ValidationStatus;

public abstract class DataModelWizardPage
extends WizardPage
implements Listener,
IDataModelListener {
    protected static final int NEXT = 1;
    protected static final int PREVIOUS = 2;
    protected static final int COMPOSITE_BORDER = 0;
    private ValidationStatus status = new ValidationStatus();
    private boolean isValidating = false;
    protected boolean isFirstTimeToPage = true;
    protected IDataModel model;
    private Map validationMap;
    private String[] validationPropertyNames;
    protected DataModelSynchHelper synchHelper;
    private String infopopID;
    private DataModelWizard wizard;
    private IWizardPage previousPage;

    protected DataModelWizardPage(IDataModel model, String pageName) {
        super(pageName);
        this.model = model;
        model.addListener((IDataModelListener)this);
        this.synchHelper = this.initializeSynchHelper(model);
    }

    public DataModelSynchHelper initializeSynchHelper(IDataModel dm) {
        return new DataModelSynchHelper(dm);
    }

    protected DataModelWizardPage(IDataModel model, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.model = model;
        model.addListener((IDataModelListener)this);
        this.synchHelper = this.initializeSynchHelper(model);
    }

    public final void createControl(Composite parent) {
        Composite top = this.createTopLevelComposite(parent);
        this.setControl((Control)top);
        this.setupInfopop((Control)top);
        this.setDefaults();
        this.addListeners();
        this.initializeValidationProperties();
    }

    private void initializeValidationProperties() {
        this.validationPropertyNames = this.getValidationPropertyNames();
        if (this.validationPropertyNames == null || this.validationPropertyNames.length == 0) {
            this.validationMap = Collections.EMPTY_MAP;
        } else {
            this.validationMap = new HashMap(this.validationPropertyNames.length);
            int i = 0;
            while (i < this.validationPropertyNames.length) {
                this.validationMap.put(this.validationPropertyNames[i], new Integer(i));
                ++i;
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && (this.wizard != null && this.wizard.getPageGroupManager().hasNextPage() || this.getNextPage() != null);
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        if (newWizard instanceof DataModelWizard) {
            this.wizard = (DataModelWizard)newWizard;
        }
    }

    public IWizardPage getPreviousPage() {
        return this.previousPage;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        this.previousPage = page;
    }

    protected abstract String[] getValidationPropertyNames();

    protected abstract Composite createTopLevelComposite(Composite var1);

    protected void setupInfopop(Control parent) {
        if (this.getInfopopID() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, this.getInfopopID());
        }
    }

    protected void setDefaults() {
        this.restoreDefaultSettings();
    }

    protected void restoreDefaultSettings() {
    }

    protected void addListeners() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void enter() {
        try {
            if (this.wizard != null && this.wizard.getPreviousPage(this.wizard.getPageGroupManager().getCurrentPage()) == this) {
                this.wizard.getPageGroupManager().moveBackOnePage();
            }
            this.validatePage(this.showValidationErrorsOnEnter());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.isFirstTimeToPage = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.isFirstTimeToPage = false;
            return;
        }
    }

    protected boolean showValidationErrorsOnEnter() {
        return !this.isFirstTimeToPage();
    }

    protected boolean shouldValidateOnEnter() {
        return this.showValidationErrorsOnEnter();
    }

    protected void exit() {
    }

    protected boolean getStatus(Integer key) {
        return this.status.hasError(key);
    }

    public void handleEvent(Event event) {
    }

    protected void setErrorMessage() {
        String error = this.status.getLastErrMsg();
        if (error == null) {
            String warning;
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if ((warning = this.status.getLastWarningMsg()) == null) {
                if (this.getMessage() != null && this.getMessageType() == 2) {
                    this.setMessage(null, 2);
                } else {
                    String info = this.status.getLastInfoMsg();
                    if (info == null) {
                        if (this.getMessage() != null && this.getMessageType() == 1) {
                            this.setMessage(null, 1);
                        }
                    } else if (!info.equals(this.getMessage())) {
                        this.setMessage(info, 1);
                    }
                }
            } else if (!warning.equals(this.getMessage())) {
                this.setMessage(warning, 2);
            }
        } else if (!error.equals(this.getErrorMessage())) {
            this.setErrorMessage(error);
        }
    }

    protected void setErrorStatus(Integer key, String errorMessage) {
        this.status.setErrorStatus(key, errorMessage);
    }

    protected void setWarningStatus(Integer key, String warningMessage) {
        this.status.setWarningStatus(key, warningMessage);
    }

    protected void setInfoStatus(Integer key, String infoMessage) {
        this.status.setInfoStatus(key, infoMessage);
    }

    protected void setOKStatus(Integer key) {
        this.status.setOKStatus(key);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.enter();
        } else {
            this.exit();
        }
    }

    public void storeDefaultSettings() {
    }

    protected void validatePage() {
        this.validatePage(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void validatePage(boolean showMessage) {
        if (this.isValidating) return;
        this.isValidating = true;
        try {
            this.validateControlsBase();
            this.updateControls();
            if (showMessage) {
                this.setErrorMessage();
            }
            this.setPageComplete(this.status.getLastErrMsg() == null);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.isValidating = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.isValidating = false;
            return;
        }
    }

    protected final String validateControlsBase() {
        if (!this.validationMap.isEmpty()) {
            int i = 0;
            while (i < this.validationPropertyNames.length) {
                String propName = this.validationPropertyNames[i];
                Integer valKey = (Integer)this.validationMap.get(propName);
                if (valKey != null) {
                    this.validateProperty(propName, valKey);
                }
                if (!this.getStatus(valKey)) {
                    return propName;
                }
                ++i;
            }
        }
        return null;
    }

    private void validateProperty(String propertyName, Integer validationKey) {
        this.setOKStatus(validationKey);
        IStatus status1 = this.model.validateProperty(propertyName);
        if (!status1.isOK()) {
            String message = status1.isMultiStatus() ? status1.getChildren()[0].getMessage() : status1.getMessage();
            switch (status1.getSeverity()) {
                case 4: {
                    this.setErrorStatus(validationKey, message);
                    break;
                }
                case 2: {
                    this.setWarningStatus(validationKey, message);
                    break;
                }
                case 1: {
                    this.setInfoStatus(validationKey, message);
                }
            }
        }
    }

    protected void updateControls() {
    }

    protected boolean isFirstTimeToPage() {
        return this.isFirstTimeToPage;
    }

    public void setFirstTimeToPage(boolean b) {
        this.isFirstTimeToPage = b;
    }

    public void propertyChanged(DataModelEvent event) {
        String propertyName = event.getPropertyName();
        if (this.validationPropertyNames != null && (event.getFlag() == 1 || !this.isPageComplete() && event.getFlag() == 4)) {
            int i = 0;
            while (i < this.validationPropertyNames.length) {
                if (this.validationPropertyNames[i].equals(propertyName)) {
                    this.validatePage(this.showValidationErrorsOnEnter());
                    break;
                }
                ++i;
            }
        }
    }

    protected IDataModel getDataModel() {
        return this.model;
    }

    public void dispose() {
        super.dispose();
        if (this.synchHelper != null) {
            this.synchHelper.dispose();
            this.synchHelper = null;
        }
    }

    protected String getInfopopID() {
        return this.infopopID;
    }

    public void setInfopopID(String infopopID) {
        this.infopopID = infopopID;
    }
}

