/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.server.tomcat.ui.internal.Trace;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TomcatUIPlugin
extends AbstractUIPlugin {
    protected static TomcatUIPlugin singleton;
    protected Map imageDescriptors = new HashMap();
    private static URL ICON_BASE_URL;
    private static final String URL_OBJ = "obj16/";
    private static final String URL_WIZBAN = "wizban/";
    public static final String PLUGIN_ID = "org.eclipse.jst.server.tomcat.ui";
    public static final String IMG_WIZ_TOMCAT = "wizTomcat";
    public static final String IMG_WEB_MODULE = "webModule";
    public static final String IMG_MIME_MAPPING = "mimeMapping";
    public static final String IMG_MIME_EXTENSION = "mimeExtension";
    public static final String IMG_PORT = "port";
    public static final String IMG_PROJECT_MISSING = "projectMissing";
    public static final String PREF_TOMCAT32_INSTALL_DIR = "tomcat32install";
    public static final String PREF_TOMCAT40_INSTALL_DIR = "tomcat40install";
    public static final String PREF_TOMCAT41_INSTALL_DIR = "tomcat41install";
    public static final String PREF_TOMCAT50_INSTALL_DIR = "tomcat50install";
    public static final String PREF_JDK_INSTALL_DIR = "jdkinstall";

    public TomcatUIPlugin() {
        singleton = this;
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = new ImageRegistry();
        this.registerImage(registry, IMG_WIZ_TOMCAT, "wizban/tomcat_wiz.gif");
        this.registerImage(registry, IMG_WEB_MODULE, "obj16/web_module.gif");
        this.registerImage(registry, IMG_MIME_MAPPING, "obj16/mime_mapping.gif");
        this.registerImage(registry, IMG_MIME_EXTENSION, "obj16/mime_extension.gif");
        this.registerImage(registry, IMG_PORT, "obj16/port.gif");
        this.registerImage(registry, IMG_PROJECT_MISSING, "obj16/project_missing.gif");
        return registry;
    }

    public static Image getImage(String key) {
        return TomcatUIPlugin.getInstance().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            TomcatUIPlugin.getInstance().getImageRegistry();
            return (ImageDescriptor)TomcatUIPlugin.getInstance().imageDescriptors.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static TomcatUIPlugin getInstance() {
        return singleton;
    }

    public static void log(IStatus status) {
        TomcatUIPlugin.getInstance().getLog().log(status);
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        if (ICON_BASE_URL == null) {
            String pathSuffix = "icons/";
            ICON_BASE_URL = singleton.getBundle().getEntry(pathSuffix);
        }
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            registry.put(key, id);
            this.imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error registering image", e);
        }
    }
}

