/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ObserveVisibleXYLayout
extends FreeformLayout {
    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        Rectangle rect = new Rectangle();
        ListIterator children = f.getChildren().listIterator();
        while (children.hasNext()) {
            Rectangle r;
            IFigure child = (IFigure)children.next();
            if (this.isObservingVisibility() && !child.isVisible() || (r = (Rectangle)this.constraints.get(child)) == null) continue;
            if (r.width == -1 || r.height == -1) {
                Dimension preferredSize = child.getPreferredSize(r.width, r.height);
                r = r.getCopy();
                if (r.width == -1) {
                    r.width = preferredSize.width;
                }
                if (r.height == -1) {
                    r.height = preferredSize.height;
                }
            }
            rect.union(r);
        }
        Dimension d = rect.getSize();
        Insets insets = f.getInsets();
        return new Dimension(d.width + insets.getWidth(), d.height + insets.getHeight()).union(this.getBorderPreferredSize(f));
    }

    public void layout(IFigure parent) {
        Iterator children = parent.getChildren().iterator();
        Point offset = this.getOrigin(parent);
        while (children.hasNext()) {
            Rectangle bounds;
            IFigure f = (IFigure)children.next();
            if (this.isObservingVisibility() && !f.isVisible() || (bounds = (Rectangle)this.getConstraint(f)) == null) continue;
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = f.getPreferredSize(bounds.width, bounds.height);
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            bounds = bounds.getTranslated(offset);
            f.setBounds(bounds);
        }
    }
}

