/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogFieldGroup;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.NullValueType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyClassType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.NewEditorResourcesNLS;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.AddEditManagedPropertyDialog;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.IDialogFieldGroup;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ManagedPropertyEditGroup
extends DialogFieldGroup
implements IDialogFieldGroup {
    private TableViewer tableViewer;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private Button removeButton;
    private Button editButton;
    private ManagedBeanType managedBean;
    private AbstractFacesConfigSection section;

    public ManagedPropertyEditGroup(AbstractFacesConfigSection section) {
        this.section = section;
    }

    public void initialize() {
    }

    public void refreshData() {
        this.refresh();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.createGeneralClassPage(parent, toolkit);
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    private void createGeneralClassPage(Composite container, FormToolkit toolkit) {
        Composite generalSection = toolkit.createComposite(container);
        generalSection.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(generalSection);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        generalSection.setLayout((Layout)gl);
        this.createTableSection(generalSection, toolkit);
        this.createButtonsSection(generalSection, toolkit);
    }

    private void createTableSection(Composite container, FormToolkit toolkit) {
        Composite propertyContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1808);
        propertyContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(propertyContainer);
        GridLayout gl = new GridLayout();
        propertyContainer.setLayout((Layout)gl);
        Table table = new Table(propertyContainer, 68352);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn propertyCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        propertyCol.setText(NewEditorResourcesNLS.InitializationSection_PropertyTable_Name);
        propertyCol.setResizable(true);
        TableColumn classCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        classCol.setText(NewEditorResourcesNLS.InitializationSection_PropertyTable_Class);
        classCol.setResizable(true);
        TableColumn valueCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        valueCol.setText(NewEditorResourcesNLS.InitializationSection_PropertyTable_Value);
        valueCol.setResizable(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagedPropertyEditGroup.this.updateButtons();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (((IStructuredSelection)ManagedPropertyEditGroup.this.tableViewer.getSelection()).size() > 0) {
                    ManagedPropertyEditGroup.this.editButtonSelected();
                }
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.section.getAdapterFactory()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.section.getAdapterFactory()));
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FacesConfigPackage.eINSTANCE.getManagedPropertyType().isInstance(element);
            }
        });
    }

    private void updateButtons() {
        if (((IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void createButtonsSection(Composite container, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1042);
        operationContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        Button addButton = toolkit.createButton(operationContainer, NewEditorResourcesNLS.UI_Button_Add_more, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        addButton.setLayoutData((Object)gd);
        this.editButton = toolkit.createButton(operationContainer, NewEditorResourcesNLS.UI_Button_Edit_more, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = toolkit.createButton(operationContainer, NewEditorResourcesNLS.UI_Button_Remove, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagedPropertyEditGroup.this.addButtonSelected();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagedPropertyEditGroup.this.editButtonSelected();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagedPropertyEditGroup.this.removeButtonSelected();
            }
        });
    }

    protected void addButtonSelected() {
        Shell shell = EditorPlugin.getActiveShell();
        AddEditManagedPropertyDialog dialog = new AddEditManagedPropertyDialog(shell, this.managedBean, this.section);
        if (dialog.open() == 0) {
            ManagedPropertyType managedProperty = this.createManagedPropertyFromDialog(dialog);
            Command addCommand = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedProperty(), (Object)managedProperty);
            if (addCommand.canExecute()) {
                this.getEditingDomain().getCommandStack().execute(addCommand);
            }
        }
    }

    protected void editButtonSelected() {
        ManagedPropertyType managedProperty = (ManagedPropertyType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        Shell shell = EditorPlugin.getActiveShell();
        AddEditManagedPropertyDialog dialog = new AddEditManagedPropertyDialog(shell, managedProperty, this.section);
        if (dialog.open() == 0) {
            CompoundCommand command;
            Object valueObject;
            Command rmCmd;
            ArrayList<Command> commands = new ArrayList<Command>();
            String propertyName = dialog.getPropertyName();
            String propertyClass = dialog.getPropertyClass();
            PropertyNameType propertyNameType = FacesConfigFactory.eINSTANCE.createPropertyNameType();
            propertyNameType.setTextContent(propertyName);
            Command cmd1 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_PropertyName(), (Object)propertyNameType);
            commands.add(cmd1);
            PropertyClassType propertyClassType = FacesConfigFactory.eINSTANCE.createPropertyClassType();
            propertyClassType.setTextContent(propertyClass);
            Command cmd2 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_PropertyClass(), (Object)propertyClassType);
            commands.add(cmd2);
            if (managedProperty.getNullValue() != null) {
                rmCmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_NullValue(), (Object)SetCommand.UNSET_VALUE);
                commands.add(rmCmd);
            }
            if (managedProperty.getListEntries() != null) {
                rmCmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_ListEntries(), (Object)SetCommand.UNSET_VALUE);
                commands.add(rmCmd);
            }
            if (managedProperty.getValue() != null) {
                rmCmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_Value(), (Object)SetCommand.UNSET_VALUE);
                commands.add(rmCmd);
            }
            if (managedProperty.getMapEntries() != null) {
                rmCmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_MapEntries(), (Object)SetCommand.UNSET_VALUE);
                commands.add(rmCmd);
            }
            if ((valueObject = dialog.getValueObject()) != null) {
                String valueType = dialog.getValueType();
                if (valueType.equals("value")) {
                    ValueType value = FacesConfigFactory.eINSTANCE.createValueType();
                    value.setTextContent((String)valueObject);
                    managedProperty.setValue(value);
                    Command cmd3 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_Value(), (Object)value);
                    commands.add(cmd3);
                } else if (valueType.equals("map-entries")) {
                    MapEntriesType mapEntriesType = (MapEntriesType)valueObject;
                    Command cmd3 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_MapEntries(), (Object)mapEntriesType);
                    commands.add(cmd3);
                } else if (valueType.equals("list-entries")) {
                    ListEntriesType listEntriesType = (ListEntriesType)valueObject;
                    Command cmd3 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_ListEntries(), (Object)listEntriesType);
                    commands.add(cmd3);
                } else if (valueType.equals("null-value")) {
                    NullValueType nullValue = (NullValueType)valueObject;
                    Command cmd3 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedProperty, (Object)FacesConfigPackage.eINSTANCE.getManagedPropertyType_NullValue(), (Object)nullValue);
                    commands.add(cmd3);
                }
            }
            if ((command = new CompoundCommand(commands)).canExecute()) {
                this.getEditingDomain().getCommandStack().execute((Command)command);
            }
        }
    }

    protected ManagedPropertyType createManagedPropertyFromDialog(AddEditManagedPropertyDialog dialog) {
        String propertyName = dialog.getPropertyName();
        String propertyClass = dialog.getPropertyClass();
        ManagedPropertyType managedProperty = FacesConfigFactory.eINSTANCE.createManagedPropertyType();
        PropertyNameType propertyNameType = FacesConfigFactory.eINSTANCE.createPropertyNameType();
        propertyNameType.setTextContent(propertyName);
        PropertyClassType propertyClassType = FacesConfigFactory.eINSTANCE.createPropertyClassType();
        propertyClassType.setTextContent(propertyClass);
        managedProperty.setPropertyName(propertyNameType);
        managedProperty.setPropertyClass(propertyClassType);
        Object valueObject = dialog.getValueObject();
        if (valueObject != null) {
            String valueType = dialog.getValueType();
            if (valueType.equals("value")) {
                ValueType value = FacesConfigFactory.eINSTANCE.createValueType();
                value.setTextContent((String)valueObject);
                managedProperty.setValue(value);
            } else if (valueType.equals("map-entries")) {
                MapEntriesType mapEntriesType = (MapEntriesType)dialog.getValueObject();
                managedProperty.setMapEntries(mapEntriesType);
            } else if (valueType.equals("list-entries")) {
                ListEntriesType listEntriesType = (ListEntriesType)dialog.getValueObject();
                managedProperty.setListEntries(listEntriesType);
            } else if (valueType.equals("null-value")) {
                NullValueType nullValue = (NullValueType)dialog.getValueObject();
                managedProperty.setNullValue(nullValue);
            }
        }
        return managedProperty;
    }

    protected void removeButtonSelected() {
        ManagedPropertyType managedProperty = (ManagedPropertyType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        Assert.isNotNull((Object)managedProperty);
        Command removeCommand = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedProperty(), (Object)managedProperty);
        if (removeCommand.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(removeCommand);
            this.refreshAll();
        }
    }

    public void setInput(Object newInput) {
        if (newInput != null && newInput instanceof ManagedBeanType) {
            this.managedBean = (ManagedBeanType)newInput;
            this.refreshAll();
        }
    }

    public void refreshAll() {
        this.tableViewer.setInput(this.getInput());
        this.updateButtons();
    }

    public void refresh() {
        this.tableViewer.refresh();
        this.updateButtons();
    }

    public Object getInput() {
        return this.managedBean;
    }

    public EditingDomain getEditingDomain() {
        return this.section.getEditingDomain();
    }
}

