/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.contentmodel.annotation;

import org.eclipse.jst.jsf.core.internal.contentmodel.annotation.CMAnnotationMap;
import org.eclipse.jst.jsf.core.internal.contentmodel.annotation.CMAttributeAnnotation;
import org.eclipse.jst.jsf.core.internal.contentmodel.annotation.CMElementAnnotation;
import org.eclipse.jst.jsf.core.internal.contentmodel.annotation.ICMAnnotationAdvisor;
import org.eclipse.jst.jsf.core.internal.provisional.contentmodel.annotation.ICMAnnotationSourceFileInfo;

public final class CMAnnotationAdvisor
implements ICMAnnotationAdvisor {
    private CMAnnotationMap map;
    private ICMAnnotationSourceFileInfo fileInfo;

    public CMAnnotationAdvisor(CMAnnotationMap map, ICMAnnotationSourceFileInfo fileInfo) {
        this.map = map;
        this.fileInfo = fileInfo;
        this.setCaseSensitive(true);
    }

    public void addElementAnnotation(String elementName, String propertyName, String propertyValue) {
        CMElementAnnotation elem = this.getElementAnnotation(this.getStringValueForCaseSensitivity(elementName));
        elem.setProperty(this.getStringValueForCaseSensitivity(propertyName), propertyValue);
    }

    public void addAttributeAnnotation(String elementName, String attributeName, String propertyName, String propertyValue) {
        CMElementAnnotation elem = this.getElementAnnotation(this.getStringValueForCaseSensitivity(elementName));
        CMAttributeAnnotation attr = this.getAttributeAnnotation(elem, this.getStringValueForCaseSensitivity(attributeName));
        attr.setProperty(this.getStringValueForCaseSensitivity(propertyName), propertyValue);
    }

    public ICMAnnotationSourceFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setCaseSensitive(boolean val) {
        this.map.setCaseSensitive(val);
    }

    private CMElementAnnotation getElementAnnotation(String elementName) {
        CMElementAnnotation elem = this.map.getElementAnnotation(elementName);
        if (elem == null) {
            elem = new CMElementAnnotation(elementName);
            this.map.addCMElementAnnotation(elem);
        }
        return elem;
    }

    private CMAttributeAnnotation getAttributeAnnotation(CMElementAnnotation elem, String attributeName) {
        CMAttributeAnnotation attr = (CMAttributeAnnotation)elem.getAttributeAnnotations().get(attributeName);
        if (attr == null) {
            attr = new CMAttributeAnnotation(elem.getName(), attributeName);
            elem.addCMAttributeAnnotation(attr);
        }
        return attr;
    }

    private String getStringValueForCaseSensitivity(String val) {
        return this.map.getStringValueForCaseSensitivity(val);
    }
}

