/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xsd.ui.internal.common.commands.ExtensibleAddExtensionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.ExtensibleRemoveExtensionNodeCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.CategoryProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.w3c.dom.Element;

public class ExtensionsSchemasRegistry {
    public static final String USER_ADDED_EXT_SCHEMAS = "USER-ADDED-EXT-SCHEMAS";
    private static final String LOCATION_PREFIX = "platform:/plugin/";
    public static final String DESCRIPTION = "description";
    public static final String DISPLAYNAME = "displayName";
    public static final String NAMESPACEURI = "namespaceURI";
    public static final String XSDFILEURL = "xsdFileURL";
    public static final String LABELPROVIDER = "labelProviderClass";
    public static final String ADD_COMMAND_CLASS = "addCommandClass";
    public static final String DELETE_COMMAND_CLASS = "deleteCommandClass";
    public static final String CATEGORY_PROVIDER_CLASS = "class";
    protected IPreferenceStore prefStore;
    protected String extensionId;
    protected ArrayList nsURIProperties;
    protected ArrayList categoryProviderList;
    private ICatalog systemCatalog;
    private String deprecatedExtensionId;

    public ExtensionsSchemasRegistry(String appinfo_extensionid) {
        this.extensionId = appinfo_extensionid;
    }

    public void __internalSetDeprecatedExtensionId(String deprecatedId) {
        this.deprecatedExtensionId = deprecatedId;
    }

    public void setPrefStore(IPreferenceStore store) {
        this.prefStore = store;
    }

    public List getAllExtensionsSchemasContribution() {
        if (this.nsURIProperties != null) {
            return this.nsURIProperties;
        }
        this.nsURIProperties = new ArrayList();
        this.categoryProviderList = new ArrayList();
        this.getAllExtensionsSchemasContribution(this.extensionId);
        if (this.deprecatedExtensionId != null) {
            this.getAllExtensionsSchemasContribution(this.deprecatedExtensionId);
        }
        if (this.prefStore != null) {
            String value = this.prefStore.getString(USER_ADDED_EXT_SCHEMAS);
            StringTokenizer tokenizer = new StringTokenizer(value, "\n");
            while (tokenizer.hasMoreTokens()) {
                this.nsURIProperties.add(new SpecificationForExtensionsSchema(tokenizer.nextToken()));
            }
        }
        return this.nsURIProperties;
    }

    private List getAllExtensionsSchemasContribution(String id) {
        boolean hasASIProperties;
        IConfigurationElement[] asiPropertiesList = Platform.getExtensionRegistry().getConfigurationElementsFor(id);
        boolean bl = hasASIProperties = asiPropertiesList != null && asiPropertiesList.length > 0;
        if (hasASIProperties) {
            int i = 0;
            while (i < asiPropertiesList.length) {
                String categoryProviderClass;
                IConfigurationElement asiPropertiesElement = asiPropertiesList[i];
                String elementName = asiPropertiesElement.getName();
                if ("category".equals(elementName)) {
                    String description = asiPropertiesElement.getAttribute(DESCRIPTION);
                    String displayName = asiPropertiesElement.getAttribute(DISPLAYNAME);
                    String namespaceURI = asiPropertiesElement.getAttribute(NAMESPACEURI);
                    String xsdFileURL = asiPropertiesElement.getAttribute(XSDFILEURL);
                    String labelProviderClass = asiPropertiesElement.getAttribute(LABELPROVIDER);
                    String addCommandClass = asiPropertiesElement.getAttribute(ADD_COMMAND_CLASS);
                    String deleteCommandClass = asiPropertiesElement.getAttribute(DELETE_COMMAND_CLASS);
                    if (displayName != null) {
                        if (xsdFileURL == null) {
                            xsdFileURL = this.locateFileUsingCatalog(namespaceURI);
                        }
                        SpecificationForExtensionsSchema extensionsSchemaSpec = this.createEntry();
                        extensionsSchemaSpec.setDescription(description);
                        extensionsSchemaSpec.setDisplayName(displayName);
                        extensionsSchemaSpec.setNamespaceURI(namespaceURI);
                        extensionsSchemaSpec.setDefautSchema();
                        String pluginId = asiPropertiesElement.getDeclaringExtension().getContributor().getName();
                        if (labelProviderClass != null) {
                            ILabelProvider labelProvider = null;
                            try {
                                Class theClass = Platform.getBundle((String)pluginId).loadClass(labelProviderClass);
                                if (theClass != null && (labelProvider = (ILabelProvider)theClass.newInstance()) != null) {
                                    extensionsSchemaSpec.setLabelProvider(labelProvider);
                                }
                            }
                            catch (Exception exception) {}
                        }
                        if (addCommandClass != null) {
                            try {
                                ExtensibleAddExtensionCommand addCommand = (ExtensibleAddExtensionCommand)((Object)asiPropertiesElement.createExecutableExtension(ADD_COMMAND_CLASS));
                                if (addCommand != null) {
                                    extensionsSchemaSpec.setExtensibleAddExtensionCommand(addCommand);
                                }
                            }
                            catch (Exception exception) {}
                        }
                        if (deleteCommandClass != null) {
                            try {
                                ExtensibleRemoveExtensionNodeCommand deleteCommand = (ExtensibleRemoveExtensionNodeCommand)((Object)asiPropertiesElement.createExecutableExtension(DELETE_COMMAND_CLASS));
                                if (deleteCommand != null) {
                                    extensionsSchemaSpec.setExtensibleRemoveExtensionNodeCommand(deleteCommand);
                                }
                            }
                            catch (Exception exception) {}
                        }
                        extensionsSchemaSpec.setLocation(LOCATION_PREFIX + pluginId + "/" + xsdFileURL);
                        this.nsURIProperties.add(extensionsSchemaSpec);
                    }
                } else if ("categoryProvider".equals(elementName) && (categoryProviderClass = asiPropertiesElement.getAttribute(CATEGORY_PROVIDER_CLASS)) != null) {
                    try {
                        CategoryProvider categoryProvider = (CategoryProvider)asiPropertiesElement.createExecutableExtension(CATEGORY_PROVIDER_CLASS);
                        if (categoryProvider != null) {
                            this.categoryProviderList.add(categoryProvider);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        return this.nsURIProperties;
    }

    public ExtensibleAddExtensionCommand getAddExtensionCommand(String namespace) {
        if (this.nsURIProperties == null) {
            this.getAllExtensionsSchemasContribution();
        }
        Iterator i = this.nsURIProperties.iterator();
        while (i.hasNext()) {
            SpecificationForExtensionsSchema spec = (SpecificationForExtensionsSchema)i.next();
            String nsURI = spec.getNamespaceURI();
            if (nsURI == null || !nsURI.equals(namespace)) continue;
            return spec.getExtensibleAddExtensionCommand();
        }
        i = this.categoryProviderList.iterator();
        while (i.hasNext()) {
            CategoryProvider categoryProvider = (CategoryProvider)i.next();
            Iterator j = categoryProvider.getCategories().iterator();
            while (j.hasNext()) {
                SpecificationForExtensionsSchema spec = (SpecificationForExtensionsSchema)j.next();
                String namespaceURI = spec.getNamespaceURI();
                if (namespaceURI == null || !namespaceURI.equals(namespace)) continue;
                return spec.getExtensibleAddExtensionCommand();
            }
        }
        return null;
    }

    public ExtensibleRemoveExtensionNodeCommand getRemoveExtensionNodeCommand(String namespace) {
        if (this.nsURIProperties == null) {
            this.getAllExtensionsSchemasContribution();
        }
        Iterator i = this.nsURIProperties.iterator();
        while (i.hasNext()) {
            SpecificationForExtensionsSchema spec = (SpecificationForExtensionsSchema)i.next();
            String nsURI = spec.getNamespaceURI();
            if (nsURI == null || !nsURI.equals(namespace)) continue;
            return spec.getExtensibleRemoveExtensionNodeCommand();
        }
        i = this.categoryProviderList.iterator();
        while (i.hasNext()) {
            CategoryProvider categoryProvider = (CategoryProvider)i.next();
            Iterator j = categoryProvider.getCategories().iterator();
            while (j.hasNext()) {
                SpecificationForExtensionsSchema spec = (SpecificationForExtensionsSchema)j.next();
                String namespaceURI = spec.getNamespaceURI();
                if (namespaceURI == null || !namespaceURI.equals(namespace)) continue;
                return spec.getExtensibleRemoveExtensionNodeCommand();
            }
        }
        return null;
    }

    public List getCategoryProviders() {
        if (this.nsURIProperties == null) {
            this.getAllExtensionsSchemasContribution();
        }
        return this.categoryProviderList;
    }

    public ILabelProvider getLabelProvider(Element element) {
        return null;
    }

    public SpecificationForExtensionsSchema createEntry() {
        return new SpecificationForExtensionsSchema();
    }

    private String locateFileUsingCatalog(String namespaceURI) {
        this.retrieveCatalog();
        ICatalogEntry[] entries = this.systemCatalog.getCatalogEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getKey().equals(namespaceURI)) {
                return entries[i].getURI();
            }
            ++i;
        }
        return null;
    }

    private void retrieveCatalog() {
        if (this.systemCatalog != null) {
            return;
        }
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null && "system_catalog".equals(referencedCatalog.getId())) {
                this.systemCatalog = referencedCatalog;
            }
            ++i;
        }
    }
}

