/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.navigation;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDVisitor;
import org.eclipse.wst.xsd.ui.internal.adt.design.DesignViewGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class DesignViewNavigationLocation
extends NavigationLocation {
    protected Path path;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DesignViewNavigationLocation(IEditorPart part) {
        super(part);
        this.path = new Path();
    }

    public DesignViewNavigationLocation(IEditorPart part, XSDConcreteComponent component) {
        super(part);
        this.path = Path.computePath(component);
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        boolean result = false;
        if (currentLocation instanceof DesignViewNavigationLocation) {
            DesignViewNavigationLocation loc = (DesignViewNavigationLocation)currentLocation;
            result = loc.path.toString().equals(this.path.toString());
        }
        return result;
    }

    public void restoreLocation() {
        Object viewer;
        IEditorPart iEditorPart = this.getEditorPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.xsd.XSDSchema");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDSchema schema = (XSDSchema)iEditorPart.getAdapter((Class)clazz);
        IEditorPart iEditorPart2 = this.getEditorPart();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((viewer = iEditorPart2.getAdapter((Class)clazz2)) instanceof DesignViewGraphicalViewer) {
            Adapter adapter;
            DesignViewGraphicalViewer graphicalViewer = (DesignViewGraphicalViewer)((Object)viewer);
            XSDConcreteComponent component = Path.computeComponent(schema, this.path);
            if (component != null) {
                Adapter adapter2 = XSDAdapterFactory.getInstance().adapt((Notifier)component);
                if (adapter2 instanceof IADTObject) {
                    graphicalViewer.setInput((IADTObject)adapter2);
                }
            } else if (this.path.segments.isEmpty() && (adapter = XSDAdapterFactory.getInstance().adapt((Notifier)schema)) instanceof IADTObject) {
                graphicalViewer.setInput((IADTObject)adapter);
            }
        }
    }

    public void restoreState(IMemento memento) {
        String string = memento.getString("path");
        this.path = Path.createPath(string);
    }

    public void saveState(IMemento memento) {
        memento.putString("path", this.path.toString());
    }

    public void update() {
    }

    static class PathSegment {
        static final int ELEMENT = 1;
        static final int TYPE = 2;
        int kind;
        String name;

        PathSegment() {
        }

        PathSegment(int kind, String name) {
            this.kind = kind;
            this.name = name;
        }
    }

    static class Path {
        List segments = new ArrayList();

        Path() {
        }

        static XSDConcreteComponent computeComponent(XSDSchema schema, Path path) {
            PathResolvingXSDVisitor visitor = new PathResolvingXSDVisitor(path);
            visitor.visitSchema(schema);
            if (visitor.isDone()) {
                return visitor.result;
            }
            return null;
        }

        static Path createPath(String string) {
            Path path = new Path();
            PathSegment segment = null;
            StringTokenizer st = new StringTokenizer(string, "/");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int kind = -1;
                if (token.equals("element")) {
                    kind = 1;
                } else if (token.equals("type")) {
                    kind = 2;
                }
                if (kind == -1) continue;
                segment = new PathSegment();
                segment.kind = kind;
                path.segments.add(segment);
                String namePattern = "[@name='";
                int startIndex = token.indexOf(namePattern);
                if (startIndex == -1) continue;
                startIndex += namePattern.length();
                int endIndex = token.indexOf("']");
                if (endIndex == -1) continue;
                segment.name = token.substring(startIndex, endIndex);
            }
            return path;
        }

        static Path computePath(XSDConcreteComponent component) {
            Path path = new Path();
            XSDConcreteComponent c = component;
            while (c != null) {
                PathSegment segment;
                if (c instanceof XSDConcreteComponent && (segment = Path.computePathSegment(c)) != null) {
                    path.segments.add(0, segment);
                }
                c = c.eContainer();
            }
            return path;
        }

        static PathSegment computePathSegment(XSDConcreteComponent c) {
            if (c instanceof XSDElementDeclaration) {
                XSDElementDeclaration ed = (XSDElementDeclaration)c;
                return new PathSegment(1, ed.getResolvedElementDeclaration().getName());
            }
            if (c instanceof XSDTypeDefinition) {
                XSDTypeDefinition td = (XSDTypeDefinition)c;
                return new PathSegment(2, td.getName());
            }
            return null;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            Iterator i = this.segments.iterator();
            while (i.hasNext()) {
                PathSegment segment = (PathSegment)i.next();
                String kind = "";
                if (segment.kind == 1) {
                    kind = "element";
                } else if (segment.kind == 2) {
                    kind = "type";
                }
                b.append(kind);
                if (segment.name != null) {
                    b.append("[@name='" + segment.name + "']");
                }
                if (!i.hasNext()) continue;
                b.append("/");
            }
            return b.toString();
        }
    }

    static class PathResolvingXSDVisitor
    extends XSDVisitor {
        Path path;
        int index = -1;
        PathSegment segment;
        XSDConcreteComponent result = null;

        PathResolvingXSDVisitor(Path path) {
            this.path = path;
            this.incrementSegment();
        }

        boolean isDone() {
            return this.index >= this.path.segments.size();
        }

        void incrementSegment() {
            ++this.index;
            this.segment = this.index < this.path.segments.size() ? (PathSegment)this.path.segments.get(this.index) : null;
        }

        public void visitSchema(XSDSchema schema) {
            if (this.segment != null) {
                XSDTypeDefinition td;
                if (this.segment.kind == 1) {
                    XSDElementDeclaration ed = schema.resolveElementDeclaration(this.segment.name);
                    if (ed != null) {
                        this.visitElementDeclaration(ed);
                    }
                } else if (this.segment.kind == 2 && (td = schema.resolveTypeDefinition(this.segment.name)) != null) {
                    this.visitTypeDefinition(td);
                }
            }
        }

        public void visitElementDeclaration(XSDElementDeclaration element) {
            if (this.segment != null) {
                String name = element.getResolvedElementDeclaration().getName();
                if (this.segment.kind == 1 && this.isMatch(this.segment.name, name)) {
                    this.result = element;
                    this.incrementSegment();
                    if (!this.isDone()) {
                        super.visitElementDeclaration(element);
                    }
                }
            }
        }

        public void visitTypeDefinition(XSDTypeDefinition type) {
            if (this.segment != null) {
                String name = type.getName();
                if (this.segment.kind == 2 && this.isMatch(this.segment.name, name)) {
                    this.result = type;
                    this.incrementSegment();
                    if (!this.isDone()) {
                        super.visitTypeDefinition(type);
                    }
                }
            }
        }

        protected boolean isMatch(String name1, String name2) {
            return name1 != null ? name1.equals(name2) : name1 == name2;
        }
    }
}

