/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual.VirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.services.IVirtualNodeServiceFactory;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.server.internal.ui.explorer.ServerExplorerViewer;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ConnectionNodeUtil;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerConfiguration;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerInitializer;
import org.eclipse.wst.rdb.server.internal.ui.explorer.loading.ILoadingService;
import org.eclipse.wst.rdb.server.internal.ui.explorer.loading.LoadingNode;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.ServerExplorerManager;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.layout.IServerExplorerLayoutProviderNav;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.layout.hierar.ServerExplorerHierarchicalLayoutNav;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.layout.vnode.ServerExplorerVirtualNodeLayoutNav;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.label.ServerExplorerLabelProvider;
import org.eclipse.wst.rdb.server.internal.ui.layout.IServerExplorerLayoutExtensionProvider;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerContentService;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerLayoutService;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerNavigationService;
import org.eclipse.wst.rdb.server.internal.ui.util.TransientEObjectUtil;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class ServerExplorerContentProviderNav
implements ICommonContentProvider,
IServerExplorerContentService,
IServerExplorerLayoutService,
IServerExplorerNavigationService,
ILoadingService {
    private static final ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
    private static final ConnectionManager manager = RDBCorePlugin.getDefault().getConnectionManager();
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final String KNOWN_SERVERS = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.KNOWN_SERVERS");
    private static final String DESCRIPTION = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DESCRIPTION");
    private static final IVirtualNodeServiceFactory virtualNodeFactory = IDataToolsUIServiceManager.INSTANCE.getVirtualNodeServiceFactory();
    private static final String ACTIVE_CONNECTION = "org.eclipse.wst.rdb.server.ui.activeConnection";
    private static final String COMMA = ",";
    private ServerExplorerViewer databaseExplorerViewer;
    private ServerExplorerConfiguration serverExplorerConfiguration = new ServerExplorerConfiguration();
    private IKnownConnectionNode knownServer;
    private ServerExplorerLabelProvider labelProvider;
    private IServerExplorerLayoutProviderNav layoutProvider;
    private List layoutProvidersExtensionList = new LinkedList();

    private void initializeServerExplorer() {
        this.knownServer = virtualNodeFactory.makeKnownConnectionNode(KNOWN_SERVERS, KNOWN_SERVERS, null);
        ServerExplorerManager.INSTANCE.setRootKnownServerNode(this.knownServer);
        ServerExplorerManager.INSTANCE.setServerExplorerService(this);
    }

    private void initializeLayoutExtensionProviders() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.server.ui", "serverExplorerLayoutExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    IServerExplorerLayoutExtensionProvider layout = (IServerExplorerLayoutExtensionProvider)configElements[j].createExecutableExtension("class");
                    layout.enableLayout(this.isVirtualNodeLayoutSelected() ? IServerExplorerLayoutExtensionProvider.Layout.VNODE : IServerExplorerLayoutExtensionProvider.Layout.HIERARCHICAL);
                    this.layoutProvidersExtensionList.add(layout);
                }
                catch (CoreException coreException) {}
                ++j;
            }
            ++i;
        }
    }

    private void removeServerConnection(IConnectionNode server) {
        server.shouldDisconnect(true);
    }

    private IConnectionNode[] getServers(boolean connected) {
        LinkedList<IConnectionNode> connectedServers = new LinkedList<IConnectionNode>();
        int i = 0;
        int n = this.knownServer.getChildrenArray().length;
        while (i < n) {
            IConnectionNode server = (IConnectionNode)this.knownServer.getChildrenArray()[i];
            if (server.isConnected() == connected) {
                connectedServers.add(server);
            }
            ++i;
        }
        return connectedServers.toArray(new IConnectionNode[connectedServers.size()]);
    }

    private Object getConnectionNode(Object element) {
        Object[] nodes = this.getKnownServerNode().getChildrenArray();
        int i = 0;
        int n = nodes.length;
        while (i < n) {
            IConnectionNode node;
            Object current = nodes[i];
            if (current instanceof IConnectionNode && Arrays.asList((node = (IConnectionNode)current).getChildrenArray()).contains(element)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public ServerExplorerViewer getViewer() {
        return this.databaseExplorerViewer;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.databaseExplorerViewer = (ServerExplorerViewer)viewer;
            new ServerExplorerInitializer().loadLocalRegisteredDatabases();
            this.layoutProvider.initializeKnownServers(this.knownServer);
        }
    }

    public Object[] getChildren(Object parent) {
        return new ILoadingService.Loading().getChildren((AbstractTreeViewer)this.databaseExplorerViewer, parent, this);
    }

    public String getLoadingDescription() {
        return DESCRIPTION;
    }

    public Object[] load(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            return new Object[]{this.knownServer};
        }
        if (parentElement instanceof IConnectionNode && ((IConnectionNode)parentElement).shouldDisconnect()) {
            ((IConnectionNode)parentElement).setConnected(false);
            return EMPTY_ELEMENT_ARRAY;
        }
        if (parentElement instanceof VirtualNode && ((IVirtualNode)parentElement).hasChildren()) {
            return ((IVirtualNode)parentElement).getChildrenArray();
        }
        return this.layoutProvider.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof IWorkspaceRoot) {
            return this.knownServer;
        }
        Object result = this.getViewer().getParent(element);
        result = result != null ? result : (element instanceof IVirtualNode ? ((IVirtualNode)element).getParent() : null);
        result = result != null || !(element instanceof EObject) ? result : containmentService.getContainer((EObject)element);
        return result == null && element instanceof EObject && containmentService.getContainer((EObject)element) == null ? this.getConnectionNode(element) : result;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IConnectionNode && ((IConnectionNode)element).getConnectionInfo().getSharedDatabase() == null ? false : !(element instanceof LoadingNode);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.labelProvider.dispose();
        this.labelProvider = null;
        ServerExplorerManager.INSTANCE.setServerExplorerService(null);
    }

    public void addNode(Object newNode) {
        this.addNode(ResourcesPlugin.getWorkspace().getRoot(), newNode);
    }

    public void addNode(Object parentNode, Object newNode) {
        if (parentNode instanceof IVirtualNode) {
            ((IVirtualNode)parentNode).addChildren(newNode);
        }
        this.getViewer().add(parentNode, newNode);
    }

    public void addKnownServer(Object server) {
        IConnectionNode serverNode = (IConnectionNode)server;
        serverNode.setConnected(true);
        this.knownServer.addChildren((Object)serverNode);
        this.getViewer().add(this.getKnownServerNode(), serverNode);
    }

    public void addProxyNode(Object parentNode) {
    }

    private void loadChilds(ServerExplorerViewer viewer, Object parent) {
        viewer.expandToLevel(parent, 1);
        try {
            Platform.getJobManager().join((Object)LoadingNode.LOADING_FAMILY, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Object getVirtualNode(ServerExplorerViewer viewer, Object parent, String groupID) {
        if (parent != null) {
            if (parent instanceof IConnectionNode) {
                return parent;
            }
            TreeItem[] items = viewer.getServerExplorerChildren(parent);
            if (items.length != 0) {
                int i = 0;
                int n = items.length;
                while (i < n) {
                    TreeItem child = items[i];
                    Object childNode = child.getData();
                    if (childNode instanceof IVirtualNode && ((IVirtualNode)childNode).getGroupID().equals(groupID)) {
                        return (IVirtualNode)child.getData();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private Object getEObjectNode(ServerExplorerViewer viewer, Object parent, String name) {
        TreeItem[] items;
        if (parent != null && (items = viewer.getServerExplorerChildren(parent)).length != 0) {
            int i = 0;
            int n = items.length;
            while (i < n) {
                TreeItem child = items[i];
                Object childNode = child.getData();
                if (childNode instanceof ENamedElement && ((ENamedElement)childNode).getName().equalsIgnoreCase(name)) {
                    return childNode;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean isReconnectAtStartup() {
        return RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("DATABASE_EXPLORER_CONNECTION_RECONNECT_AT_STARTUP");
    }

    public void expandNode(String pathToNavigate) {
        this.expandNode(pathToNavigate, true);
    }

    public void expandNode(String pathToNavigate, boolean reveal) {
        ServerExplorerViewer viewer = this.getViewer();
        try {
            List path = TransientEObjectUtil.getPathFromID(pathToNavigate);
            Iterator pathIterator = path.iterator();
            Object parent1 = ConnectionNodeUtil.getConnectionNode(manager.getConnectionInfo((String)pathIterator.next()));
            Object parent2 = null;
            while (pathIterator.hasNext()) {
                String pathString = (String)pathIterator.next();
                TransientEObjectUtil.IGroup group = TransientEObjectUtil.getGroupInfo(pathString);
                String groupID = group.getGroupId();
                String elementName = group.getElementName();
                parent2 = this.getVirtualNode(viewer, parent1, groupID);
                if (parent2 == null) {
                    this.loadChilds(viewer, parent1);
                    parent2 = this.getVirtualNode(viewer, parent1, groupID);
                    if (parent2 == null && parent1 instanceof IVirtualNode) {
                        Object[] children = ((IVirtualNode)parent1).getChildrenArray();
                        int i = 0;
                        int n = children.length;
                        while (i < n) {
                            Object parent4 = this.getVirtualNode(viewer, children[i], groupID);
                            if (parent4 != null) {
                                parent2 = parent4;
                                break;
                            }
                            ++i;
                        }
                    }
                } else {
                    this.loadChilds(viewer, parent2);
                    Object parent3 = this.getVirtualNode(viewer, parent2, groupID);
                    if (parent3 != null) {
                        parent2 = parent3;
                    }
                }
                parent1 = parent2;
                if (elementName != null && (parent2 = this.getEObjectNode(viewer, parent1, elementName)) == null) {
                    this.loadChilds(viewer, parent1);
                    parent2 = this.getEObjectNode(viewer, parent1, elementName);
                }
                parent1 = parent2;
            }
            if (reveal && parent1 != null) {
                viewer.selectInExplorer((ISelection)new StructuredSelection(parent1));
            }
        }
        catch (Exception exception) {}
    }

    public void expandNode(EObject eObject) {
        this.expandNode(eObject, true);
    }

    public void expandNode(EObject eObject, boolean reveal) {
        try {
            this.expandNode(TransientEObjectUtil.getEObjectId(eObject), reveal);
        }
        catch (Exception exception) {}
    }

    public void selectAndReveal(ISelection selection) {
        this.selectAndReveal(selection, true);
    }

    public void selectAndReveal(ISelection selection, boolean reveal) {
        Object toSelect = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof EObject)) continue;
                toSelect = object;
                this.expandNode((EObject)object, reveal);
            }
        }
        if (reveal) {
            this.getViewer().setSelection(selection, reveal);
        } else {
            if (toSelect != null) {
                this.getViewer().showInternal(toSelect);
            }
            this.getViewer().clearSelection(null);
        }
    }

    public void updateSelection(ISelection selection) {
        this.getViewer().updateExplorerSelection(selection);
    }

    public void clearSelection() {
        this.getViewer().clearSelection(null);
    }

    public IServerExplorerLayoutService getServerExplorerLayoutService() {
        return this;
    }

    public void refreshServerExplorer() {
    }

    public void updateLayout() {
    }

    public void refreshNode(Object node) {
        this.getViewer().refresh(node, true);
    }

    public void updateNode(Object node) {
        if (this.getViewer().testFindItem(node) != null) {
            this.getViewer().update(node, null);
        }
    }

    public void expandNode(Object node, int depth) {
        while (Display.getDefault().readAndDispatch()) {
        }
        this.getViewer().expandToLevel(node, depth);
    }

    public void collapseAll() {
        this.getViewer().collapseAll();
    }

    public IConnectionNode[] getAllConnectedServers() {
        return this.getServers(true);
    }

    public IConnectionNode[] getAllDisconnectedServers() {
        return this.getServers(false);
    }

    public void disconnectServers(IConnectionNode[] servers) {
        int i = 0;
        int n = servers.length;
        while (i < n) {
            this.removeServerConnection(servers[i]);
            this.getViewer().refresh(servers[i], true);
            ++i;
        }
    }

    public void connectServer(Object server) {
        IConnectionNode serverNode = (IConnectionNode)server;
        this.getViewer().refresh(serverNode, true);
    }

    public void enableVirtualNodeLayout() {
        this.layoutProvider = new ServerExplorerVirtualNodeLayoutNav(this);
        Iterator iterator = this.layoutProvidersExtensionList.iterator();
        while (iterator.hasNext()) {
            ((IServerExplorerLayoutExtensionProvider)iterator.next()).enableLayout(IServerExplorerLayoutExtensionProvider.Layout.VNODE);
        }
    }

    public void enableHierarchicalLayout() {
        this.layoutProvider = new ServerExplorerHierarchicalLayoutNav(this);
        Iterator iterator = this.layoutProvidersExtensionList.iterator();
        while (iterator.hasNext()) {
            ((IServerExplorerLayoutExtensionProvider)iterator.next()).enableLayout(IServerExplorerLayoutExtensionProvider.Layout.HIERARCHICAL);
        }
    }

    public boolean isVirtualNodeLayoutSelected() {
        return this.layoutProvider instanceof ServerExplorerVirtualNodeLayoutNav;
    }

    public boolean isHierarchicalLayoutSelected() {
        return this.layoutProvider instanceof ServerExplorerHierarchicalLayoutNav;
    }

    public IKnownConnectionNode getKnownServerNode() {
        return this.knownServer;
    }

    public void deleteServer(IConnectionNode[] servers) {
        int i = 0;
        int n = servers.length;
        while (i < n) {
            this.serverExplorerConfiguration.deleteServer(servers[i]);
            this.removeServerConnection(servers[i]);
            this.getKnownServerNode().removeChildren((Object)servers[i]);
            this.getViewer().remove(servers[i]);
            ++i;
        }
    }

    public void reconnectServer(IConnectionNode[] servers) {
    }

    public void removeNode(Object parent, Object removedChild) {
        this.getViewer().remove(removedChild);
    }

    public Object[] getServerExplorerObjectsByType(ConnectionInfo info, Class type) {
        return this.getViewer().getServerExplorerObjectsByType(info, type);
    }

    public Object[] getServerExplorerObjectsByType(Object parent, Class type) {
        return this.getViewer().getServerExplorerObjectsByType(parent, type);
    }

    public void init(ICommonContentExtensionSite aConfig) {
        this.enableVirtualNodeLayout();
        this.labelProvider = (ServerExplorerLabelProvider)aConfig.getExtension().getLabelProvider();
        this.initializeServerExplorer();
        this.initializeLayoutExtensionProviders();
    }

    public void restoreState(IMemento aMemento) {
        String activeConnections;
        if (!this.isReconnectAtStartup()) {
            return;
        }
        Vector<String> list = new Vector<String>();
        if (aMemento != null && (activeConnections = aMemento.getString(ACTIVE_CONNECTION)) != null) {
            StringTokenizer token = new StringTokenizer(activeConnections, COMMA);
            while (token.hasMoreTokens()) {
                String conn = token.nextToken();
                list.add(conn);
            }
        }
        ServerExplorerConfiguration seConfiguration = new ServerExplorerConfiguration();
        IConnectionNode[] nodes = this.getServers(false);
        int i = 0;
        while (i < nodes.length) {
            IConnectionNode node = nodes[i];
            ConnectionInfo connInfo = node.getConnectionInfo();
            if (list.contains(connInfo.getName())) {
                seConfiguration.reestablishConnect(node, connInfo);
            }
            ++i;
        }
    }

    public void saveState(IMemento aMemento) {
        StringBuffer buffer = new StringBuffer();
        IConnectionNode[] nodes = this.getServers(true);
        int i = 0;
        while (i < nodes.length) {
            ConnectionInfo connInfo = nodes[i].getConnectionInfo();
            buffer.append(connInfo.getName()).append(COMMA);
            ++i;
        }
        aMemento.putString(ACTIVE_CONNECTION, buffer.toString());
    }
}

