/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.util;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.jsp.core.internal.Logger;

public class FileContentCache {
    static final boolean DEBUG = false;
    static FileContentCache instance = new FileContentCache();
    private Map fContentMap = new HashMap();

    public static FileContentCache getInstance() {
        return instance;
    }

    private FileContentCache() {
    }

    private void cleanup() {
        Iterator iterator = this.fContentMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() == null || ((Reference)entry.getValue()).get() != null) continue;
            iterator.remove();
        }
    }

    public String getContents(IFile f) {
        return this.getContents(f.getFullPath());
    }

    public String getContents(IPath filePath) {
        CacheEntry entry = null;
        Object o = this.fContentMap.get(filePath);
        if (o instanceof Reference) {
            entry = (CacheEntry)((Reference)o).get();
        }
        if (entry == null || entry.isStale()) {
            entry = new CacheEntry(filePath);
            this.fContentMap.put(filePath, new SoftReference<CacheEntry>(entry));
        }
        this.cleanup();
        return entry.contents;
    }

    private static class CacheEntry {
        String contents;
        long modificationStamp = -1L;
        IPath path;

        CacheEntry(IPath path) {
            this.path = path;
            this.modificationStamp = this.getModificationStamp(path);
            this.contents = this.readContents(path);
        }

        private IFile getFile(IPath path) {
            if (path.segmentCount() > 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            return null;
        }

        boolean isStale() {
            if (this.modificationStamp == -1L) {
                return true;
            }
            long newStamp = this.getModificationStamp(this.path);
            return newStamp > this.modificationStamp;
        }

        /*
         * Exception decompiling
         */
        private String detectCharset(IFile file) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 140->143)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private long getModificationStamp(IPath filePath) {
            IFile f = this.getFile(filePath);
            if (f != null && f.isAccessible()) {
                return f.getModificationStamp();
            }
            File file = filePath.toFile();
            if (file.exists()) {
                return file.lastModified();
            }
            return -1L;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String readContents(IPath filePath) {
            CoreException e3;
            Object var5_6;
            StringBuffer s = new StringBuffer();
            InputStream is = null;
            try {
                try {
                    IFile f = this.getFile(filePath);
                    if (f != null && f.isAccessible()) {
                        String charset = this.detectCharset(f);
                        is = f.getContents();
                        InputStreamReader reader = new InputStreamReader(is, charset);
                        char[] readBuffer = new char[2048];
                        int n = reader.read(readBuffer);
                        while (n > 0) {
                            s.append(readBuffer, 0, n);
                            n = reader.read(readBuffer);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var9_13 = null;
            }
            try {}
            catch (Exception exception) {}
            if (is != null) {
                is.close();
            }
            if (is != null) return s.toString();
            try {
                try {
                    FileBuffers.getTextFileBufferManager().connect(filePath, (IProgressMonitor)new NullProgressMonitor());
                    ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(filePath);
                    if (buffer != null) {
                        s.append(buffer.getDocument().get());
                    }
                }
                catch (CoreException e2) {
                    Logger.logException(e2);
                }
            }
            catch (Throwable throwable) {
                var5_6 = null;
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(filePath, (IProgressMonitor)new NullProgressMonitor());
                    throw throwable;
                }
                catch (CoreException e3) {
                    Logger.logException(e3);
                }
                throw throwable;
            }
            {
                var5_6 = null;
            }
            try {}
            catch (CoreException e3) {
                Logger.logException(e3);
                return s.toString();
            }
            FileBuffers.getTextFileBufferManager().disconnect(filePath, (IProgressMonitor)new NullProgressMonitor());
            return s.toString();
        }
    }
}

