/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.rte.jdbc;

import java.sql.Connection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.core.rte.jdbc.JDBCDatabase;
import org.eclipse.wst.rdb.internal.core.rte.jdbc.JDBCTable;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.impl.ViewTableImpl;

public class JDBCView
extends ViewTableImpl
implements ICatalogObject {
    private boolean columnsLoaded = false;

    public synchronized void refresh() {
        this.columnsLoaded = false;
        RefreshManager.getInstance().referesh(this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((JDBCDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getColumns() {
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getColumns();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            JDBCTable.loadColumns(this.getConnection(), super.getColumns(), (Table)this);
        }
        catch (Exception exception) {}
        this.columnsLoaded = true;
        this.eSetDeliver(deliver);
    }
}

