/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.rdb.core.internal.ui.RDBCoreUIPlugin;
import org.eclipse.wst.rdb.core.internal.ui.services.IStateProvider;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class StateManager {
    public static final StateManager INSTANCE = new StateManager();
    private final List providerList = new ArrayList();

    private StateManager() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.core.ui", "stateProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("provider")) {
                    try {
                        this.providerList.add(configElements[j].createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCoreUIPlugin.getDefault().getBundle().getSymbolicName(), 4, "An error was detected when loading the extension point stateProvider", (Throwable)e);
                        RDBCoreUIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public IStateProvider.State getState(SQLObject element) {
        Iterator iterator = this.providerList.iterator();
        while (iterator.hasNext()) {
            IStateProvider provider = (IStateProvider)iterator.next();
            if (!provider.provides(element)) continue;
            return provider.getState(element);
        }
        return IStateProvider.State.COMMITTED;
    }
}

