/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.contentmodel.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocumentation;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamespace;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.annotation.AnnotationMap;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMAttributeDeclarationImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMDataTypeImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMDocumentImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMEntityDeclarationImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMGroupImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNodeListImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDescriptionBuilder;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xsd.contentmodel.internal.CMNodeImpl;
import org.eclipse.wst.xsd.contentmodel.internal.XSDTypeUtil;
import org.eclipse.wst.xsd.contentmodel.internal.XSDVisitor;
import org.eclipse.wst.xsd.contentmodel.internal.util.XSDSchemaLocatorAdapterFactory;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSwitch;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XSDImpl {
    public static final String PROPERTY_CMDOCUMENT = "CMDocument";
    public static final String PROPERTY_USES_LOCAL_ELEMENT_DECLARATIONS = "http://org.eclipse.wst/cm/properties/usesLocalElementDeclarations";
    public static final String PROPERTY_IS_NAME_SPACE_AWARE = "http://org.eclipse.wst/cm/properties/isNameSpaceAware";
    public static final String PROPERTY_NS_PREFIX_QUALIFICATION = "http://org.eclipse.wst/cm/properties/nsPrefixQualification";
    public static final String PROPERTY_NILLABLE = "http://org.eclipse.wst/cm/properties/nillable";
    public static final String PROPERTY_SPEC = "spec";
    public static final String PROPERTY_TARGET_NAMESPACE_URI = "http://org.eclipse.wst/cm/properties/targetNamespaceURI";
    public static final String PROPERTY_IMPORTED_NAMESPACE_INFO = "http://org.eclipse.wst/cm/properties/importedNamespaceInfo";
    public static final String PROPERTY_NAMESPACE_INFO = "http://org.eclipse.wst/cm/properties/namespaceInfo";
    public static final String PROPERTY_ELEMENT_FORM_DEFAULT = "http://org.eclipse.wst/cm/properties/elementFormDefault";
    public static final String PROPERTY_ANNOTATION_MAP = "annotationMap";
    public static final String PROPERTY_COMPLETE_NAMESPACE_INFO = "http://org.eclipse.wst/cm/properties/completeNamespaceInfo";
    public static final String PROPERTY_XSITYPES = "XSITypes";
    public static final String PROPERTY_DERIVED_ELEMENT_DECLARATION = "DerivedElementDeclaration";
    public static final String PROPERTY_SUBSTITUTION_GROUP = "SubstitutionGroup";
    public static final String PROPERTY_SUBSTITUTION_GROUP_VALUE = "SubstitutionGroupValue";
    public static final String PROPERTY_ABSTRACT = "Abstract";
    public static final String PROPERTY_WHITESPACE_FACET = "org.eclipse.wst.xsd.cm.properties/whitespace";
    public static final String DEFINITION_INFO_GLOBAL = "global";
    public static final String DEFINITION_INFO_LOCAL = "local";
    public static final String XML_LANG_ATTRIBUTE = "xml:lang";
    public static final String PLATFORM_PROTOCOL = "platform:";
    protected static XSDAdapterFactoryImpl xsdAdapterFactoryImpl = new XSDAdapterFactoryImpl();
    protected static XSIDocument xsiDocument = new XSIDocument();
    private static final String TYPE_NAME_BOOLEAN = "boolean";
    private static final String TYPE_VALUE_TRUE = "true";
    private static final String TYPE_VALUE_FALSE = "false";

    public static CMDocument buildCMDocument(String uri, int grammarErrorChecking, List errorList) {
        return XSDImpl.buildCMDocument(uri);
    }

    public static CMDocument buildCMDocument(String uri) {
        CMDocument cmDocument = null;
        XSDSchema xsdSchema = XSDImpl.buildXSDModel(uri);
        if (xsdSchema != null) {
            cmDocument = (CMDocument)XSDImpl.getAdapter((Notifier)xsdSchema);
        }
        return cmDocument;
    }

    public static XSDSchema buildXSDModel(String uriString) {
        XSDSchema xsdSchema = null;
        try {
            if (uriString.endsWith("2001/XMLSchema.xsd")) {
                xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
            } else {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getAdapterFactories().add((Object)new XSDSchemaLocatorAdapterFactory());
                URI uri = XSDImpl.createURI(uriString);
                String physicalLocation = URIResolverPlugin.createResolver().resolvePhysicalLocation("", "", uriString);
                InputStream inputStream = resourceSet.getURIConverter().createInputStream(URI.createURI((String)physicalLocation));
                XSDResourceImpl resource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)"*.xsd"));
                resource.setURI(uri);
                resource.load(inputStream, null);
                xsdSchema = resource.getSchema();
            }
        }
        catch (Exception exception) {}
        return xsdSchema;
    }

    public static URI createURI(String uriString) {
        if (XSDImpl.hasProtocol(uriString)) {
            return URI.createURI((String)uriString);
        }
        return URI.createFileURI((String)uriString);
    }

    private static boolean hasProtocol(String uri) {
        int index;
        boolean result = false;
        if (uri != null && (index = uri.indexOf(":")) != -1 && index > 2) {
            result = true;
        }
        return result;
    }

    public static boolean withPlatformProtocol(String uriString) {
        return uriString.startsWith(PLATFORM_PROTOCOL);
    }

    public static int getMinOccurs(XSDConcreteComponent component) {
        XSDConcreteComponent o;
        int minOccur = 1;
        if (component != null && (o = component.getContainer()) instanceof XSDParticle && ((XSDParticle)o).isSetMinOccurs()) {
            try {
                minOccur = ((XSDParticle)o).getMinOccurs();
            }
            catch (Exception exception) {
                minOccur = 1;
            }
        }
        return minOccur;
    }

    public static int getMaxOccurs(XSDConcreteComponent component) {
        XSDConcreteComponent o;
        int maxOccur = 1;
        if (component != null && (o = component.getContainer()) instanceof XSDParticle && ((XSDParticle)o).isSetMaxOccurs()) {
            try {
                maxOccur = ((XSDParticle)o).getMaxOccurs();
            }
            catch (Exception exception) {
                maxOccur = 1;
            }
        }
        return maxOccur;
    }

    public static String[] getEnumeratedValuesForType(XSDTypeDefinition type) {
        ArrayList<String> result = new ArrayList<String>();
        if (type instanceof XSDComplexTypeDefinition) {
            type = ((XSDComplexTypeDefinition)type).getSimpleType();
        }
        if (type instanceof XSDSimpleTypeDefinition) {
            if (TYPE_NAME_BOOLEAN.equals(type.getName()) && type.getSchema().getSchemaForSchema() == type.getSchema()) {
                result.add(TYPE_VALUE_TRUE);
                result.add(TYPE_VALUE_FALSE);
            } else {
                int varietyType = ((XSDSimpleTypeDefinition)type).getVariety().getValue();
                switch (varietyType) {
                    case 0: {
                        XSDTypeDefinition baseType = type.getBaseType();
                        if (baseType != null && type.getSchema().getSchemaForSchema() != baseType.getSchema()) {
                            XSDImpl.getEnumeratedValuesForSimpleType(baseType, result);
                            break;
                        }
                        XSDImpl.getEnumeratedValuesForSimpleType(type, result);
                        break;
                    }
                    case 1: {
                        XSDSimpleTypeDefinition itemTypeDefinition = ((XSDSimpleTypeDefinition)type).getItemTypeDefinition();
                        XSDImpl.getEnumeratedValuesForSimpleType((XSDTypeDefinition)itemTypeDefinition, result);
                        break;
                    }
                    case 2: {
                        EList memberTypes = ((XSDSimpleTypeDefinition)type).getMemberTypeDefinitions();
                        if (memberTypes == null || memberTypes.size() <= 0) break;
                        Iterator i = memberTypes.iterator();
                        while (i.hasNext()) {
                            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)i.next();
                            XSDImpl.getEnumeratedValuesForSimpleType((XSDTypeDefinition)simpleType, result);
                        }
                        break;
                    }
                }
            }
        }
        String[] array = new String[result.size()];
        result.toArray(array);
        return array;
    }

    private static void getEnumeratedValuesForSimpleType(XSDTypeDefinition type, List result) {
        EList enumerationFacets = ((XSDSimpleTypeDefinition)type).getEnumerationFacets();
        Iterator i = enumerationFacets.iterator();
        while (i.hasNext()) {
            XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)i.next();
            EList values = enumFacet.getValue();
            Iterator j = values.iterator();
            while (j.hasNext()) {
                Object o = j.next();
                if (o == null || result.contains(o)) continue;
                result.add(o.toString());
            }
        }
    }

    public static CMNodeList getDocumentations(XSDAnnotation annotation) {
        CMNodeListImpl documentations = new CMNodeListImpl();
        if (annotation != null) {
            EList documentationsElements = annotation.getUserInformation();
            Iterator i = documentationsElements.iterator();
            while (i.hasNext()) {
                documentations.getList().add(new DocumentationImpl((Element)i.next()));
            }
        }
        return documentations;
    }

    public static List findTypesDerivedFrom(XSDTypeDefinition type) {
        ArrayList<XSDTypeDefinition> typesDerivedFrom = new ArrayList<XSDTypeDefinition>();
        if (type != null) {
            XSDSchema schema = type.getSchema();
            String localName = type.getName();
            if (schema != null && localName != null) {
                String namespace = schema.getTargetNamespace();
                EList typedefs = schema.getTypeDefinitions();
                Iterator iter = typedefs.iterator();
                while (iter.hasNext()) {
                    XSDTypeDefinition typedef = (XSDTypeDefinition)iter.next();
                    if (!(typedef instanceof XSDComplexTypeDefinition) || !XSDImpl.isTypeDerivedFrom(typedef, namespace, localName)) continue;
                    typesDerivedFrom.add(typedef);
                }
            }
        }
        return typesDerivedFrom;
    }

    protected static boolean isTypeDerivedFrom(XSDTypeDefinition typedef, String namespace, String localName) {
        XSDTypeDefinition baseType = typedef.getBaseType();
        if (baseType == null) {
            return false;
        }
        if (baseType.hasNameAndTargetNamespace(localName, namespace)) {
            return true;
        }
        XSDTypeDefinition rootType = typedef.getRootType();
        if (rootType == baseType) {
            return false;
        }
        if (rootType.isCircular()) {
            return true;
        }
        return XSDImpl.isTypeDerivedFrom(baseType, namespace, localName);
    }

    public static CMNode getAdapter(Notifier o) {
        return (CMNode)xsdAdapterFactoryImpl.adapt(o);
    }

    public static String getPrefix(XSDSchema schema, String ns) {
        String key = "";
        if (schema != null && ns != null) {
            Map map = schema.getQNamePrefixToNamespaceMap();
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object keyObj = iter.next();
                Object value = map.get(keyObj);
                if (value == null || !value.toString().equals(ns)) continue;
                if (keyObj != null) {
                    key = keyObj.toString();
                    break;
                }
                key = "";
                break;
            }
        }
        return key;
    }

    public static class DerivedChildVisitor
    extends XSDCMVisitor {
        protected CMNodeListImpl childNodeList = new CMNodeListImpl();
        protected List baseTypeList = new Vector();
        Object root;

        DerivedChildVisitor(Object root) {
            this.root = root;
        }

        public CMNodeListImpl getChildNodeList() {
            return this.childNodeList;
        }

        public void visitWildcard(XSDWildcard wildcard) {
            this.childNodeList.getList().add(XSDImpl.getAdapter((Notifier)wildcard));
        }

        public void visitElementDeclaration(XSDElementDeclaration element) {
            this.childNodeList.getList().add(XSDImpl.getAdapter((Notifier)element));
        }

        public void visitModelGroup(XSDModelGroup modelGroup) {
            this.childNodeList.getList().add(XSDImpl.getAdapter((Notifier)modelGroup));
        }

        public void visitModelGroupDefinition(XSDModelGroupDefinition modelGroupDefinition) {
            this.childNodeList.getList().add(XSDImpl.getAdapter((Notifier)modelGroupDefinition));
        }
    }

    public static class DerivedElementDeclarationImpl
    extends ElementDeclarationBaseImpl {
        protected XSDElementDeclarationAdapter owner;
        protected XSDTypeDefinition xsdType;
        public String uriQualifiedTypeName;

        public DerivedElementDeclarationImpl(XSDElementDeclarationAdapter owner, XSDTypeDefinition xsdType, String uriQualifiedTypeName) {
            this.owner = owner;
            this.xsdType = xsdType;
            this.uriQualifiedTypeName = uriQualifiedTypeName;
        }

        protected XSDElementDeclaration getXSDElementDeclaration() {
            return (XSDElementDeclaration)this.owner.getKey();
        }

        protected XSDElementDeclaration getResolvedXSDElementDeclaration() {
            return ((XSDElementDeclaration)this.owner.getKey()).getResolvedElementDeclaration();
        }

        public Object getKey() {
            return this.owner.getKey();
        }

        protected XSDTypeDefinition getXSDType() {
            return this.xsdType;
        }

        protected List getXSITypes() {
            return this.owner.getXSITypes();
        }

        protected CMElementDeclaration getDerivedElementDeclaration(String uriQualifiedTypeName) {
            return this.owner.getDerivedElementDeclaration(uriQualifiedTypeName);
        }

        protected CMNode getDefinition() {
            return this;
        }

        protected String getDefinitionInfo() {
            return this.owner.getDefinitionInfo();
        }

        public Object getNSPrefixQualification() {
            return this.owner.getNSPrefixQualification();
        }

        protected CMNodeListImpl getSubstitutionGroup() {
            return this.owner.getSubstitutionGroup();
        }
    }

    public static class DocumentationImpl
    implements CMDocumentation {
        protected Element documentation;

        public DocumentationImpl(Element documentation) {
            this.documentation = documentation;
        }

        public int getNodeType() {
            return 9;
        }

        public String getNodeName() {
            return "";
        }

        public boolean supports(String propertyName) {
            return false;
        }

        public Object getProperty(String propertyName) {
            return null;
        }

        public String getValue() {
            String content = "";
            boolean contentFound = false;
            NodeList nodes = this.documentation.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Text) {
                    contentFound = true;
                    content = String.valueOf(content) + node.getNodeValue();
                }
                ++i;
            }
            return contentFound ? content : null;
        }

        public String getLanguage() {
            return this.documentation.hasAttributeNS("http://www.w3.org/XML/1998/namespace", XSDImpl.XML_LANG_ATTRIBUTE) ? this.documentation.getAttributeNS("http://www.w3.org/XML/1998/namespace", XSDImpl.XML_LANG_ATTRIBUTE) : null;
        }

        public String getSource() {
            return this.documentation.hasAttributeNS(null, "source") ? this.documentation.getAttributeNS(null, "source") : null;
        }
    }

    public static abstract class ElementDeclarationBaseImpl
    extends XSDBaseAdapter
    implements CMElementDeclaration {
        protected CMDataType dataType = new DataTypeImpl();
        protected CMNamedNodeMap namedNodeMap;

        protected abstract XSDElementDeclaration getXSDElementDeclaration();

        protected abstract XSDElementDeclaration getResolvedXSDElementDeclaration();

        public int getNodeType() {
            return 5;
        }

        public String getNodeName() {
            return this.getElementName();
        }

        public String getElementName() {
            String result = this.getResolvedXSDElementDeclaration().getName();
            return result != null ? result : "";
        }

        public boolean supports(String propertyName) {
            return propertyName.equals(XSDImpl.PROPERTY_XSITYPES) || propertyName.equals(XSDImpl.PROPERTY_DERIVED_ELEMENT_DECLARATION) || propertyName.equals(XSDImpl.PROPERTY_SUBSTITUTION_GROUP) || propertyName.equals(XSDImpl.PROPERTY_ABSTRACT) || super.supports(propertyName);
        }

        public abstract Object getKey();

        public CMNamedNodeMap getAttributes() {
            CMNamedNodeMapImpl map = new CMNamedNodeMapImpl();
            XSDTypeDefinition td = this.getXSDType();
            this.getAttributes(map, td);
            this.addXSITypeAttribute(map);
            return map;
        }

        public void getAttributes(CMNamedNodeMapImpl map, XSDTypeDefinition xsdTypeDefinition) {
            if (xsdTypeDefinition instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition ctd = (XSDComplexTypeDefinition)xsdTypeDefinition;
                Iterator i = ctd.getAttributeUses().iterator();
                while (i.hasNext()) {
                    XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)i.next();
                    XSDAttributeUseAdapter adapter = (XSDAttributeUseAdapter)XSDImpl.getAdapter((Notifier)xsdAttributeUse);
                    if (adapter == null || adapter.getNodeName() == null) continue;
                    map.getHashtable().put(adapter.getNodeName(), adapter);
                }
            }
        }

        public CMContent getContent() {
            CMGroupImpl result = null;
            XSDTypeDefinition td = this.getXSDType();
            if (td instanceof XSDComplexTypeDefinition) {
                DerivedChildVisitor dcv = new DerivedChildVisitor(td);
                dcv.visitTypeDefinition(td);
                CMNodeListImpl nodeList = dcv.getChildNodeList();
                if (nodeList.getLength() > 1) {
                    result = new CMGroupImpl((CMNodeList)nodeList, 1);
                } else if (nodeList.getLength() > 0) {
                    result = (CMContent)nodeList.item(0);
                }
            }
            return result;
        }

        public int getContentType() {
            XSDContentTypeCategory category;
            int contentType = 1;
            XSDTypeDefinition td = this.getXSDType();
            if (td instanceof XSDSimpleTypeDefinition) {
                String typeName = td.getName();
                contentType = typeName != null && typeName.equals("anyType") ? 0 : 4;
            } else if (td instanceof XSDComplexTypeDefinition && (category = ((XSDComplexTypeDefinition)td).getContentTypeCategory()) != null) {
                switch (category.getValue()) {
                    case 3: {
                        contentType = 2;
                        break;
                    }
                    case 0: {
                        contentType = 1;
                        break;
                    }
                    case 2: {
                        contentType = 3;
                        break;
                    }
                    case 1: {
                        contentType = 4;
                    }
                }
            }
            return contentType;
        }

        public CMDataType getDataType() {
            boolean hasDataType;
            CMDataType result = null;
            int contentType = this.getContentType();
            boolean bl = hasDataType = contentType == 4 || contentType == 3;
            if (hasDataType) {
                result = this.dataType;
            }
            return result;
        }

        public int getMinOccur() {
            return XSDImpl.getMinOccurs((XSDConcreteComponent)this.getXSDElementDeclaration());
        }

        public int getMaxOccur() {
            return XSDImpl.getMaxOccurs((XSDConcreteComponent)this.getXSDElementDeclaration());
        }

        protected abstract CMNode getDefinition();

        protected abstract String getDefinitionInfo();

        public CMNamedNodeMap getLocalElements() {
            if (this.namedNodeMap == null) {
                LocalElementVisitor localElementVisitor = new LocalElementVisitor();
                localElementVisitor.visitTypeDefinition(this.getXSDType());
                this.namedNodeMap = localElementVisitor.getCMNamedNodeMap();
            }
            return this.namedNodeMap;
        }

        public Object getProperty(String propertyName) {
            Object result = null;
            if (propertyName.equals("http://org.eclipse.wst/cm/properties/definitionInfo")) {
                result = this.getDefinitionInfo();
            } else if (propertyName.equals("http://org.eclipse.wst/cm/properties/definition")) {
                result = this.getDefinition();
            } else if (propertyName.equals(XSDImpl.PROPERTY_XSITYPES)) {
                result = this.getXSITypes();
            } else if (propertyName.startsWith(XSDImpl.PROPERTY_DERIVED_ELEMENT_DECLARATION)) {
                int index = propertyName.indexOf("=");
                if (index != -1) {
                    String uriQualifiedTypeName = propertyName.substring(index + 1);
                    result = this.getDerivedElementDeclaration(uriQualifiedTypeName);
                }
            } else {
                if (propertyName.equals(XSDImpl.PROPERTY_SUBSTITUTION_GROUP)) {
                    return this.getSubstitutionGroup();
                }
                if (propertyName.equals(XSDImpl.PROPERTY_SUBSTITUTION_GROUP_VALUE)) {
                    return this.getSubstitutionGroupValue();
                }
                if (propertyName.equals(XSDImpl.PROPERTY_ABSTRACT)) {
                    return this.getAbstract();
                }
                result = super.getProperty(propertyName);
            }
            return result;
        }

        public boolean isNillable() {
            if (this.getXSDElementDeclaration().isSetNillable()) {
                return this.getXSDElementDeclaration().isNillable();
            }
            return false;
        }

        public String getSubstitutionGroupValue() {
            Element element;
            XSDElementDeclaration xsdElementDeclaration = this.getResolvedXSDElementDeclaration();
            if (xsdElementDeclaration != null && (element = xsdElementDeclaration.getElement()) != null) {
                return element.getAttribute("substitutionGroup");
            }
            return "";
        }

        public Boolean getAbstract() {
            boolean result = this.getResolvedXSDElementDeclaration().isAbstract();
            return result ? Boolean.TRUE : Boolean.FALSE;
        }

        protected CMNodeList getDocumentation() {
            XSDElementDeclaration xsdElementDeclaration = this.getXSDElementDeclaration();
            XSDAnnotation annotation = xsdElementDeclaration.getAnnotation();
            boolean hasDocumentation = false;
            if (annotation != null && !annotation.getUserInformation().isEmpty()) {
                hasDocumentation = true;
            }
            if (!hasDocumentation && xsdElementDeclaration.isElementDeclarationReference()) {
                annotation = xsdElementDeclaration.getResolvedElementDeclaration().getAnnotation();
            }
            return XSDImpl.getDocumentations(annotation);
        }

        protected abstract XSDTypeDefinition getXSDType();

        protected abstract List getXSITypes();

        protected abstract CMElementDeclaration getDerivedElementDeclaration(String var1);

        protected void addXSITypeAttribute(CMNamedNodeMapImpl map) {
            List list = this.getXSITypes();
            int listSize = list.size();
            if (listSize > 1) {
                CMDataTypeImpl dataType = new CMDataTypeImpl("typeNames", null);
                CMAttributeDeclarationImpl attribute = new CMAttributeDeclarationImpl("type", 1, (CMDataType)dataType);
                attribute.setCMDocument((CMDocument)xsiDocument);
                attribute.setPrefixQualification(true);
                attribute.setXSITypes(list);
                Hashtable hashTable = map.getHashtable();
                String name = attribute.getNodeName();
                if (!hashTable.containsKey(name)) {
                    hashTable.put(name, attribute);
                }
            }
        }

        public CMDocument getCMDocument() {
            XSDSchema schema = this.getResolvedXSDElementDeclaration().getSchema();
            if (schema == null) {
                return null;
            }
            return (CMDocument)XSDImpl.getAdapter((Notifier)schema);
        }

        protected abstract CMNodeListImpl getSubstitutionGroup();

        public class DataTypeImpl
        implements CMDataType {
            public int getNodeType() {
                return 3;
            }

            public String getNodeName() {
                return this.getDataTypeName();
            }

            public boolean supports(String propertyName) {
                return XSDImpl.PROPERTY_WHITESPACE_FACET.equals(propertyName);
            }

            public Object getProperty(String propertyName) {
                if (XSDImpl.PROPERTY_WHITESPACE_FACET.equals(propertyName)) {
                    return this.getWhiteSpaceFacetValue();
                }
                return null;
            }

            public String getDataTypeName() {
                String typeName = null;
                XSDSimpleTypeDefinition std = ElementDeclarationBaseImpl.this.getXSDType().getSimpleType();
                if (std != null) {
                    typeName = std.getName();
                }
                return typeName != null ? typeName : "string";
            }

            public int getImpliedValueKind() {
                int result = 1;
                if (ElementDeclarationBaseImpl.this.getXSDElementDeclaration().isSetConstraint()) {
                    if (ElementDeclarationBaseImpl.this.getXSDElementDeclaration().getConstraint().getValue() == 0) {
                        result = 3;
                    } else if (ElementDeclarationBaseImpl.this.getXSDElementDeclaration().getConstraint().getValue() == 1) {
                        result = 2;
                    }
                }
                return result;
            }

            public String getImpliedValue() {
                String result = null;
                if (ElementDeclarationBaseImpl.this.getXSDElementDeclaration().isSetConstraint()) {
                    result = ElementDeclarationBaseImpl.this.getXSDElementDeclaration().getLexicalValue();
                }
                return result;
            }

            public String[] getEnumeratedValues() {
                return XSDImpl.getEnumeratedValuesForType(ElementDeclarationBaseImpl.this.getXSDType());
            }

            public String generateInstanceValue() {
                return XSDTypeUtil.getInstanceValue(ElementDeclarationBaseImpl.this.getXSDType());
            }

            public CMDocument getCMDocument() {
                return (CMDocument)XSDImpl.getAdapter((Notifier)ElementDeclarationBaseImpl.this.getXSDElementDeclaration().getSchema());
            }

            private String getWhiteSpaceFacetValue() {
                XSDSimpleTypeDefinition def = ElementDeclarationBaseImpl.this.getXSDType().getSimpleType();
                return def != null && def.getEffectiveWhiteSpaceFacet() != null ? def.getEffectiveWhiteSpaceFacet().getLexicalValue() : null;
            }
        }
    }

    static class InternalURIConverter
    extends URIConverterImpl {
        InternalURIConverter() {
        }

        protected InputStream createURLInputStream(URI uri) throws IOException {
            if ("http".equals(uri.scheme())) {
                String theURI = uri.toString();
                String mapped = URIResolverPlugin.createResolver().resolve(theURI, theURI, theURI);
                if (mapped != null) {
                    uri = XSDImpl.createURI(mapped);
                }
            }
            return super.createURLInputStream(uri);
        }
    }

    public static class LocalElementVisitor
    extends XSDCMVisitor {
        protected CMNamedNodeMapImpl namedNodeMap = new CMNamedNodeMapImpl();
        protected List baseTypeList = new Vector();

        public void visitElementDeclaration(XSDElementDeclaration element) {
            XSDElementDeclarationAdapter adapter = (XSDElementDeclarationAdapter)XSDImpl.getAdapter((Notifier)element);
            this.namedNodeMap.getHashtable().put(adapter.getNodeName(), adapter);
        }

        public CMNamedNodeMap getCMNamedNodeMap() {
            return this.namedNodeMap;
        }
    }

    public static class XSDAdapterFactoryImpl
    extends AdapterFactoryImpl {
        public Adapter createAdapter(Notifier target) {
            XSDSwitch xsdSwitch = new XSDSwitch(this){
                final /* synthetic */ XSDAdapterFactoryImpl this$1;
                {
                    this.this$1 = xSDAdapterFactoryImpl;
                }

                public Object caseXSDWildcard(XSDWildcard object) {
                    return new XSDWildcardAdapter(object);
                }

                public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition object) {
                    return new XSDModelGroupDefinitionAdapter(object);
                }

                public Object caseXSDAttributeUse(XSDAttributeUse object) {
                    return new XSDAttributeUseAdapter(object);
                }

                public Object caseXSDElementDeclaration(XSDElementDeclaration object) {
                    return new XSDElementDeclarationAdapter(object);
                }

                public Object caseXSDModelGroup(XSDModelGroup object) {
                    return new XSDModelGroupAdapter(object);
                }

                public Object caseXSDSchema(XSDSchema object) {
                    return new XSDSchemaAdapter(object);
                }
            };
            Object o = xsdSwitch.doSwitch((EObject)target);
            Adapter result = null;
            if (o instanceof Adapter) {
                result = (Adapter)o;
            } else {
                Thread.dumpStack();
            }
            return result;
        }

        public Adapter adapt(Notifier target) {
            return this.adapt(target, (Object)this);
        }
    }

    public static class XSDAttributeUseAdapter
    extends XSDBaseAdapter
    implements CMAttributeDeclaration {
        protected XSDAttributeUse xsdAttributeUse;
        protected CMDataType dataType = new DataTypeImpl();

        public XSDAttributeUseAdapter(XSDAttributeUse xsdAttributeUse) {
            this.xsdAttributeUse = xsdAttributeUse;
        }

        public Object getKey() {
            return this.xsdAttributeUse;
        }

        public String getSpec() {
            return "//@" + this.getAttrName();
        }

        public int getNodeType() {
            return 2;
        }

        public String getNodeName() {
            return this.getAttrName();
        }

        public Enumeration getEnumAttr() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public String getAttrName() {
            return this.xsdAttributeUse.getAttributeDeclaration().getName();
        }

        public CMDataType getAttrType() {
            return this.dataType;
        }

        public String getDefaultValue() {
            return this.dataType.getImpliedValue();
        }

        public int getUsage() {
            int useKind = 1;
            switch (this.xsdAttributeUse.getUse().getValue()) {
                case 0: {
                    useKind = 1;
                    break;
                }
                case 1: {
                    useKind = 4;
                    break;
                }
                case 2: {
                    useKind = 2;
                }
            }
            return useKind;
        }

        public Object getNSPrefixQualification() {
            String form = null;
            if (this.xsdAttributeUse.getContent() != this.xsdAttributeUse.getAttributeDeclaration()) {
                form = "qualified";
            } else if (this.xsdAttributeUse.getContent().isSetForm()) {
                form = this.xsdAttributeUse.getContent().getForm().getName();
            } else {
                XSDSchema schema = this.xsdAttributeUse.getSchema();
                if (schema != null) {
                    form = schema.getAttributeFormDefault().getName();
                }
            }
            return form;
        }

        protected CMNodeList getDocumentation() {
            XSDAttributeDeclaration xsdAttributeRef = this.xsdAttributeUse.getContent();
            if (xsdAttributeRef != null && xsdAttributeRef.isAttributeDeclarationReference()) {
                boolean refHasDocumentation = false;
                XSDAnnotation refAnnotation = xsdAttributeRef.getAnnotation();
                if (refAnnotation != null && !refAnnotation.getUserInformation().isEmpty()) {
                    refHasDocumentation = true;
                }
                if (refHasDocumentation) {
                    return XSDImpl.getDocumentations(refAnnotation);
                }
            }
            XSDAttributeDeclaration xsdAttributeDeclaration = this.xsdAttributeUse.getAttributeDeclaration();
            XSDAnnotation annotation = xsdAttributeDeclaration.getAnnotation();
            return XSDImpl.getDocumentations(annotation);
        }

        public CMDocument getCMDocument() {
            return (CMDocument)XSDImpl.getAdapter((Notifier)this.xsdAttributeUse.getSchema());
        }

        public class DataTypeImpl
        implements CMDataType {
            public int getNodeType() {
                return 3;
            }

            public String getNodeName() {
                return this.getDataTypeName();
            }

            public boolean supports(String propertyName) {
                return XSDImpl.PROPERTY_WHITESPACE_FACET.equals(propertyName);
            }

            public Object getProperty(String propertyName) {
                if (XSDImpl.PROPERTY_WHITESPACE_FACET.equals(propertyName)) {
                    return this.getWhiteSpaceFacetValue();
                }
                return null;
            }

            public String getDataTypeName() {
                XSDSimpleTypeDefinition sc = XSDAttributeUseAdapter.this.xsdAttributeUse.getAttributeDeclaration().getTypeDefinition();
                String typeName = sc.getName();
                return typeName != null ? typeName : "string";
            }

            public int getImpliedValueKind() {
                int result = 1;
                if (XSDAttributeUseAdapter.this.xsdAttributeUse.isSetConstraint()) {
                    if (XSDAttributeUseAdapter.this.xsdAttributeUse.getConstraint().getValue() == 0) {
                        result = 3;
                    } else if (XSDAttributeUseAdapter.this.xsdAttributeUse.getConstraint().getValue() == 1) {
                        result = 2;
                    }
                }
                return result;
            }

            public String getImpliedValue() {
                String result = null;
                if (XSDAttributeUseAdapter.this.xsdAttributeUse.isSetConstraint()) {
                    result = XSDAttributeUseAdapter.this.xsdAttributeUse.getLexicalValue();
                }
                return result;
            }

            public String[] getEnumeratedValues() {
                return XSDImpl.getEnumeratedValuesForType(this.getXSDType());
            }

            public String generateInstanceValue() {
                XSDAttributeDeclaration attr = XSDAttributeUseAdapter.this.xsdAttributeUse.getAttributeDeclaration();
                return XSDTypeUtil.getInstanceValue((XSDTypeDefinition)attr.getResolvedAttributeDeclaration().getTypeDefinition());
            }

            protected XSDTypeDefinition getXSDType() {
                XSDAttributeDeclaration attr = XSDAttributeUseAdapter.this.xsdAttributeUse.getAttributeDeclaration();
                return attr.getResolvedAttributeDeclaration().getTypeDefinition();
            }

            private String getWhiteSpaceFacetValue() {
                XSDSimpleTypeDefinition def = this.getXSDType().getSimpleType();
                return def != null && def.getEffectiveWhiteSpaceFacet() != null ? def.getEffectiveWhiteSpaceFacet().getLexicalValue() : null;
            }
        }
    }

    public static abstract class XSDBaseAdapter
    extends CMNodeImpl {
        protected CMNodeListImpl documentation = new CMNodeListImpl();

        public String getNodeName() {
            return "";
        }

        public boolean isAdapterForType(Object type) {
            return type == xsdAdapterFactoryImpl;
        }

        public boolean supports(String propertyName) {
            return propertyName.equals(XSDImpl.PROPERTY_NS_PREFIX_QUALIFICATION) || propertyName.equals(XSDImpl.PROPERTY_NILLABLE) || propertyName.equals(XSDImpl.PROPERTY_USES_LOCAL_ELEMENT_DECLARATIONS) || propertyName.equals("documentation") || propertyName.equals("documentationSource") || propertyName.equals("documentationLanguage") || propertyName.equals("key") || propertyName.equals("http://org.eclipse.wst/cm/properties/definitionInfo") || propertyName.equals("http://org.eclipse.wst/cm/properties/definition") || propertyName.equals(XSDImpl.PROPERTY_CMDOCUMENT) || propertyName.equals(XSDImpl.PROPERTY_IS_NAME_SPACE_AWARE) || propertyName.equals(XSDImpl.PROPERTY_SPEC) || super.supports(propertyName);
        }

        public boolean isNillable() {
            return false;
        }

        public CMDocument getCMDocument() {
            return null;
        }

        protected CMNodeList getDocumentation() {
            return this.documentation;
        }

        public Object getProperty(String propertyName) {
            Object result = null;
            if (propertyName.equals(XSDImpl.PROPERTY_CMDOCUMENT)) {
                result = this.getCMDocument();
            } else if (propertyName.equals("documentation")) {
                result = this.getDocumentation();
            } else if (propertyName.equals(XSDImpl.PROPERTY_USES_LOCAL_ELEMENT_DECLARATIONS)) {
                result = Boolean.TRUE;
            } else if (propertyName.equals(XSDImpl.PROPERTY_IS_NAME_SPACE_AWARE)) {
                result = Boolean.TRUE;
            } else if (propertyName.equals(XSDImpl.PROPERTY_NS_PREFIX_QUALIFICATION)) {
                result = this.getNSPrefixQualification();
            } else if (propertyName.equals(XSDImpl.PROPERTY_NILLABLE)) {
                result = this.isNillable() ? XSDImpl.xsiDocument.nilAttribute : null;
            } else if (propertyName.equals("key")) {
                result = this.getKey();
            } else if (propertyName.equals(XSDImpl.PROPERTY_SPEC)) {
                result = this.getSpec();
            } else {
                String spec;
                AnnotationMap map;
                result = super.getProperty(propertyName);
                CMDocument cmDocument = this.getCMDocument();
                if (cmDocument instanceof XSDSchemaAdapter && (map = ((XSDSchemaAdapter)cmDocument).annotationMap) != null && (spec = this.getSpec()) != null) {
                    result = map.getProperty(this.getSpec(), propertyName);
                }
            }
            return result;
        }

        public Object getNSPrefixQualification() {
            return null;
        }

        public String getSpec() {
            return "//" + this.getNodeName();
        }
    }

    public static class XSDCMVisitor
    extends XSDVisitor {
        public void visitSimpleTypeDefinition(XSDSimpleTypeDefinition type) {
            XSDParticle ctd = type.getComplexType();
            if (ctd != null) {
                this.visitParticle(ctd);
            }
        }

        public void visitModelGroup(XSDModelGroup modelGroup) {
            if (modelGroup.getParticles() != null) {
                Iterator iterator = modelGroup.getParticles().iterator();
                while (iterator.hasNext()) {
                    XSDParticle particle = (XSDParticle)iterator.next();
                    this.visitParticle(particle);
                }
            }
        }

        public void visitModelGroupDefinition(XSDModelGroupDefinition modelGroupDef) {
            XSDModelGroup modelGroup = modelGroupDef.getResolvedModelGroupDefinition().getModelGroup();
            if (modelGroup != null) {
                this.visitModelGroup(modelGroup);
            }
        }
    }

    public static class XSDElementDeclarationAdapter
    extends ElementDeclarationBaseImpl {
        protected List derivedElementDeclarations = null;
        protected List xsiTypes = null;
        protected XSDElementDeclaration xsdElementDeclaration;
        protected CMNodeListImpl substitutionGroup;

        public XSDElementDeclarationAdapter(XSDElementDeclaration xsdElementDeclaration) {
            this.xsdElementDeclaration = xsdElementDeclaration;
        }

        protected XSDElementDeclaration getXSDElementDeclaration() {
            return this.xsdElementDeclaration;
        }

        protected XSDElementDeclaration getResolvedXSDElementDeclaration() {
            return this.xsdElementDeclaration.getResolvedElementDeclaration();
        }

        public Object getKey() {
            return this.xsdElementDeclaration;
        }

        public CMNode getDefinition() {
            return XSDImpl.getAdapter((Notifier)this.xsdElementDeclaration.getResolvedElementDeclaration());
        }

        protected String getDefinitionInfo() {
            if (this.xsdElementDeclaration.isElementDeclarationReference()) {
                return null;
            }
            if (this.xsdElementDeclaration.isGlobal()) {
                return XSDImpl.DEFINITION_INFO_GLOBAL;
            }
            return XSDImpl.DEFINITION_INFO_LOCAL;
        }

        public Object getNSPrefixQualification() {
            String form = null;
            if (this.xsdElementDeclaration.isElementDeclarationReference()) {
                form = "qualified";
            } else if (this.xsdElementDeclaration.isSetForm()) {
                form = this.xsdElementDeclaration.getForm().getName();
            } else {
                XSDSchema schema = this.xsdElementDeclaration.getSchema();
                if (schema != null) {
                    form = schema.getElementFormDefault().getName();
                }
            }
            return form;
        }

        protected XSDTypeDefinition getXSDType() {
            return this.xsdElementDeclaration.getResolvedElementDeclaration().getTypeDefinition();
        }

        protected List getXSITypes() {
            if (this.xsiTypes == null) {
                this.computeDerivedTypeInfo();
            }
            return this.xsiTypes;
        }

        protected void computeDerivedTypeInfo() {
            this.xsiTypes = new Vector();
            this.derivedElementDeclarations = new Vector();
            this.computeDerivedTypeInfoHelper(this.getXSDType(), this.xsiTypes, this.derivedElementDeclarations);
        }

        protected void computeDerivedTypeInfoHelper(XSDTypeDefinition type, List typeNameList, List edList) {
            if (type instanceof XSDComplexTypeDefinition) {
                List derivedTypes = XSDImpl.findTypesDerivedFrom(type);
                ArrayList<XSDTypeDefinition> inclusiveDerivedTypes = new ArrayList<XSDTypeDefinition>();
                inclusiveDerivedTypes.add(type);
                if (derivedTypes != null && derivedTypes.size() > 0) {
                    inclusiveDerivedTypes.addAll(derivedTypes);
                }
                Iterator i = inclusiveDerivedTypes.iterator();
                while (i.hasNext()) {
                    XSDTypeDefinition derivedType = (XSDTypeDefinition)i.next();
                    XSDSchema schema = derivedType.getSchema();
                    if (schema == null) continue;
                    String uri = schema.getTargetNamespace();
                    String name = derivedType.getName();
                    if (name == null) continue;
                    name = uri != null ? "[" + uri + "]" + name : name;
                    typeNameList.add(name);
                    DerivedElementDeclarationImpl ed = new DerivedElementDeclarationImpl(this, derivedType, name);
                    edList.add(ed);
                }
            }
        }

        protected CMElementDeclaration getDerivedElementDeclaration(String uriQualifiedTypeName) {
            DerivedElementDeclarationImpl result = null;
            if (this.derivedElementDeclarations == null) {
                this.computeDerivedTypeInfo();
            }
            Iterator i = this.derivedElementDeclarations.iterator();
            while (i.hasNext()) {
                DerivedElementDeclarationImpl ed = (DerivedElementDeclarationImpl)((Object)i.next());
                if (ed == null || ed.uriQualifiedTypeName == null || !ed.uriQualifiedTypeName.equals(uriQualifiedTypeName)) continue;
                result = ed;
                break;
            }
            return result;
        }

        protected CMNodeListImpl getSubstitutionGroup() {
            if (this.substitutionGroup == null) {
                this.substitutionGroup = new CMNodeListImpl();
                EList sgroup = this.getResolvedXSDElementDeclaration().getSubstitutionGroup();
                Iterator i = sgroup.iterator();
                while (i.hasNext()) {
                    XSDElementDeclaration ed = (XSDElementDeclaration)i.next();
                    this.substitutionGroup.add(XSDImpl.getAdapter((Notifier)ed));
                }
            }
            return this.substitutionGroup;
        }
    }

    public static class XSDModelGroupAdapter
    extends XSDBaseAdapter
    implements CMGroup {
        protected XSDModelGroup xsdModelGroup;

        public XSDModelGroupAdapter() {
        }

        public XSDModelGroupAdapter(XSDModelGroup xsdModelGroup) {
            this.xsdModelGroup = xsdModelGroup;
        }

        public int getNodeType() {
            return 7;
        }

        public Object getKey() {
            return this.xsdModelGroup;
        }

        public CMNodeList getChildNodes() {
            CMNodeListImpl nodeList = new CMNodeListImpl();
            if (this.xsdModelGroup != null) {
                Iterator i = this.xsdModelGroup.getParticles().iterator();
                while (i.hasNext()) {
                    XSDParticle particle = (XSDParticle)i.next();
                    XSDParticleContent content = particle.getContent();
                    CMNode adapter = XSDImpl.getAdapter((Notifier)content);
                    if (adapter == null) continue;
                    nodeList.getList().add(adapter);
                }
            }
            return nodeList;
        }

        public String getNodeName() {
            CMDescriptionBuilder descriptionBuilder = new CMDescriptionBuilder();
            return descriptionBuilder.buildDescription((CMNode)this);
        }

        public int getMinOccur() {
            return XSDImpl.getMinOccurs((XSDConcreteComponent)this.xsdModelGroup);
        }

        public int getMaxOccur() {
            return XSDImpl.getMaxOccurs((XSDConcreteComponent)this.xsdModelGroup);
        }

        public int getOperator() {
            int result = 0;
            if (this.xsdModelGroup != null) {
                switch (this.xsdModelGroup.getCompositor().getValue()) {
                    case 1: {
                        result = 2;
                        break;
                    }
                    case 2: {
                        result = 1;
                        break;
                    }
                    case 0: {
                        result = 3;
                    }
                }
            }
            return result;
        }

        protected CMNodeList getDocumentation() {
            XSDAnnotation annotation = this.xsdModelGroup.getAnnotation();
            return XSDImpl.getDocumentations(annotation);
        }

        public CMDocument getCMDocument() {
            return (CMDocument)XSDImpl.getAdapter((Notifier)this.xsdModelGroup.getSchema());
        }
    }

    public static class XSDModelGroupDefinitionAdapter
    extends XSDBaseAdapter
    implements CMGroup {
        protected XSDModelGroupDefinition xsdModelGroupDefinition;

        public XSDModelGroupDefinitionAdapter(XSDModelGroupDefinition xsdModelGroupDefinition) {
            this.xsdModelGroupDefinition = xsdModelGroupDefinition;
        }

        public int getNodeType() {
            return 7;
        }

        public Object getKey() {
            return this.xsdModelGroupDefinition;
        }

        public CMNodeList getChildNodes() {
            CMNodeListImpl nodeList = new CMNodeListImpl();
            XSDModelGroup modelGroup = this.xsdModelGroupDefinition.getResolvedModelGroupDefinition().getModelGroup();
            if (modelGroup != null) {
                CMNode adapter = XSDImpl.getAdapter((Notifier)modelGroup);
                nodeList.add(adapter);
            }
            return nodeList;
        }

        public String getNodeName() {
            CMDescriptionBuilder descriptionBuilder = new CMDescriptionBuilder();
            return descriptionBuilder.buildDescription((CMNode)this);
        }

        public int getMinOccur() {
            return XSDImpl.getMinOccurs((XSDConcreteComponent)this.xsdModelGroupDefinition);
        }

        public int getMaxOccur() {
            return XSDImpl.getMaxOccurs((XSDConcreteComponent)this.xsdModelGroupDefinition);
        }

        public int getOperator() {
            return 2;
        }

        protected CMNodeList getDocumentation() {
            XSDAnnotation annotation = this.xsdModelGroupDefinition.getAnnotation();
            return XSDImpl.getDocumentations(annotation);
        }

        public CMDocument getCMDocument() {
            return (CMDocument)XSDImpl.getAdapter((Notifier)this.xsdModelGroupDefinition.getSchema());
        }
    }

    public static class XSDSchemaAdapter
    extends XSDBaseAdapter
    implements CMDocument {
        protected XSDSchema xsdSchema;
        protected CMNamedNodeMapImpl namedNodeMap;
        protected CMNamedNodeMapImpl entityNodeMap;
        protected AnnotationMap annotationMap = new AnnotationMap();
        protected Hashtable substitutionGroupTable;

        public XSDSchemaAdapter(XSDSchema xsdSchema) {
            this.xsdSchema = xsdSchema;
        }

        public Object getKey() {
            return this.xsdSchema;
        }

        public String getNodeName() {
            return this.xsdSchema.getSchemaLocation();
        }

        public boolean supports(String propertyName) {
            return propertyName.equals(XSDImpl.PROPERTY_TARGET_NAMESPACE_URI) || propertyName.equals(XSDImpl.PROPERTY_IMPORTED_NAMESPACE_INFO) || propertyName.equals(XSDImpl.PROPERTY_NAMESPACE_INFO) || propertyName.equals(XSDImpl.PROPERTY_ELEMENT_FORM_DEFAULT) || propertyName.equals(XSDImpl.PROPERTY_ANNOTATION_MAP) || super.supports(propertyName);
        }

        protected boolean isPrefixRequired(XSDSchema xsdSchema) {
            boolean result = true;
            if (xsdSchema.isSetElementFormDefault()) {
                result = xsdSchema.getElementFormDefault().getValue() != 0;
            }
            return result;
        }

        public Object getProperty(String propertyName) {
            CMNamedNodeMap result = null;
            if (propertyName.equals(XSDImpl.PROPERTY_TARGET_NAMESPACE_URI)) {
                result = this.xsdSchema.getTargetNamespace();
            } else if (propertyName.equals(XSDImpl.PROPERTY_IMPORTED_NAMESPACE_INFO)) {
                Vector list = new Vector();
                this.getImportedNamespaceInfo(this.xsdSchema, list);
                result = list;
            } else if (propertyName.equals(XSDImpl.PROPERTY_NAMESPACE_INFO)) {
                CMNamedNodeMap list = new Vector();
                NamespaceInfo info = new NamespaceInfo();
                info.uri = this.xsdSchema.getTargetNamespace();
                info.prefix = XSDImpl.getPrefix(this.xsdSchema, info.uri);
                info.locationHint = null;
                info.isPrefixRequired = this.isPrefixRequired(this.xsdSchema);
                list.add(info);
                this.getImportedNamespaceInfo(this.xsdSchema, (List)list);
                result = list;
            } else if (propertyName.equals(XSDImpl.PROPERTY_COMPLETE_NAMESPACE_INFO)) {
                result = this.getAllNamespaceInfo();
            } else if (propertyName.equals(XSDImpl.PROPERTY_ELEMENT_FORM_DEFAULT)) {
                result = this.xsdSchema.getElementFormDefault().getName();
            } else if (propertyName.equals(XSDImpl.PROPERTY_ANNOTATION_MAP)) {
                result = this.annotationMap;
            } else if (propertyName.equals("allElements")) {
                result = this.getAllElements();
            } else if (propertyName.startsWith("getElementForType#")) {
                int index = propertyName.indexOf("#");
                String typeName = propertyName.substring(index + 1, propertyName.length());
                XSDTypeDefinition td = this.xsdSchema.resolveTypeDefinition(typeName);
                if (td != null) {
                    LocalElementVisitor localElementVisitor = new LocalElementVisitor();
                    localElementVisitor.visitTypeDefinition(td);
                    result = localElementVisitor.getCMNamedNodeMap();
                }
            } else {
                result = super.getProperty(propertyName);
            }
            return result;
        }

        public void getImportedNamespaceInfo(XSDSchema theXSDSchema, List list) {
            Iterator iterator = theXSDSchema.getContents().iterator();
            while (iterator.hasNext()) {
                XSDSchemaContent content = (XSDSchemaContent)iterator.next();
                if (!(content instanceof XSDImport)) continue;
                XSDImport xImport = (XSDImport)content;
                XSDSchema importedXSDSchema = xImport.getResolvedSchema();
                NamespaceInfo info = new NamespaceInfo();
                info.uri = xImport.getNamespace();
                info.prefix = XSDImpl.getPrefix(importedXSDSchema, info.uri);
                info.locationHint = xImport.getSchemaLocation();
                if (importedXSDSchema != null) {
                    info.isPrefixRequired = this.isPrefixRequired(importedXSDSchema);
                }
                list.add(info);
            }
        }

        public CMNamedNodeMap getElements() {
            if (this.namedNodeMap == null) {
                this.namedNodeMap = new CMNamedNodeMapImpl();
                String targetNamespace = this.xsdSchema.getTargetNamespace();
                Iterator i = this.xsdSchema.getElementDeclarations().iterator();
                while (i.hasNext()) {
                    XSDElementDeclaration ed = (XSDElementDeclaration)i.next();
                    if (!(targetNamespace != null ? targetNamespace.equals(ed.getTargetNamespace()) : ed.getTargetNamespace() == null)) continue;
                    XSDElementDeclarationAdapter adapter = (XSDElementDeclarationAdapter)XSDImpl.getAdapter((Notifier)ed);
                    this.namedNodeMap.getHashtable().put(adapter.getNodeName(), adapter);
                }
            }
            return this.namedNodeMap;
        }

        public CMNamedNodeMap getEntities() {
            if (this.entityNodeMap == null) {
                this.entityNodeMap = new CMNamedNodeMapImpl();
                this.entityNodeMap.getHashtable().put("amp", new CMEntityDeclarationImpl("amp", "&"));
                this.entityNodeMap.getHashtable().put("lt", new CMEntityDeclarationImpl("lt", "<"));
                this.entityNodeMap.getHashtable().put("gt", new CMEntityDeclarationImpl("gt", ">"));
                this.entityNodeMap.getHashtable().put("quot", new CMEntityDeclarationImpl("quot", "\""));
                this.entityNodeMap.getHashtable().put("apos", new CMEntityDeclarationImpl("apos", "'"));
            }
            return this.entityNodeMap;
        }

        public int getNodeType() {
            return 4;
        }

        public CMNamespace getNamespace() {
            return null;
        }

        public CMDocument getCMDocument() {
            return this;
        }

        public CMNamedNodeMap getAllElements() {
            CMNamedNodeMapImpl map = new CMNamedNodeMapImpl();
            Iterator i = this.getElements().iterator();
            while (i.hasNext()) {
                CMElementDeclaration ed = (CMElementDeclaration)i.next();
                map.put((CMNode)ed);
                this.addLocalElementDefinitions(map, ed);
            }
            return map;
        }

        protected void addLocalElementDefinitions(CMNamedNodeMapImpl map, CMElementDeclaration parentElementDeclaration) {
            CMNamedNodeMap localElementMap = parentElementDeclaration.getLocalElements();
            Iterator i = localElementMap.iterator();
            while (i.hasNext()) {
                CMElementDeclaration ed = (CMElementDeclaration)i.next();
                if (map.getNamedItem(ed.getNodeName()) != null) continue;
                map.put((CMNode)ed);
                this.addLocalElementDefinitions(map, ed);
            }
        }

        public List getAllNamespaceInfo() {
            ArrayList<NamespaceInfo> namespaceList = new ArrayList<NamespaceInfo>();
            EList resources = this.xsdSchema.eResource().getResourceSet().getResources();
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                XSDSchema schema;
                XSDResourceImpl resource = (XSDResourceImpl)i.next();
                if (!resource.isLoaded() || this.isDataInNamespaceList(namespaceList, 0, (schema = resource.getSchema()).getTargetNamespace())) continue;
                NamespaceInfo info = new NamespaceInfo();
                info.uri = schema.getTargetNamespace();
                info.isPrefixRequired = this.isPrefixRequired(schema);
                info.prefix = XSDImpl.getPrefix(schema, schema.getTargetNamespace());
                if ("http://www.w3.org/XML/1998/namespace".equals(info.uri)) {
                    info.prefix = "xml";
                } else if ("http://www.w3.org/2000/xmlns".equals(info.uri)) {
                    info.prefix = "xmlns";
                } else if (info.uri != null && info.uri != "") {
                    int n = 1;
                    if (info.prefix == null || info.prefix.equals("")) {
                        info.prefix = "p";
                    }
                    String prefix = info.prefix;
                    while (this.isDataInNamespaceList(namespaceList, 1, info.prefix)) {
                        info.prefix = String.valueOf(prefix) + n++;
                    }
                }
                URI relative = URI.createURI((String)this.xsdSchema.getSchemaLocation(), (boolean)true);
                URI absolute = URI.createURI((String)schema.getSchemaLocation(), (boolean)true);
                URI resolvedRelative = absolute.deresolve(relative);
                info.locationHint = resolvedRelative.toString();
                namespaceList.add(info);
            }
            return namespaceList;
        }

        private boolean isDataInNamespaceList(List namespaceList, int data, String value) {
            if (namespaceList != null) {
                Iterator i = namespaceList.iterator();
                block5: while (i.hasNext()) {
                    NamespaceInfo namespaceInfo = (NamespaceInfo)i.next();
                    switch (data) {
                        case 0: {
                            if (namespaceInfo.uri != null && namespaceInfo.uri.equals(value)) {
                                return true;
                            }
                        }
                        case 1: {
                            if (namespaceInfo.prefix != null && namespaceInfo.prefix.equals(value)) {
                                return true;
                            }
                        }
                        case 2: {
                            if (namespaceInfo.locationHint == null || !namespaceInfo.locationHint.equals(value)) continue block5;
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    }

    public static class XSDWildcardAdapter
    extends XSDBaseAdapter
    implements CMAnyElement {
        protected XSDWildcard xsdWildcard;

        public XSDWildcardAdapter(XSDWildcard xsdWildcard) {
            this.xsdWildcard = xsdWildcard;
        }

        public Object getKey() {
            return this.xsdWildcard;
        }

        public int getNodeType() {
            return 1;
        }

        public String getNodeName() {
            return "any";
        }

        public String getNamespaceURI() {
            String uri = this.xsdWildcard.getElement().getAttribute("namespace");
            return uri != null && uri.length() > 0 ? uri : "##any";
        }

        public int getMinOccur() {
            return XSDImpl.getMinOccurs((XSDConcreteComponent)this.xsdWildcard);
        }

        public int getMaxOccur() {
            return XSDImpl.getMaxOccurs((XSDConcreteComponent)this.xsdWildcard);
        }

        public CMDocument getCMDocument() {
            return (CMDocument)XSDImpl.getAdapter((Notifier)this.xsdWildcard.getSchema());
        }

        protected CMNodeList getDocumentation() {
            XSDAnnotation annotation = this.xsdWildcard.getAnnotation();
            return XSDImpl.getDocumentations(annotation);
        }
    }

    public static class XSIDocument
    extends CMDocumentImpl {
        public CMAttributeDeclarationImpl nilAttribute;

        public XSIDocument() {
            super("http://www.w3.org/2001/XMLSchema-instance");
            String[] values = new String[]{XSDImpl.TYPE_VALUE_FALSE, XSDImpl.TYPE_VALUE_TRUE};
            this.nilAttribute = new CMAttributeDeclarationImpl("nil", 2, (CMDataType)new CMDataTypeImpl(XSDImpl.TYPE_NAME_BOOLEAN, values));
            this.nilAttribute.setPrefixQualification(true);
            this.nilAttribute.setCMDocument((CMDocument)this);
        }
    }
}

