/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wizard;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUICore;

public class RuntimeServerSelectionDialog
extends Dialog {
    private Shell thisShell;
    private Text messageBanner_;
    private Composite primaryGroup_;
    private Group runtimesGroup_;
    private Group serversGroup_;
    private Tree runtimesList_;
    private Tree serverList_;
    private Button viewSelectionByRuntimeButton_;
    private Button viewSelectionByServerButton_;
    private Button viewSelectionByExploreButton_;
    private ILabelProvider labelProvider_;
    private Image serverTypesIcon;
    private Image existingServersIcon;
    private String INFOPOP_PWRS_DIALOG = "PWRS0001";
    private String INFOPOP_PWRS_LIST_RUNTIMES = "PWRS0002";
    private String INFOPOP_PWRS_LIST_SERVERS = "PWRS0003";
    private String INFOPOP_PWRS_RADIO_RUNTIME = "PWRS0005";
    private String INFOPOP_PWRS_RADIO_SERVER = "PWRS0006";
    private String INFOPOP_PWRS_RADIO_EXPLORE = "PWRS0007";
    private Hashtable<String, String> serverLabels_;
    private Hashtable<String, IServer> existingServersTable_;
    private String defaultServer_;
    private String defaultRuntime_;
    private String typeId_;
    private RuntimeDescriptor selectedRuntime_;
    private IServer selectedServer_;
    private String selectedServerLabel_;
    private String selectedServerFactoryID_;
    private boolean isExistingServer_;
    private boolean validateOn_ = false;
    private byte selectionMode_;
    private final byte MODE_SERVICE = 0;
    private final String SERVER_TYPES_ICON = "icons/servers/servers_obj.gif";
    private final String EXISTING_SERVERS_ICON = "icons/servers/existing_server_obj.gif";
    private String serverInstanceID_;
    private boolean selectServerFirst_ = false;

    public RuntimeServerSelectionDialog(Shell shell, byte mode, TypeRuntimeServer ids, String j2eeVersion) {
        super(shell);
        this.selectionMode_ = mode;
        this.typeId_ = ids.getTypeId();
        this.defaultRuntime_ = ids.getRuntimeId();
        this.defaultServer_ = ids.getServerId();
        this.serverInstanceID_ = ids.getServerInstanceId();
        this.setIsExistingServer(ids.getServerInstanceId() != null);
        this.serverLabels_ = new Hashtable();
        this.existingServersTable_ = new Hashtable();
        this.labelProvider_ = ServerUICore.getLabelProvider();
    }

    public void setSelectServerFirst(boolean selectServerFirst) {
        this.selectServerFirst_ = selectServerFirst;
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(550, -1, true);
    }

    public TypeRuntimeServer getTypeRuntimeServer() {
        TypeRuntimeServer ids = new TypeRuntimeServer();
        ids.setTypeId(this.typeId_);
        if (this.selectedRuntime_ != null) {
            ids.setRuntimeId(this.selectedRuntime_.getId());
        }
        if (this.selectedServerFactoryID_ == null) {
            ids.setServerId(this.defaultServer_);
            ids.setServerInstanceId(this.serverInstanceID_);
        } else {
            ids.setServerId(this.selectedServerFactoryID_);
            if (this.isExistingServer_ && this.selectedServer_ != null) {
                ids.setServerInstanceId(this.selectedServer_.getId());
            }
        }
        return ids;
    }

    private boolean getIsExistingServer() {
        return this.isExistingServer_;
    }

    private void setIsExistingServer(boolean isExisting) {
        this.isExistingServer_ = isExisting;
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        comp.pack();
        if (this.selectServerFirst_) {
            this.viewSelectionByServerButton_.setSelection(true);
            this.handleServerViewSelectionEvent();
        } else {
            this.viewSelectionByRuntimeButton_.setSelection(true);
        }
        return comp;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.validateOn_ = false;
        this.thisShell = parent.getShell();
        if (this.thisShell == null) {
            this.thisShell = this.createShell();
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        UIUtils uiUtils = new UIUtils("org.eclipse.jst.ws.consumption.ui");
        if (this.selectionMode_ == 0) {
            this.thisShell.setText(ConsumptionUIMessages.PAGE_TITLE_WS_RUNTIME_SELECTION);
        } else {
            this.thisShell.setText(ConsumptionUIMessages.PAGE_TITLE_WS_CLIENT_RUNTIME_SELECTION);
        }
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.thisShell, "org.eclipse.jst.ws.consumption.ui." + this.INFOPOP_PWRS_DIALOG);
        this.messageBanner_ = new Text(composite, 72);
        this.messageBanner_.setText(String.valueOf(ConsumptionUIMessages.PAGE_DESC_WS_RUNTIME_SELECTION) + "\n" + "      ");
        this.messageBanner_.setToolTipText(ConsumptionUIMessages.PAGE_DESC_WS_RUNTIME_SELECTION);
        new Label(composite, 256);
        this.thisShell.setToolTipText(ConsumptionUIMessages.TOOLTIP_PWRS_PAGE);
        String groupName = this.selectionMode_ == 0 ? ConsumptionUIMessages.LABEL_SELECTION_VIEW_TITLE : ConsumptionUIMessages.LABEL_CLIENT_SELECTION_VIEW_TITLE;
        Group viewSelectionGroup_ = uiUtils.createGroup(composite, groupName, null, null);
        Composite viewSelectionComp_ = uiUtils.createComposite((Composite)viewSelectionGroup_, 1);
        this.viewSelectionByServerButton_ = uiUtils.createRadioButton(viewSelectionComp_, ConsumptionUIMessages.LABEL_SELECTION_VIEW_SERVER, ConsumptionUIMessages.TOOLTIP_PWRS_RADIO_SERVER, this.INFOPOP_PWRS_RADIO_SERVER);
        this.viewSelectionByServerButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RuntimeServerSelectionDialog.this.validateOn_) {
                    return;
                }
                RuntimeServerSelectionDialog.this.enableOKButton();
                RuntimeServerSelectionDialog.this.handleServerViewSelectionEvent();
            }
        });
        this.viewSelectionByRuntimeButton_ = uiUtils.createRadioButton(viewSelectionComp_, ConsumptionUIMessages.LABEL_SELECTION_VIEW_RUNTIME, ConsumptionUIMessages.TOOLTIP_PWRS_RADIO_RUNTIME, this.INFOPOP_PWRS_RADIO_RUNTIME);
        this.viewSelectionByRuntimeButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RuntimeServerSelectionDialog.this.validateOn_) {
                    return;
                }
                RuntimeServerSelectionDialog.this.enableOKButton();
                RuntimeServerSelectionDialog.this.handleRuntimeViewSelectionEvent();
            }
        });
        this.viewSelectionByExploreButton_ = uiUtils.createRadioButton(viewSelectionComp_, ConsumptionUIMessages.LABEL_SELECTION_VIEW_EXPLORE, ConsumptionUIMessages.TOOLTIP_PWRS_RADIO_EXPLORE, this.INFOPOP_PWRS_RADIO_EXPLORE);
        this.viewSelectionByExploreButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RuntimeServerSelectionDialog.this.validateOn_) {
                    return;
                }
                RuntimeServerSelectionDialog.this.enableOKButton();
                RuntimeServerSelectionDialog.this.handleExploreViewSelectionEvent();
                super.widgetSelected(e);
            }
        });
        this.primaryGroup_ = uiUtils.createComposite(composite, 1);
        this.runtimesGroup_ = uiUtils.createGroup(this.primaryGroup_, ConsumptionUIMessages.LABEL_RUNTIMES_LIST, ConsumptionUIMessages.TOOLTIP_PWRS_LIST_RUNTIMES, this.INFOPOP_PWRS_LIST_RUNTIMES);
        this.runtimesGroup_.setLayoutData((Object)new GridData(1808));
        this.runtimesList_ = uiUtils.createTree((Composite)this.runtimesGroup_, ConsumptionUIMessages.TOOLTIP_PWRS_LIST_RUNTIMES, this.INFOPOP_PWRS_LIST_RUNTIMES, 2820);
        this.runtimesList_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RuntimeServerSelectionDialog.this.validateOn_) {
                    return;
                }
                RuntimeServerSelectionDialog.this.enableOKButton();
                TreeItem[] runtimeSel = RuntimeServerSelectionDialog.this.runtimesList_.getSelection();
                RuntimeServerSelectionDialog.this.processRuntimeListSelection(runtimeSel[0].getText());
                RuntimeServerSelectionDialog.this.validateServerRuntimeSelection();
            }
        });
        this.serversGroup_ = uiUtils.createGroup(this.primaryGroup_, ConsumptionUIMessages.LABEL_SERVERS_LIST, ConsumptionUIMessages.TOOLTIP_PWRS_LIST_SERVERS, null);
        this.serversGroup_.setLayoutData((Object)new GridData(1808));
        this.serverList_ = uiUtils.createTree((Composite)this.serversGroup_, ConsumptionUIMessages.TOOLTIP_PWRS_LIST_SERVERS, this.INFOPOP_PWRS_LIST_SERVERS, 2820);
        this.serverList_.setLayoutData((Object)new GridData(1808));
        this.serverList_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RuntimeServerSelectionDialog.this.validateOn_) {
                    return;
                }
                RuntimeServerSelectionDialog.this.enableOKButton();
                RuntimeServerSelectionDialog.this.processServerListSelection();
                RuntimeServerSelectionDialog.this.validateServerRuntimeSelection();
            }
        });
        ServersList serverList = new ServersList();
        serverList.setServerTreeItems(this.serverList_);
        this.setRuntimesGroup();
        new Label(composite, 256);
        this.validateOn_ = true;
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateServerRuntimeSelection() {
        TreeItem[] serverSel;
        String currentSelection;
        TreeItem[] runtimeSel;
        if (this.selectionMode_ == 0) {
            if (this.selectedServerFactoryID_ != null && this.selectedRuntime_ != null) {
                if (!WebServiceRuntimeExtensionUtils2.isServerRuntimeTypeSupported(this.selectedServerFactoryID_, this.selectedRuntime_.getId(), this.typeId_)) {
                    String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(this.selectedServerFactoryID_);
                    String runtimeLabel = this.selectedRuntime_.getLabel();
                    this.setERRORStatusMessage(NLS.bind((String)ConsumptionUIMessages.MSG_INVALID_SRT_SELECTIONS, (Object[])new String[]{serverLabel, runtimeLabel}));
                    return;
                }
                this.setOKStatusMessage();
            }
        } else if (this.selectedServerFactoryID_ != null && this.selectedRuntime_ != null) {
            String clientId = this.typeId_;
            if (!WebServiceRuntimeExtensionUtils2.isServerClientRuntimeTypeSupported(this.selectedServerFactoryID_, this.selectedRuntime_.getId(), clientId)) {
                String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(this.selectedServerFactoryID_);
                String runtimeLabel = this.selectedRuntime_.getLabel();
                this.setERRORStatusMessage(NLS.bind((String)ConsumptionUIMessages.MSG_INVALID_SRT_SELECTIONS, (Object[])new String[]{serverLabel, runtimeLabel}));
                return;
            }
            this.setOKStatusMessage();
        }
        if ((runtimeSel = this.runtimesList_.getSelection()) == null || runtimeSel.length <= 0 || runtimeSel[0].getText().length() == 0) {
            this.disableOKButton();
        }
        String string = currentSelection = (serverSel = this.serverList_.getSelection()) != null && serverSel.length > 0 ? serverSel[0].getText() : "";
        if (serverSel == null || currentSelection.length() == 0) {
            this.disableOKButton();
        }
        if (!this.serverLabels_.containsKey(currentSelection) || !this.existingServersTable_.containsKey(currentSelection)) {
            this.disableOKButton();
            this.setOKStatusMessage();
        }
        if (serverSel.length > 0 && serverSel[0].getItemCount() != 0) {
            this.disableOKButton();
            return;
        }
        this.enableOKButton();
    }

    private void setOKStatusMessage() {
        this.messageBanner_.setText(ConsumptionUIMessages.PAGE_DESC_WS_RUNTIME_SELECTION);
        this.messageBanner_.setForeground(Display.getCurrent().getSystemColor(2));
        this.enableOKButton();
    }

    private void setERRORStatusMessage(String message) {
        this.messageBanner_.setText(message);
        this.messageBanner_.setForeground(Display.getCurrent().getSystemColor(3));
        this.disableOKButton();
    }

    private void disableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
    }

    private void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void okPressed() {
        if (this.labelProvider_ != null) {
            this.labelProvider_.dispose();
        }
        if (this.existingServersIcon != null) {
            this.existingServersIcon.dispose();
        }
        if (this.serverTypesIcon != null) {
            this.serverTypesIcon.dispose();
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void cancelPressed() {
        if (this.labelProvider_ != null) {
            this.labelProvider_.dispose();
        }
        if (this.existingServersIcon != null) {
            this.existingServersIcon.dispose();
        }
        if (this.serverTypesIcon != null) {
            this.serverTypesIcon.dispose();
        }
        this.setReturnCode(1);
        this.close();
    }

    private void handleRuntimeViewSelectionEvent() {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.makeColumnsEqualWidth = true;
        GridData gd = new GridData(1808);
        this.primaryGroup_.setLayout((Layout)gl);
        this.primaryGroup_.setLayoutData((Object)gd);
        this.runtimesGroup_.moveAbove((Control)this.serversGroup_);
        this.primaryGroup_.layout();
    }

    public void handleServerViewSelectionEvent() {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.makeColumnsEqualWidth = true;
        GridData gd = new GridData(1808);
        this.primaryGroup_.setLayout((Layout)gl);
        this.primaryGroup_.setLayoutData((Object)gd);
        this.serversGroup_.moveAbove((Control)this.runtimesGroup_);
        this.primaryGroup_.layout();
    }

    private void handleExploreViewSelectionEvent() {
        GridLayout gl = (GridLayout)this.primaryGroup_.getLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        GridData gd = new GridData(1808);
        this.primaryGroup_.setLayout((Layout)gl);
        this.primaryGroup_.setLayoutData((Object)gd);
        this.runtimesGroup_.moveAbove((Control)this.serversGroup_);
        this.primaryGroup_.layout();
    }

    private void processRuntimeListSelection(String runtimeName) {
        this.selectedRuntime_ = this.selectionMode_ == 0 ? WebServiceRuntimeExtensionUtils2.getRuntimeByLabel(runtimeName) : WebServiceRuntimeExtensionUtils2.getRuntimeByLabel(runtimeName);
    }

    private void processServerListSelection() {
        TreeItem[] serverSel = this.serverList_.getSelection();
        if (serverSel != null && serverSel.length > 0) {
            String currentSelection = serverSel[0].getText();
            if (this.serverLabels_.containsKey(currentSelection) || this.existingServersTable_.containsKey(currentSelection)) {
                TreeItem parentItem;
                if (this.existingServersTable_.containsKey(currentSelection)) {
                    this.selectedServer_ = this.existingServersTable_.get(currentSelection);
                    this.selectedServerLabel_ = currentSelection;
                    this.selectedServerFactoryID_ = this.selectedServer_.getServerType().getId();
                } else if (this.serverLabels_.containsKey(currentSelection) && (parentItem = serverSel[0].getParentItem()) != null && !parentItem.getText().equalsIgnoreCase(ConsumptionUIMessages.LABEL_TREE_EXISTING_SERVERS)) {
                    this.selectedServerLabel_ = currentSelection;
                    this.selectedServer_ = null;
                    this.selectedServerFactoryID_ = this.serverLabels_.get(currentSelection);
                }
                parentItem = serverSel[0].getParentItem();
                if (parentItem != null && parentItem.getText().equalsIgnoreCase(ConsumptionUIMessages.LABEL_TREE_EXISTING_SERVERS)) {
                    this.setIsExistingServer(true);
                } else {
                    this.setIsExistingServer(false);
                }
            } else {
                this.selectedServer_ = null;
                this.selectedServerLabel_ = null;
                this.selectedServerFactoryID_ = null;
                this.setIsExistingServer(false);
                return;
            }
        }
    }

    private void setRuntimesGroup() {
        this.runtimesList_.removeAll();
        String[] runtimes = null;
        runtimes = this.selectionMode_ == 0 ? WebServiceRuntimeExtensionUtils2.getRuntimesByServiceType(this.typeId_) : WebServiceRuntimeExtensionUtils2.getRuntimesByClientType(this.typeId_);
        RuntimeNameComparator comparator = new RuntimeNameComparator();
        Arrays.sort(runtimes, comparator);
        TreeItem[] runtimeName = new TreeItem[runtimes.length];
        if (runtimes != null) {
            int i = 0;
            while (i < runtimes.length) {
                String runtimeLabel = this.getRuntimeLabel(runtimes[i]);
                runtimeName[i] = new TreeItem(this.runtimesList_, 0);
                runtimeName[i].setText(runtimeLabel);
                if (runtimes[i].equalsIgnoreCase(this.defaultRuntime_)) {
                    this.runtimesList_.setSelection(new TreeItem[]{runtimeName[i]});
                    this.selectedRuntime_ = this.getRuntime(runtimes[i]);
                }
                ++i;
            }
        }
    }

    private String getRuntimeLabel(String type) {
        return this.getRuntime(type).getLabel();
    }

    private RuntimeDescriptor getRuntime(String type) {
        if (this.selectionMode_ == 0) {
            return WebServiceRuntimeExtensionUtils2.getRuntimeById(type);
        }
        return WebServiceRuntimeExtensionUtils2.getRuntimeById(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RuntimeNameComparator
    implements Comparator<String> {
        @Override
        public int compare(String item1, String item2) {
            try {
                String runtime1 = item1;
                String runtime2 = item2;
                return RuntimeServerSelectionDialog.this.getRuntimeLabel(runtime1).compareToIgnoreCase(RuntimeServerSelectionDialog.this.getRuntimeLabel(runtime2));
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    public class ServersList {
        private TreeItem[] existingServersTree;
        boolean existingServer = false;

        public void setServerTreeItems(Tree serversList) {
            this.setExistingServersTree(serversList);
            this.setServerTypesTree(serversList);
        }

        public void setExistingServersTree(Tree serverList) {
            String[] serverIds = this.getAllExistingServers();
            this.existingServersTree = new TreeItem[1];
            TreeItem[] existingServerItems = new TreeItem[serverIds.length];
            this.existingServersTree[0] = new TreeItem(serverList, 0);
            this.existingServersTree[0].setText(ConsumptionUIMessages.LABEL_TREE_EXISTING_SERVERS);
            ImageDescriptor id = WebServiceConsumptionUIPlugin.getImageDescriptor("icons/servers/existing_server_obj.gif");
            if (id != null) {
                RuntimeServerSelectionDialog.this.existingServersIcon = id.createImage();
                this.existingServersTree[0].setImage(RuntimeServerSelectionDialog.this.existingServersIcon);
            }
            int k = 0;
            while (k < serverIds.length) {
                IServerType serverType;
                IServer server = (IServer)RuntimeServerSelectionDialog.this.existingServersTable_.get(serverIds[k]);
                if (server != null && (serverType = server.getServerType()) != null) {
                    String serverID = serverType.getId();
                    existingServerItems[k] = new TreeItem(this.existingServersTree[0], 0);
                    existingServerItems[k].setText(serverIds[k]);
                    if (serverID.equalsIgnoreCase(RuntimeServerSelectionDialog.this.defaultServer_) && RuntimeServerSelectionDialog.this.getIsExistingServer()) {
                        this.existingServersTree[0].setExpanded(true);
                        serverList.setSelection(new TreeItem[]{existingServerItems[k]});
                        this.existingServer = true;
                        RuntimeServerSelectionDialog.this.setIsExistingServer(true);
                        RuntimeServerSelectionDialog.this.selectedServer_ = server;
                        RuntimeServerSelectionDialog.this.selectedServerLabel_ = serverIds[k];
                        RuntimeServerSelectionDialog.this.selectedServerFactoryID_ = serverID;
                    }
                    existingServerItems[k].setImage(RuntimeServerSelectionDialog.this.labelProvider_.getImage((Object)serverType));
                }
                ++k;
            }
        }

        public void setServerTypesTree(Tree serverList) {
            TreeItem[] serverTypesTree = new TreeItem[]{new TreeItem(serverList, 0)};
            serverTypesTree[0].setText(ConsumptionUIMessages.LABEL_TREE_SERVER_TYPES);
            ImageDescriptor id = WebServiceConsumptionUIPlugin.getImageDescriptor("icons/servers/servers_obj.gif");
            if (id != null) {
                RuntimeServerSelectionDialog.this.serverTypesIcon = id.createImage();
                serverTypesTree[0].setImage(RuntimeServerSelectionDialog.this.serverTypesIcon);
            }
            Hashtable<IServerType, IRuntimeType> categories_ = new Hashtable<IServerType, IRuntimeType>();
            Hashtable<IRuntimeType, TreeItem> categoryTreeItem = new Hashtable<IRuntimeType, TreeItem>();
            String[] serverIds = null;
            serverIds = RuntimeServerSelectionDialog.this.selectionMode_ == 0 ? WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByServiceType(RuntimeServerSelectionDialog.this.typeId_) : WebServiceRuntimeExtensionUtils2.getAllClientServerFactoryIds();
            if (serverIds == null) {
                serverIds = this.getAllServerTypes();
            }
            TreeItem[] parent = new TreeItem[serverIds.length];
            TreeItem[] item = new TreeItem[serverIds.length];
            if (serverIds != null) {
                int i = 0;
                while (i < serverIds.length) {
                    String server = ServerUtils.getInstance().getServerLabelForId(serverIds[i]);
                    if (server != null) {
                        RuntimeServerSelectionDialog.this.serverLabels_.put(server, serverIds[i]);
                        IServerType serverType = ServerCore.findServerType((String)serverIds[i]);
                        IRuntimeType runtimeType = serverType.getRuntimeType();
                        if (!categories_.containsKey(serverType) && runtimeType != null) {
                            categories_.put(serverType, runtimeType);
                            if (categoryTreeItem.get(runtimeType) == null) {
                                String categoryText = runtimeType.getName();
                                Image categoryImage = RuntimeServerSelectionDialog.this.labelProvider_.getImage((Object)runtimeType);
                                parent[i] = new TreeItem(serverTypesTree[0], 0);
                                parent[i].setText(categoryText);
                                parent[i].setImage(categoryImage);
                                categoryTreeItem.put(runtimeType, parent[i]);
                            } else {
                                parent[i] = (TreeItem)categoryTreeItem.get(runtimeType);
                            }
                            String factoryText = serverType.getName();
                            Image factoryImage = RuntimeServerSelectionDialog.this.labelProvider_.getImage((Object)serverType);
                            item[i] = new TreeItem(parent[i], 0);
                            item[i].setText(factoryText);
                            item[i].setImage(factoryImage);
                            item[i].setData((Object)serverType);
                            if (serverIds[i].equals(RuntimeServerSelectionDialog.this.defaultServer_) && !this.existingServer) {
                                serverList.setSelection(new TreeItem[]{item[i]});
                                RuntimeServerSelectionDialog.this.selectedServer_ = null;
                                RuntimeServerSelectionDialog.this.selectedServerLabel_ = factoryText;
                                RuntimeServerSelectionDialog.this.selectedServerFactoryID_ = (String)RuntimeServerSelectionDialog.this.serverLabels_.get(RuntimeServerSelectionDialog.this.selectedServerLabel_);
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        private String[] getAllExistingServers() {
            Vector<String> serverIds = new Vector<String>();
            IServer[] servers = ServerCore.getServers();
            if (servers != null && servers.length != 0) {
                int i = 0;
                while (i < servers.length) {
                    IServer server = servers[i];
                    serverIds.add(server.getName());
                    RuntimeServerSelectionDialog.this.existingServersTable_.put(server.getName(), server);
                    ++i;
                }
            }
            return serverIds.toArray(new String[serverIds.size()]);
        }

        private String[] getAllServerTypes() {
            Vector<String> serverTypes_ = new Vector<String>();
            IServerType[] defaultServersList = ServerCore.getServerTypes();
            int i = 0;
            while (i < defaultServersList.length) {
                IServerType serverType = defaultServersList[i];
                serverTypes_.add(serverType.getId());
                ++i;
            }
            return serverTypes_.toArray(new String[serverTypes_.size()]);
        }
    }
}

