/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.client.internal.impl.ApplicationClientImpl;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.MessageDestination;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.common.internal.impl.EjbRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ValidateXmlCommand;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.NoModuleFileException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.model.internal.validation.EARValidationMessageResourceHandler;
import org.eclipse.jst.j2ee.model.internal.validation.ERefValidationMessageResourceHandler;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class EarValidator
extends J2EEValidator {
    public static final String RES_REF_GROUP_NAME = "RES_REF_GROUP_NAME";
    public static final String RES_ENV_REF_GROUP_NAME = "RES_ENV_REF_GROUP_NAME";
    public static final String SERVICE_REF_GROUP_NAME = "SERVICE_REF_GROUP_NAME";
    public static final String EJB_REF_GROUP_NAME = "EJB_REF_GROUP_NAME";
    public static final String SEC_ROLE_REF_GROUP_NAME = "SEC_ROLE_REF_GROUP_NAME";
    public static final String MESSAGE_REF_GROUP_NAME = "MESSAGE_REF_GROUP_NAME";
    public static final String MESSAGE_DESTINATION_REF_GROUP_NAME = "MESSAGE_DESTINATION_REF_GROUP_NAME";
    public static final String MESSAGE_DESTINATION_MDB_REF_GROUP_NAME = "MESSAGE_DESTINATION_MDB_REF_GROUP_NAME";
    protected EARFile earFile;
    protected Application appDD;

    public Command createValidateXMLCommand() {
        ValidateXmlCommand cmd = new ValidateXmlCommand(this.earFile);
        return cmd;
    }

    public String getBaseName() {
        return "earvalidation";
    }

    public void validate() throws ValidationException {
        this.validateModules(this.appDD.getModules());
        this.validateSecurity();
        this.validateRefs();
        this.validateWebContexts();
        this.validateSpecLevel();
        this.validateMessageDestinations();
    }

    public void validate(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        this.validateInJob(inHelper, inReporter);
    }

    public IStatus validateInJob(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        inReporter.removeAllMessages((IValidator)this);
        super.validateInJob(inHelper, inReporter);
        try {
            this.earFile = (EARFile)this._helper.loadModel("EAR_VALIDATION");
            if (this.earFile != null) {
                this.appDD = this.earFile.getDeploymentDescriptor();
                if (this.appDD == null || this.appDD.eResource() == null || !this.appDD.eResource().isLoaded()) {
                    String msg = NLS.bind((String)EARValidationMessageResourceHandler.EAR_DD_CANNOT_OPEN_DD, (Object[])new String[]{this.getResourceName()});
                    LocalizedMessage errorMsg = new LocalizedMessage(1, msg);
                    this.status = WTPCommonPlugin.createErrorStatus((String)errorMsg.getText());
                    throw new ValidationException((IMessage)errorMsg);
                }
            } else {
                String msg = NLS.bind((String)EARValidationMessageResourceHandler.ERROR_EAR_INVALID_EAR_FILE, (Object[])new String[]{this.getResourceName()});
                LocalizedMessage errorMsg = new LocalizedMessage(1, msg);
                throw new ValidationException((IMessage)errorMsg);
            }
            this.validate();
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception e) {
            Object[] param = new String[1];
            if (this.earFile != null) {
                param[0] = this.earFile.getName();
            }
            Logger.getLogger().logError((Throwable)e);
            String msg = NLS.bind((String)EARValidationMessageResourceHandler.EAR_VALIDATION_INTERNAL_ERROR_UI_, (Object[])param);
            LocalizedMessage errorMsg = new LocalizedMessage(1, msg);
            throw new ValidationException((IMessage)errorMsg, (Throwable)e);
        }
        return this.status;
    }

    protected String getResourceName() {
        return this.earFile.getURI();
    }

    public void validateEarRoles(EList earRoleList) {
        HashSet<String> s = new HashSet<String>(earRoleList.size());
        int i = 0;
        while (i < earRoleList.size()) {
            SecurityRole securityRole = (SecurityRole)earRoleList.get(i);
            if (!s.add(securityRole.getRoleName())) {
                String roleName = securityRole.getRoleName();
                Object[] params = new String[]{roleName};
                String msg = NLS.bind((String)EARValidationMessageResourceHandler.ERROR_EAR_DUPLICATE_ROLES, (Object[])params);
                this.addLocalizedWarning(msg, this.appDD);
            }
            ++i;
        }
    }

    public void validateEJBRefMandatoryElements(List ejbRefs, String uri) {
        int i = 0;
        while (i < ejbRefs.size()) {
            EjbRef eref = (EjbRef)ejbRefs.get(i);
            String refName = eref.getName();
            String[] params = new String[]{refName, uri};
            if (eref.getName() == null || eref.getName().trim() == null || eref.getName().trim().length() == 0) {
                this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_MISSING_EREFNAME", params);
            }
            if (eref.isSetType()) {
                if (eref.getType() == null) {
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_INVALID_EREFTYPE", params);
                }
            } else {
                this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_MISSING_EREFTYPE", params);
            }
            if (eref.getHome() == null || eref.getHome().trim().length() == 0) {
                this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_MISSING_EREFHOME", params);
            }
            if (eref.getRemote() == null || eref.getRemote().trim().length() == 0) {
                this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_MISSING_EREFREMOTE", params);
            }
            ++i;
        }
    }

    public boolean isSimilarEJBInterface(EjbRef eref, EnterpriseBean ejb) {
        if (eref.isLocal()) {
            if (ejb.getLocalHomeInterfaceName() == null || ejb.getLocalInterfaceName() == null || ((EJBLocalRef)eref).getLocalHome() == null || ((EJBLocalRef)eref).getLocal() == null) {
                return false;
            }
            boolean isHomeLocalOk = ejb.getLocalHomeInterfaceName().equals(((EJBLocalRef)eref).getLocalHome());
            boolean isRemoteLocalOk = ejb.getLocalInterfaceName().equals(((EJBLocalRef)eref).getLocal());
            return isHomeLocalOk && isRemoteLocalOk;
        }
        if (ejb.getHomeInterfaceName() == null || ejb.getRemoteInterfaceName() == null || eref.getHome() == null || eref.getRemote() == null) {
            return false;
        }
        boolean isHomeOk = ejb.getHomeInterfaceName().equals(eref.getHome());
        boolean isRemoteOk = ejb.getRemoteInterfaceName().equals(eref.getRemote());
        return isHomeOk && isRemoteOk;
    }

    public void validateEJBRefs(List ejbRefs, String uri) {
        int i = 0;
        while (i < ejbRefs.size()) {
            EjbRef eref = (EjbRef)ejbRefs.get(i);
            if (eref != null && eref.getLink() != null && eref.getLink().length() > 0) {
                String msg;
                Object[] params;
                EnterpriseBean ejb = this.earFile.getEnterpiseBeanFromRef(eref, uri);
                if (ejb == null) {
                    params = new String[]{eref.getName(), uri, this.earFile.getName()};
                    msg = NLS.bind((String)ERefValidationMessageResourceHandler.UNRESOLVED_EJB_REF_WARN_, (Object[])params);
                    this.addLocalizedWarning(msg, null);
                } else if (!this.isSimilarEJBInterface(eref, ejb)) {
                    params = new String[]{ejb.getName(), eref.getName(), uri};
                    msg = NLS.bind((String)EARValidationMessageResourceHandler.EJB_BEAN_EJB_LINK_INTEFACE_MISMATCH_ERROR_, (Object[])params);
                    this.addLocalizedError(msg, this.appDD);
                }
            }
            ++i;
        }
    }

    public void validateEJBRolesWithEARRoles(EList earRoleList, EList ejbRoles) {
        int i = 0;
        while (i < ejbRoles.size()) {
            if (!earRoleList.contains(ejbRoles.get(i))) {
                String[] params = new String[]{((SecurityRole)ejbRoles.get(i)).getRoleName()};
                this.addWarning("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_MISSING_EJB_ROLE", params);
            }
            ++i;
        }
    }

    public void validateModules(EList modulesList) {
        LocalizedMessage msg = new LocalizedMessage(2, "Validating Modules");
        this._reporter.displaySubtask((IValidator)this, (IMessage)msg);
        HashSet<String> duplicateURI = new HashSet<String>();
        int i = 0;
        while (i < modulesList.size()) {
            String key;
            Module m = (Module)modulesList.get(i);
            String filename = m.getUri();
            if (filename == null || filename.length() == 0) {
                this.addLocalizedError(EARValidationMessageResourceHandler.MESSAGE_EAR_NO_MODULE_URI, null);
            } else if (filename.indexOf(" ") != -1) {
                Object[] params = new String[]{filename};
                String msg1 = NLS.bind((String)EARValidationMessageResourceHandler.URI_CONTAINS_SPACES_ERROR_, (Object[])params);
                this.addLocalizedError(msg1, this.appDD);
            }
            String altDD = m.getAltDD();
            if (altDD != null) {
                altDD = altDD.trim();
            }
            this.validateAltDD(m, altDD);
            String string = key = altDD == null ? String.valueOf(filename) + altDD : filename;
            if (!duplicateURI.add(key)) {
                Object[] params = new String[]{m.getUri(), this.earFile.getName()};
                String tmp = NLS.bind((String)EARValidationMessageResourceHandler.MESSAGE_EAR_DUPLICATE_URI_ERROR_, (Object[])params);
                this.addLocalizedError(tmp, this.appDD);
            }
            ++i;
        }
    }

    protected void validateAltDD(Module m, String altDD) {
        if ("".equals(altDD)) {
            Object[] params = new String[]{m.getUri(), this.earFile.getName()};
            String tmp = NLS.bind((String)EARValidationMessageResourceHandler.MESSAGE_EMPTY_ALT_DD_ERROR_, (Object[])params);
            this.addLocalizedError(tmp, this.appDD);
        } else if (altDD != null && !this.earFile.isDuplicate(altDD)) {
            Object[] params = new String[]{m.getUri(), altDD, this.earFile.getName()};
            String tmp = NLS.bind((String)EARValidationMessageResourceHandler.MESSAGE_INVALID_ALT_DD_WARN_, (Object[])params);
            this.addLocalizedWarning(tmp, this.appDD);
        }
    }

    public void validateRefs() {
        LocalizedMessage msg = new LocalizedMessage(2, "Validating Refs");
        this._reporter.displaySubtask((IValidator)this, (IMessage)msg);
        EList moduleList = this.earFile.getModuleRefs();
        int i = 0;
        while (i < moduleList.size()) {
            ModuleRef ref = (ModuleRef)moduleList.get(i);
            try {
                if (ref.isWeb()) {
                    this.validateWebAppRefs(ref);
                } else if (ref.isEJB()) {
                    this.validateEJBModuleRefs(ref);
                } else if (ref.isClient()) {
                    this.validateAppClientRefs(ref);
                }
            }
            catch (ArchiveWrappedException archiveWrappedException) {
                String[] params = new String[]{ref.getUri()};
                this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_MODULE_DD_FILE_NOT_FOUND", params);
            }
            ++i;
        }
    }

    private void validateAppClientRefs(ModuleRef ref) throws ArchiveWrappedException {
        ApplicationClientImpl appClient = (ApplicationClientImpl)ref.getDeploymentDescriptor();
        ArrayList ejbRefs = new ArrayList();
        ejbRefs.addAll(appClient.getEjbReferences());
        this.validateEJBRefMandatoryElements(ejbRefs, ref.getUri());
        this.validateEJBRefs(ejbRefs, ref.getUri());
        if (appClient != null && appClient.getVersionID() <= 13) {
            HashSet allRefs = new HashSet();
            EList resourceRefs = appClient.getResourceRefs();
            EList resourceEnvRefs = appClient.getResourceEnvRefs();
            EList serviceRefs = appClient.getServiceRefs();
            this.validateDuplicateEJBRefs(allRefs, ejbRefs);
            this.validateDuplicateResourceRefs(allRefs, (List)resourceRefs);
            this.validateDuplicateResourceEnvRefs(allRefs, (List)resourceEnvRefs);
            this.validateDuplicateServiceRefs(allRefs, (List)serviceRefs);
        }
    }

    private void validateWebAppRefs(ModuleRef ref) throws ArchiveWrappedException {
        WebApp webApp = (WebApp)ref.getDeploymentDescriptor();
        ArrayList ejbRefs = new ArrayList();
        ejbRefs.addAll(webApp.getEjbRefs());
        ejbRefs.addAll(webApp.getEjbLocalRefs());
        this.validateEJBRefMandatoryElements(ejbRefs, ref.getUri());
        this.validateEJBRefs(ejbRefs, ref.getUri());
        if (webApp != null && webApp.getVersionID() <= 23) {
            HashSet allRefs = new HashSet();
            EList resourceRefs = webApp.getResourceRefs();
            EList resourceEnvRefs = webApp.getResourceEnvRefs();
            EList serviceRefs = webApp.getServiceRefs();
            this.validateDuplicateEJBRefs(allRefs, ejbRefs);
            this.validateDuplicateResourceRefs(allRefs, (List)resourceRefs);
            this.validateDuplicateResourceEnvRefs(allRefs, (List)resourceEnvRefs);
            this.validateDuplicateServiceRefs(allRefs, (List)serviceRefs);
        }
    }

    private void validateEJBModuleRefs(ModuleRef ref) throws ArchiveWrappedException {
        EList ejbCollection;
        EJBJar ejbJar = (EJBJar)ref.getDeploymentDescriptor();
        if (!(ejbJar == null || (ejbCollection = ejbJar.getEnterpriseBeans()) == null && ejbCollection.isEmpty())) {
            Resource res = ejbJar.eResource();
            this.cleanUpAllRefSubTaskMessages(res);
            for (EnterpriseBean ejbBean : ejbCollection) {
                if (ejbBean == null) continue;
                ArrayList ejbRefs = new ArrayList();
                ejbRefs.addAll(ejbBean.getEjbRefs());
                ejbRefs.addAll(ejbBean.getEjbLocalRefs());
                this.validateEJBRefMandatoryElements(ejbRefs, ref.getUri());
                this.validateEJBRefs(ejbRefs, ref.getUri());
                if (ejbJar.getVersionID() > 20) continue;
                HashSet allRefs = new HashSet();
                EList resourceRefs = ejbBean.getResourceRefs();
                EList resourceEnvRefs = ejbBean.getResourceEnvRefs();
                EList secRoleRefs = ejbBean.getSecurityRoleRefs();
                EList serviceRefs = ejbBean.getServiceRefs();
                EList messageDestRefs = ejbBean.getMessageDestinationRefs();
                this.validateDuplicateEJBRefs(allRefs, ejbRefs);
                this.validateDuplicateResourceRefs(allRefs, (List)resourceRefs);
                this.validateDuplicateResourceEnvRefs(allRefs, (List)resourceEnvRefs);
                this.validateDuplicateSecurityRoleRefs(allRefs, (List)secRoleRefs);
                this.validateDuplicateServiceRefs(allRefs, (List)serviceRefs);
                this.validateDuplicateMessageDestRefs(allRefs, (List)messageDestRefs);
            }
        }
    }

    private void validateDuplicateServiceRefs(Set allRefs, List serviceRefs) {
        if (!serviceRefs.isEmpty()) {
            ServiceRef firstRef = (ServiceRef)serviceRefs.get(0);
            if (!(firstRef.eContainer() instanceof EnterpriseBean)) {
                this.cleanUpSubTaskMessages(firstRef);
            }
            int refNo = 0;
            while (refNo < serviceRefs.size()) {
                ServiceRef ref = (ServiceRef)serviceRefs.get(refNo);
                String refName = ref.getServiceRefName();
                String[] parms = new String[]{refName};
                if (!allRefs.add(refName)) {
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_DUPLICATE_SERVICEREF", parms, ref, SERVICE_REF_GROUP_NAME);
                }
                ++refNo;
            }
        }
    }

    private void validateDuplicateSecurityRoleRefs(Set allRefs, List secRoleRefs) {
        if (!secRoleRefs.isEmpty()) {
            SecurityRoleRef firstRef = (SecurityRoleRef)secRoleRefs.get(0);
            if (!(firstRef.eContainer() instanceof EnterpriseBean)) {
                this.cleanUpSubTaskMessages(firstRef);
            }
            int refNo = 0;
            while (refNo < secRoleRefs.size()) {
                SecurityRoleRef ref = (SecurityRoleRef)secRoleRefs.get(refNo);
                String refName = ref.getName();
                String[] parms = new String[]{refName};
                if (!allRefs.add(refName)) {
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_DUPLICATE_SECURITYROLEREF", parms, ref, SEC_ROLE_REF_GROUP_NAME);
                }
                ++refNo;
            }
        }
    }

    private void validateDuplicateResourceEnvRefs(Set allRefs, List resourceEnvRefs) {
        if (!resourceEnvRefs.isEmpty()) {
            ResourceEnvRef firstRef = (ResourceEnvRef)resourceEnvRefs.get(0);
            if (!(firstRef.eContainer() instanceof EnterpriseBean)) {
                this.cleanUpSubTaskMessages(firstRef);
            }
            int refNo = 0;
            while (refNo < resourceEnvRefs.size()) {
                ResourceEnvRef ref = (ResourceEnvRef)resourceEnvRefs.get(refNo);
                String refName = ref.getName();
                String[] parms = new String[]{refName};
                if (!allRefs.add(refName)) {
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_DUPLICATE_RESENVREF", parms, ref, RES_ENV_REF_GROUP_NAME);
                }
                ++refNo;
            }
        }
    }

    private void validateDuplicateResourceRefs(Set allRefs, List resourceRefs) {
        if (!resourceRefs.isEmpty()) {
            ResourceRef firstRef = (ResourceRef)resourceRefs.get(0);
            if (!(firstRef.eContainer() instanceof EnterpriseBean)) {
                this.cleanUpSubTaskMessages(firstRef);
            }
            int refNo = 0;
            while (refNo < resourceRefs.size()) {
                ResourceRef ref = (ResourceRef)resourceRefs.get(refNo);
                String refName = ref.getName();
                String[] parms = new String[]{refName};
                if (!allRefs.add(refName)) {
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_DUPLICATE_RESREF", parms, ref, RES_REF_GROUP_NAME);
                }
                ++refNo;
            }
        }
    }

    protected void validateDuplicateEJBRefs(Set allRefs, List ejbRefs) {
        if (!ejbRefs.isEmpty()) {
            EjbRef firstRef = (EjbRef)ejbRefs.get(0);
            if (!(firstRef.eContainer() instanceof EnterpriseBean)) {
                this.cleanUpSubTaskMessages(firstRef);
            }
            int refNo = 0;
            while (refNo < ejbRefs.size()) {
                EjbRefImpl ref = (EjbRefImpl)ejbRefs.get(refNo);
                String refName = ref.getName();
                String[] parms = new String[]{refName};
                if (!allRefs.add(refName)) {
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_DUPLICATE_EJBREF", parms, ref, EJB_REF_GROUP_NAME);
                }
                ++refNo;
            }
        }
    }

    protected void validateDuplicateMessageDestRefs(Set allRefs, List messageDestRefs) {
        if (!messageDestRefs.isEmpty()) {
            MessageDestinationRef firstRef = (MessageDestinationRef)messageDestRefs.get(0);
            if (!(firstRef.eContainer() instanceof EnterpriseBean)) {
                this.cleanUpSubTaskMessages(firstRef);
            }
            int refNo = 0;
            while (refNo < messageDestRefs.size()) {
                MessageDestinationRef ref = (MessageDestinationRef)messageDestRefs.get(refNo);
                String refName = ref.getName();
                String[] parms = new String[]{refName};
                if (!allRefs.add(refName)) {
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_DUPLICATE_MESSSAGEDESTINATIONREF", parms, ref, MESSAGE_REF_GROUP_NAME);
                }
                ++refNo;
            }
        }
    }

    protected void cleanUpSubTaskMessages(EObject ref) {
    }

    protected void cleanUpAllRefSubTaskMessages(Resource res) {
    }

    public void addEJBRefs(List currentRefs, List ejbRefs) {
        if (currentRefs == null || ejbRefs == null) {
            return;
        }
        ejbRefs.addAll(currentRefs);
    }

    public void validateSecurity() {
        EList moduleList;
        EList earRoleList = this.appDD.getSecurityRoles();
        if (!earRoleList.isEmpty()) {
            this.validateEarRoles(earRoleList);
        }
        if (!(moduleList = this.appDD.getModules()).isEmpty()) {
            int i = 0;
            while (i < moduleList.size()) {
                EList webRoles;
                EList ejbRoles;
                Module m = (Module)moduleList.get(i);
                if (m.isEjbModule() && !(ejbRoles = m.getApplication().getSecurityRoles()).isEmpty()) {
                    this.validateEJBRolesWithEARRoles(earRoleList, ejbRoles);
                }
                if (m.isWebModule() && !(webRoles = m.getApplication().getSecurityRoles()).isEmpty()) {
                    this.validateWEBRolesWithEARRoles(earRoleList, webRoles);
                }
                ++i;
            }
        }
    }

    public void validateWebContexts() {
        EList moduleList = this.appDD.getModules();
        HashMap<String, WebModule> visitedWebContext = new HashMap<String, WebModule>();
        if (!moduleList.isEmpty()) {
            for (Module module : moduleList) {
                WebModule webModule;
                if (!module.isWebModule() || (webModule = (WebModule)module) == null) continue;
                if (visitedWebContext.containsKey(webModule.getContextRoot())) {
                    WebModule tempWebModule = (WebModule)visitedWebContext.get(webModule.getContextRoot());
                    Object[] params = new String[]{webModule.getContextRoot(), webModule.getUri(), tempWebModule.getUri()};
                    String tmp = NLS.bind((String)EARValidationMessageResourceHandler.MESSAGE_EAR_DUPICATE_ROOTCONTEXT_ERROR_, (Object[])params);
                    this.addLocalizedError(tmp, this.appDD);
                    continue;
                }
                visitedWebContext.put(webModule.getContextRoot(), webModule);
            }
        }
    }

    private void validateSpecLevel() {
        int earVersion = this.getVersionID(this.earFile);
        List modules = this.earFile.getModuleFiles();
        if (!modules.isEmpty()) {
            Iterator iterator = modules.iterator();
            ModuleFile moduleFile = null;
            while (iterator.hasNext()) {
                moduleFile = (ModuleFile)iterator.next();
                if (moduleFile == null || this.getVersionID(moduleFile) <= earVersion) continue;
                Object[] params = new String[]{moduleFile.getURI(), this.earFile.getName()};
                String tmp = NLS.bind((String)EARValidationMessageResourceHandler.MESSAGE_INCOMPATIBLE_SPEC_WARNING_, (Object[])params);
                this.addLocalizedWarning(tmp, this.appDD);
            }
        }
    }

    private int getVersionID(ModuleFile moduleFile) {
        XMLResource res = null;
        try {
            res = (XMLResource)moduleFile.getDeploymentDescriptorResource();
        }
        catch (ResourceLoadException resourceLoadException) {
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (res != null) {
            return res.getJ2EEVersionID();
        }
        return -1;
    }

    private void validateMessageDestinations() {
        this.validateMessageDestinationRefs();
        this.validateMDBMessageDestinations();
    }

    private void validateMDBMessageDestinations() {
        EList moduleList = this.earFile.getModuleRefs();
        int i = 0;
        while (i < moduleList.size()) {
            block6: {
                ModuleRef ref = (ModuleRef)moduleList.get(i);
                try {
                    EJBJar ejbJar;
                    if (ref.isEJB() && (ejbJar = (EJBJar)ref.getDeploymentDescriptor()) != null) {
                        this.removeAllMessages(ejbJar, MESSAGE_DESTINATION_MDB_REF_GROUP_NAME);
                        EList ejbCollection = ejbJar.getEnterpriseBeans();
                        if (ejbCollection != null || !ejbCollection.isEmpty()) {
                            for (EnterpriseBean ejbBean : ejbCollection) {
                                String link;
                                MessageDriven messageDrivenBean;
                                if (ejbBean == null || !ejbBean.isMessageDriven() || (messageDrivenBean = (MessageDriven)ejbBean).getVersionID() < 21 || (link = messageDrivenBean.getLink()) == null || this.isExistMessageDestinationLink(link, ref)) continue;
                                String[] params = new String[]{link, messageDrivenBean.getName(), ref.getUri(), this.earFile.getName()};
                                this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_UNRESOLVED_MDB_MISSING_MESSAGE_DESTINATION", params, messageDrivenBean, MESSAGE_DESTINATION_MDB_REF_GROUP_NAME);
                            }
                        }
                    }
                }
                catch (ArchiveWrappedException ex) {
                    Exception nested = ex.getNestedException();
                    if (nested instanceof NoModuleFileException) break block6;
                    String[] params = new String[]{ref.getUri()};
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_MODULE_DD_FILE_NOT_FOUND", params);
                }
            }
            ++i;
        }
    }

    private void validateMessageDestinationRefs() {
        EList moduleList = this.earFile.getModuleRefs();
        int i = 0;
        while (i < moduleList.size()) {
            ModuleRef ref = (ModuleRef)moduleList.get(i);
            this.validateMessageDestinationRefs(ref);
            ++i;
        }
    }

    private void validateMessageDestinationRefs(ModuleRef moduleRef) {
        List destinationsRefs = this.getMessageDestinationRefs(moduleRef);
        this.clearUpSubTaskMessageDestinationMessages(moduleRef, destinationsRefs);
        int refNo = 0;
        while (refNo < destinationsRefs.size()) {
            MessageDestinationRef ref = (MessageDestinationRef)destinationsRefs.get(refNo);
            String link = ref.getLink();
            if (link != null) {
                String[] params;
                if (link.length() == 0) {
                    params = new String[]{ref.getName(), moduleRef.getUri(), this.earFile.getName()};
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_MISSING_EMPTY_MESSSAGEDESTINATION", params, ref, MESSAGE_DESTINATION_REF_GROUP_NAME);
                } else if (!this.isExistMessageDestinationLink(link, moduleRef)) {
                    params = new String[]{link, ref.getName(), moduleRef.getUri(), this.earFile.getName()};
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_MISSING_MESSSAGEDESTINATION", params, ref, MESSAGE_DESTINATION_REF_GROUP_NAME);
                }
            }
            ++refNo;
        }
    }

    private void clearUpSubTaskMessageDestinationMessages(ModuleRef moduleRef, List destinationsRefs) {
        try {
            if (moduleRef != null && moduleRef.getDeploymentDescriptor() != null) {
                this.removeAllMessages(moduleRef.getDeploymentDescriptor(), MESSAGE_DESTINATION_REF_GROUP_NAME);
            }
        }
        catch (ArchiveWrappedException e) {
            e.printStackTrace();
        }
        int refNo = 0;
        while (refNo < destinationsRefs.size()) {
            MessageDestinationRef ref = (MessageDestinationRef)destinationsRefs.get(refNo);
            this.removeAllMessages(ref, MESSAGE_DESTINATION_REF_GROUP_NAME);
            ++refNo;
        }
    }

    protected void removeAllMessages(EObject eObject, String groupName) {
    }

    private boolean isExistMessageDestinationLink(String link, ModuleRef moduleRef) {
        String destinationName;
        if (link == null) {
            return false;
        }
        int index = link.indexOf(35);
        if (index == -1) {
            destinationName = link;
        } else {
            String moduleName = link.substring(0, index);
            destinationName = link.substring(index + 1);
            moduleRef = this.getModuleRefByName(moduleName);
            if (moduleRef == null) {
                return false;
            }
        }
        List destinations = this.getMessageDestinations(moduleRef);
        int i = 0;
        while (i < destinations.size()) {
            MessageDestination messageDestination = (MessageDestination)destinations.get(i);
            if (destinationName.equals(messageDestination.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ModuleRef getModuleRefByName(String moduleName) {
        EList moduleList = this.earFile.getModuleRefs();
        int i = 0;
        while (i < moduleList.size()) {
            ModuleRef ref = (ModuleRef)moduleList.get(i);
            Module module = ref.getModule();
            if (moduleName.equals(module.getUri())) {
                return ref;
            }
            ++i;
        }
        return null;
    }

    private List getMessageDestinationRefs(ModuleRef ref) {
        ArrayList destinationRefs;
        block7: {
            destinationRefs = new ArrayList();
            try {
                if (ref.isWeb()) {
                    WebApp webApp = (WebApp)ref.getDeploymentDescriptor();
                    destinationRefs.addAll(webApp.getMessageDestinationRefs());
                } else if (ref.isEJB()) {
                    EJBJar ejbJar = (EJBJar)ref.getDeploymentDescriptor();
                    destinationRefs.addAll(this.getEJBMessageDestinationRefs(ejbJar));
                } else if (ref.isClient()) {
                    ApplicationClientImpl appClient = (ApplicationClientImpl)ref.getDeploymentDescriptor();
                    destinationRefs.addAll(appClient.getMessageDestinationRefs());
                }
            }
            catch (ArchiveWrappedException ex) {
                Exception nested = ex.getNestedException();
                if (nested instanceof NoModuleFileException) break block7;
                String[] params = new String[]{ref.getUri()};
                this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_MODULE_DD_FILE_NOT_FOUND", params);
            }
        }
        return destinationRefs;
    }

    private List getEJBMessageDestinationRefs(EJBJar ejbJar) {
        EList ejbCollection;
        ArrayList ejbMessageDestinationRefs = new ArrayList();
        if (!(ejbJar == null || (ejbCollection = ejbJar.getEnterpriseBeans()) == null && ejbCollection.isEmpty())) {
            for (EnterpriseBean ejbBean : ejbCollection) {
                if (ejbBean == null) continue;
                ejbMessageDestinationRefs.addAll(ejbBean.getMessageDestinationRefs());
            }
        }
        return ejbMessageDestinationRefs;
    }

    private List getMessageDestinations(ModuleRef ref) {
        ArrayList destinations;
        block8: {
            destinations = new ArrayList();
            try {
                if (ref.isWeb()) {
                    WebApp webApp = (WebApp)ref.getDeploymentDescriptor();
                    destinations.addAll(webApp.getMessageDestinations());
                } else if (ref.isEJB()) {
                    EJBJar ejbJar = (EJBJar)ref.getDeploymentDescriptor();
                    if (ejbJar != null && ejbJar.getAssemblyDescriptor() != null) {
                        destinations.addAll(ejbJar.getAssemblyDescriptor().getMessageDestinations());
                    }
                } else if (ref.isClient()) {
                    ApplicationClientImpl appClient = (ApplicationClientImpl)ref.getDeploymentDescriptor();
                    destinations.addAll(appClient.getMessageDestinations());
                }
            }
            catch (ArchiveWrappedException ex) {
                Exception nested = ex.getNestedException();
                if (nested instanceof NoModuleFileException) break block8;
                Logger.getLogger().logError((Throwable)ex);
            }
        }
        return destinations;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        this._helper = helper;
        return null;
    }

    public void cleanup(IReporter reporter) {
        this.earFile = null;
        this.appDD = null;
        super.cleanup(reporter);
    }
}

