/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.orm.details;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.ui.internal.orm.JptUiOrmMessages;
import org.eclipse.jpt.ui.internal.orm.details.OrmSequenceGeneratorComposite;
import org.eclipse.jpt.ui.internal.orm.details.OrmTableGeneratorComposite;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.NewNameDialog;
import org.eclipse.jpt.ui.internal.widgets.NewNameDialogBuilder;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmGeneratorsComposite
extends AbstractPane<EntityMappings> {
    private WritablePropertyValueModel<OrmGenerator> generatorHolder;
    private OrmSequenceGeneratorComposite sequenceGeneratorPane;
    private OrmTableGeneratorComposite tableGeneratorPane;
    private AddRemoveListPane<EntityMappings> listPane;

    public OrmGeneratorsComposite(AbstractPane<? extends EntityMappings> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private void addSequenceGenerator(ObjectListSelectionModel listSelectionModel) {
        NewNameDialogBuilder builder = new NewNameDialogBuilder(this.shell());
        builder.setDialogTitle(JptUiOrmMessages.OrmGeneratorsComposite_addSequenceGeneratorTitle);
        builder.setDescription(JptUiOrmMessages.OrmGeneratorsComposite_addSequenceGeneratorDescription);
        builder.setDescriptionTitle(JptUiOrmMessages.OrmGeneratorsComposite_addSequenceGeneratorDescriptionTitle);
        builder.setLabelText(JptUiOrmMessages.OrmGeneratorsComposite_label);
        builder.setExistingNames(this.sequenceGeneratorNames());
        NewNameDialog dialog = builder.buildDialog();
        dialog.openDialog(this.buildNewSequenceGeneratorPostExecution(listSelectionModel));
    }

    private void addTableGenerator(ObjectListSelectionModel listSelectionModel) {
        NewNameDialogBuilder builder = new NewNameDialogBuilder(this.shell());
        builder.setDialogTitle(JptUiOrmMessages.OrmGeneratorsComposite_addTableGeneratorTitle);
        builder.setDescription(JptUiOrmMessages.OrmGeneratorsComposite_addTableGeneratorDescription);
        builder.setDescriptionTitle(JptUiOrmMessages.OrmGeneratorsComposite_addTableGeneratorDescriptionTitle);
        builder.setLabelText(JptUiOrmMessages.OrmGeneratorsComposite_label);
        builder.setExistingNames(this.tableGeneratorNames());
        NewNameDialog dialog = builder.buildDialog();
        dialog.openDialog(this.buildNewTableGeneratorPostExecution(listSelectionModel));
    }

    private ListValueModel<OrmGenerator> buildDisplayableGeneratorListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildGeneratorsListHolder(), new String[]{"nameProperty"});
    }

    private PostExecution<NewNameDialog> buildEditGeneratorPostExecution() {
        return new PostExecution<NewNameDialog>(){

            @Override
            public void execute(NewNameDialog dialog) {
                if (dialog.wasConfirmed()) {
                    OrmGenerator generator = (OrmGenerator)OrmGeneratorsComposite.this.generatorHolder.getValue();
                    generator.setName(dialog.getName());
                }
            }
        };
    }

    private AddRemovePane.Adapter buildGeneratorAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public String addButtonText() {
                return JptUiOrmMessages.OrmGeneratorsComposite_addSequenceGenerator;
            }

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                OrmGeneratorsComposite.this.addSequenceGenerator(listSelectionModel);
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiOrmMessages.OrmGeneratorsComposite_edit;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                OrmGeneratorsComposite.this.editGenerator(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof OrmSequenceGenerator) {
                        ((EntityMappings)OrmGeneratorsComposite.this.subject()).removeSequenceGenerator((OrmSequenceGenerator)item);
                    } else {
                        ((EntityMappings)OrmGeneratorsComposite.this.subject()).removeTableGenerator((OrmTableGenerator)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private WritablePropertyValueModel<OrmGenerator> buildGeneratorHolder() {
        return new SimplePropertyValueModel();
    }

    private ILabelProvider buildGeneratorLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                OrmGenerator generator = (OrmGenerator)element;
                String name = generator.getName();
                if (name == null) {
                    int index = -1;
                    index = generator instanceof OrmSequenceGenerator ? CollectionTools.indexOf((Iterator)((EntityMappings)OrmGeneratorsComposite.this.subject()).sequenceGenerators(), (Object)generator) : CollectionTools.indexOf((Iterator)((EntityMappings)OrmGeneratorsComposite.this.subject()).tableGenerators(), (Object)generator);
                    name = NLS.bind((String)JptUiOrmMessages.OrmGeneratorsComposite_displayString, (Object)index);
                }
                return name;
            }
        };
    }

    private ListValueModel<OrmGenerator> buildGeneratorsListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSequenceGeneratorListHolder());
        list.add(this.buildTableGeneratorListHolder());
        return new CompositeListValueModel(list);
    }

    private PostExecution<NewNameDialog> buildNewSequenceGeneratorPostExecution(final ObjectListSelectionModel listSelectionModel) {
        return new PostExecution<NewNameDialog>(){

            @Override
            public void execute(NewNameDialog dialog) {
                if (dialog.wasConfirmed()) {
                    OrmSequenceGenerator generator = ((EntityMappings)OrmGeneratorsComposite.this.subject()).addSequenceGenerator(((EntityMappings)OrmGeneratorsComposite.this.subject()).sequenceGeneratorsSize());
                    generator.setName(dialog.getName());
                    OrmGeneratorsComposite.this.generatorHolder.setValue((Object)generator);
                    listSelectionModel.setSelectedValue((Object)generator);
                }
            }
        };
    }

    private Runnable buildNewTableGeneratorAction(final ObjectListSelectionModel selectionModel) {
        return new Runnable(){

            public void run() {
                OrmGeneratorsComposite.this.addTableGenerator(selectionModel);
            }
        };
    }

    private PostExecution<NewNameDialog> buildNewTableGeneratorPostExecution(final ObjectListSelectionModel listSelectionModel) {
        return new PostExecution<NewNameDialog>(){

            @Override
            public void execute(NewNameDialog dialog) {
                if (dialog.wasConfirmed()) {
                    OrmTableGenerator generator = ((EntityMappings)OrmGeneratorsComposite.this.subject()).addTableGenerator(((EntityMappings)OrmGeneratorsComposite.this.subject()).tableGeneratorsSize());
                    generator.setName(dialog.getName());
                    OrmGeneratorsComposite.this.generatorHolder.setValue((Object)generator);
                    listSelectionModel.setSelectedValue((Object)generator);
                }
            }
        };
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder() {
        return new TransformationPropertyValueModel<EntityMappings, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(EntityMappings value) {
                if (value != null) {
                    return true;
                }
                return false;
            }
        };
    }

    private Transformer<OrmGenerator, Control> buildPaneTransformer() {
        return new Transformer<OrmGenerator, Control>(){

            public Control transform(OrmGenerator generator) {
                if (generator == null) {
                    return null;
                }
                if (generator instanceof OrmSequenceGenerator) {
                    return OrmGeneratorsComposite.this.sequenceGeneratorPane.getControl();
                }
                return OrmGeneratorsComposite.this.tableGeneratorPane.getControl();
            }
        };
    }

    private PropertyValueModel<OrmSequenceGenerator> buildSequenceGeneratorHolder() {
        return new TransformationPropertyValueModel<OrmGenerator, OrmSequenceGenerator>(this.generatorHolder){

            protected OrmSequenceGenerator transform_(OrmGenerator value) {
                return value instanceof OrmSequenceGenerator ? (OrmSequenceGenerator)value : null;
            }
        };
    }

    private ListValueModel<OrmSequenceGenerator> buildSequenceGeneratorListHolder() {
        return new ListAspectAdapter<EntityMappings, OrmSequenceGenerator>(this.getSubjectHolder(), new String[]{"sequenceGeneratorsList"}){

            protected ListIterator<OrmSequenceGenerator> listIterator_() {
                return ((EntityMappings)this.subject).sequenceGenerators();
            }

            protected int size_() {
                return ((EntityMappings)this.subject).sequenceGeneratorsSize();
            }
        };
    }

    private PropertyValueModel<OrmTableGenerator> buildTableGeneratorHolder() {
        return new TransformationPropertyValueModel<OrmGenerator, OrmTableGenerator>(this.generatorHolder){

            protected OrmTableGenerator transform_(OrmGenerator value) {
                return value instanceof OrmTableGenerator ? (OrmTableGenerator)value : null;
            }
        };
    }

    private ListValueModel<OrmTableGenerator> buildTableGeneratorListHolder() {
        return new ListAspectAdapter<EntityMappings, OrmTableGenerator>(this.getSubjectHolder(), new String[]{"tableGeneratorsList"}){

            protected ListIterator<OrmTableGenerator> listIterator_() {
                return ((EntityMappings)this.subject).tableGenerators();
            }

            protected int size_() {
                return ((EntityMappings)this.subject).tableGeneratorsSize();
            }
        };
    }

    private void editGenerator(ObjectListSelectionModel listSelectionModel) {
        OrmGenerator generator = (OrmGenerator)this.generatorHolder.getValue();
        NewNameDialogBuilder builder = new NewNameDialogBuilder(this.shell());
        builder.setLabelText(JptUiOrmMessages.OrmGeneratorsComposite_label);
        builder.setName(generator.getName());
        if (generator instanceof OrmSequenceGenerator) {
            builder.setDialogTitle(JptUiOrmMessages.OrmGeneratorsComposite_editSequenceGeneratorTitle);
            builder.setDescription(JptUiOrmMessages.OrmGeneratorsComposite_editSequenceGeneratorDescription);
            builder.setDescriptionTitle(JptUiOrmMessages.OrmGeneratorsComposite_editSequenceGeneratorDescriptionTitle);
            builder.setExistingNames(this.sequenceGeneratorNames());
        } else {
            builder.setDialogTitle(JptUiOrmMessages.OrmGeneratorsComposite_editTableGeneratorTitle);
            builder.setDescription(JptUiOrmMessages.OrmGeneratorsComposite_editTableGeneratorDescription);
            builder.setDescriptionTitle(JptUiOrmMessages.OrmGeneratorsComposite_editTableGeneratorDescriptionTitle);
            builder.setExistingNames(this.tableGeneratorNames());
        }
        NewNameDialog dialog = builder.buildDialog();
        dialog.openDialog(this.buildEditGeneratorPostExecution());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.generatorHolder = this.buildGeneratorHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        container = this.buildCollapsableSection(container, JptUiOrmMessages.OrmGeneratorsComposite_groupBox);
        this.listPane = this.buildListPane(container);
        this.installPaneEnabler();
        PropertyValueModel<OrmSequenceGenerator> sequenceGeneratorHolder = this.buildSequenceGeneratorHolder();
        PropertyValueModel<OrmTableGenerator> tableGeneratorHolder = this.buildTableGeneratorHolder();
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.sequenceGeneratorPane = new OrmSequenceGeneratorComposite((AbstractPane<?>)this, sequenceGeneratorHolder, (Composite)pageBook);
        this.tableGeneratorPane = new OrmTableGeneratorComposite((AbstractPane<?>)this, tableGeneratorHolder, (Composite)pageBook);
        this.addAlignRight(this.sequenceGeneratorPane);
        this.addAlignRight(this.tableGeneratorPane);
        this.installPaneSwitcher(pageBook);
    }

    private AddRemoveListPane<EntityMappings> buildListPane(Composite container) {
        return new AddRemoveListPane<EntityMappings>((AbstractPane)this, container, this.buildGeneratorAdapter(), this.buildDisplayableGeneratorListHolder(), this.generatorHolder, this.buildGeneratorLabelProvider()){

            @Override
            protected void addCustomButtonAfterAddButton(Composite container, String helpId) {
                Button button = this.buildButton(container, JptUiOrmMessages.OrmGeneratorsComposite_addTableGenerator, helpId, OrmGeneratorsComposite.this.buildNewTableGeneratorAction(this.getSelectionModel()));
                this.addAlignRight((Control)button);
            }
        };
    }

    private void installPaneEnabler() {
        new PaneEnabler(this.buildPaneEnablerHolder(), (AbstractPane<?>)this.listPane);
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.generatorHolder, this.buildPaneTransformer(), pageBook);
    }

    private Iterator<String> sequenceGeneratorNames() {
        return new TransformationIterator<OrmSequenceGenerator, String>((Iterator)((EntityMappings)this.subject()).sequenceGenerators()){

            protected String transform(OrmSequenceGenerator next) {
                return next.getName();
            }
        };
    }

    private Iterator<String> tableGeneratorNames() {
        return new TransformationIterator<OrmTableGenerator, String>((Iterator)((EntityMappings)this.subject()).tableGenerators()){

            protected String transform(OrmTableGenerator next) {
                return next.getName();
            }
        };
    }
}

