/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.validate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.IValidatorGroupListener;
import org.eclipse.wst.validation.ValidationState;

public class ValidatorGroupListener
implements IValidatorGroupListener {
    Map fDiagnosticMap = new HashMap();
    private static final boolean _debug = false;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.fDiagnosticMap != null && !this.fDiagnosticMap.isEmpty()) {
            Object[] paths = this.fDiagnosticMap.keySet().toArray();
            int i = 0;
            while (i < paths.length) {
                Logger.log(4, "Leaked model: " + paths[i]);
                this.validationFinishing((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)paths[i]), (IProgressMonitor)new NullProgressMonitor(), null);
                ++i;
            }
        }
    }

    public void validationFinishing(IResource resource, IProgressMonitor monitor, ValidationState state) {
        if (resource.getType() != 1) {
            return;
        }
        IStructuredModel model = (IStructuredModel)this.fDiagnosticMap.remove(resource.getFullPath());
        if (model != null) {
            model.releaseFromRead();
        }
    }

    public void validationStarting(IResource resource, IProgressMonitor monitor, ValidationState state) {
        try {
            if (monitor != null && !monitor.isCanceled()) {
                if (resource.getType() != 1) {
                    return;
                }
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead((IFile)resource);
                if (model != null) {
                    this.fDiagnosticMap.put(resource.getFullPath(), model);
                }
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }
}

