/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;

class ConstantChecks {
    ConstantChecks() {
    }

    public static boolean isStaticFinalConstant(IExpressionFragment ex) {
        return new StaticFinalConstantChecker(ex).check();
    }

    public static boolean isLoadTimeConstant(IExpressionFragment ex) {
        return new LoadTimeConstantChecker(ex).check();
    }

    private static abstract class ExpressionChecker
    extends ASTVisitor {
        private final IExpressionFragment fExpression;
        protected boolean fResult = true;

        public ExpressionChecker(IExpressionFragment ex) {
            this.fExpression = ex;
        }

        public boolean check() {
            this.fResult = true;
            this.fExpression.getAssociatedNode().accept((ASTVisitor)this);
            return this.fResult;
        }
    }

    private static class LoadTimeConstantChecker
    extends ExpressionChecker {
        public LoadTimeConstantChecker(IExpressionFragment ex) {
            super(ex);
        }

        public boolean visit(SuperFieldAccess node) {
            this.fResult = false;
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            this.fResult = false;
            return false;
        }

        public boolean visit(ThisExpression node) {
            this.fResult = false;
            return false;
        }

        public boolean visit(FieldAccess node) {
            this.fResult = new LoadTimeConstantChecker((IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)node.getExpression())).check();
            return false;
        }

        public boolean visit(FunctionInvocation node) {
            if (node.getExpression() == null) {
                this.visitName((Name)node.getName());
            } else {
                this.fResult = new LoadTimeConstantChecker((IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)node.getExpression())).check();
            }
            return false;
        }

        public boolean visit(QualifiedName node) {
            return this.visitName((Name)node);
        }

        public boolean visit(SimpleName node) {
            return this.visitName((Name)node);
        }

        private boolean visitName(Name name) {
            this.fResult = this.checkName(name);
            return false;
        }

        private boolean checkName(Name name) {
            IBinding binding = name.resolveBinding();
            if (binding == null) {
                return true;
            }
            if (binding instanceof IVariableBinding || binding instanceof IFunctionBinding) {
                return this.isMemberReferenceValidInClassInitialization(name);
            }
            if (binding instanceof ITypeBinding) {
                return !((ITypeBinding)binding).isTypeVariable();
            }
            Assert.isTrue((boolean)false);
            return true;
        }

        private boolean isMemberReferenceValidInClassInitialization(Name name) {
            IBinding binding = name.resolveBinding();
            Assert.isTrue((binding instanceof IVariableBinding || binding instanceof IFunctionBinding ? 1 : 0) != 0);
            if (name instanceof SimpleName) {
                return Modifier.isStatic((int)binding.getModifiers());
            }
            Assert.isTrue((boolean)(name instanceof QualifiedName));
            return this.checkName(((QualifiedName)name).getQualifier());
        }
    }

    private static class StaticFinalConstantChecker
    extends ExpressionChecker {
        public StaticFinalConstantChecker(IExpressionFragment ex) {
            super(ex);
        }

        public boolean visit(SuperFieldAccess node) {
            this.fResult = false;
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            this.fResult = false;
            return false;
        }

        public boolean visit(ThisExpression node) {
            this.fResult = false;
            return false;
        }

        public boolean visit(QualifiedName node) {
            return this.visitName((Name)node);
        }

        public boolean visit(SimpleName node) {
            return this.visitName((Name)node);
        }

        private boolean visitName(Name name) {
            IBinding binding = name.resolveBinding();
            if (binding == null) {
                return true;
            }
            int modifiers = binding.getModifiers();
            if (binding instanceof IVariableBinding) {
                if (!Modifier.isStatic((int)modifiers) || !Modifier.isFinal((int)modifiers)) {
                    this.fResult = false;
                    return false;
                }
            } else if (binding instanceof IFunctionBinding) {
                if (!Modifier.isStatic((int)modifiers)) {
                    this.fResult = false;
                    return false;
                }
            } else {
                if (binding instanceof ITypeBinding) {
                    return false;
                }
                Assert.isTrue((boolean)false);
                return false;
            }
            return true;
        }
    }
}

