/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class JSPValidator
extends AbstractValidator
implements IValidatorJob {
    private static final String PLUGIN_ID_JSP_CORE = "org.eclipse.jst.jsp.core";
    private IContentType fJSPFContentType = null;
    static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        block11: {
            JSPFileVisitor visitor;
            block9: {
                block10: {
                    String[] uris = helper.getURIs();
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    if (uris.length <= 0) break block10;
                    IFile currentFile = null;
                    int i = 0;
                    while (i < uris.length && !reporter.isCancelled()) {
                        currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                        if (currentFile != null && currentFile.exists()) {
                            if (this.shouldValidate(currentFile) && this.fragmentCheck(currentFile)) {
                                LocalizedMessage message = new LocalizedMessage(4, uris[i]);
                                reporter.displaySubtask((IValidator)this, (IMessage)message);
                                this.validateFile(currentFile, reporter);
                            }
                            if (DEBUG) {
                                System.out.println("validating: [" + uris[i] + "]");
                            }
                        }
                        ++i;
                    }
                    break block11;
                }
                if (!(helper instanceof IWorkbenchContext)) break block11;
                IProject project = ((IWorkbenchContext)helper).getProject();
                visitor = new JSPFileVisitor(reporter);
                try {
                    project.accept((IResourceProxyVisitor)visitor, 2);
                }
                catch (CoreException e) {
                    if (!DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            IFile[] files = visitor.getFiles();
            int i = 0;
            while (i < files.length && !reporter.isCancelled()) {
                if (this.shouldValidate(files[i]) && this.fragmentCheck(files[i])) {
                    int percent = i * 100 / files.length + 1;
                    LocalizedMessage message = new LocalizedMessage(4, String.valueOf(percent) + "% " + files[i].getFullPath().toString());
                    reporter.displaySubtask((IValidator)this, (IMessage)message);
                    this.validateFile(files[i], reporter);
                }
                if (DEBUG) {
                    System.out.println("validating: [" + files[i] + "]");
                }
                ++i;
            }
        }
    }

    protected void validateFile(IFile f, IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        this.validateFile((IFile)resource, reporter);
        return result;
    }

    protected String getDirectiveName(IStructuredDocumentRegion sdr) {
        String name = "";
        ITextRegionList subRegions = sdr.getRegions();
        int j = 0;
        while (j < subRegions.size()) {
            ITextRegion subRegion = subRegions.get(j);
            if (subRegion.getType() == "JSP_DIRECTIVE_NAME") {
                name = sdr.getText(subRegion);
                break;
            }
            ++j;
        }
        return name;
    }

    protected ITextRegion getAttributeValueRegion(IStructuredDocumentRegion sdr, String attrName) {
        ITextRegion valueRegion = null;
        ITextRegionList subRegions = sdr.getRegions();
        int i = 0;
        block0: while (i < subRegions.size()) {
            ITextRegion subRegion = subRegions.get(i);
            if (subRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" && sdr.getText(subRegion).equals(attrName)) {
                int j = i;
                while (j < subRegions.size()) {
                    subRegion = subRegions.get(j);
                    if (subRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        valueRegion = subRegion;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return valueRegion;
    }

    protected String getAttributeValue(IStructuredDocumentRegion sdr, String attrName) {
        ITextRegion r = this.getAttributeValueRegion(sdr, attrName);
        if (r != null) {
            return sdr.getText(r).trim();
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    private boolean isFragment(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 127->130)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    private boolean fragmentCheck(IFile file) {
        boolean shouldValidateFragments;
        boolean shouldValidate = true;
        if (this.getJSPFContentType().isAssociatedWith(file.getName()) && !(shouldValidateFragments = Boolean.valueOf(JSPFContentProperties.getProperty("validateFragments", (IResource)file, true)).booleanValue())) {
            boolean isFragment = this.isFragment(file);
            shouldValidate = !isFragment;
        }
        return shouldValidate;
    }

    private IContentType getJSPFContentType() {
        if (this.fJSPFContentType == null) {
            this.fJSPFContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
        }
        return this.fJSPFContentType;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        IStatus status = Status.OK_STATUS;
        try {
            this.validate(helper, reporter);
        }
        catch (ValidationException e) {
            Logger.logException(e);
            status = new Status(4, PLUGIN_ID_JSP_CORE, 4, e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }

    protected class JSPFileVisitor
    implements IResourceProxyVisitor {
        private List fFiles = new ArrayList();
        private IContentType[] fContentTypes = null;
        private IReporter fReporter = null;

        public JSPFileVisitor(IReporter reporter) {
            this.fReporter = reporter;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IFile file;
            if (this.fReporter.isCancelled()) {
                return false;
            }
            if (proxy.getType() == 1 && this.isJSPType(proxy.getName()) && (file = (IFile)proxy.requestResource()).exists()) {
                if (DEBUG) {
                    System.out.println("(+) JSPValidator adding file: " + file.getName());
                }
                this.fFiles.add(file);
                return false;
            }
            return true;
        }

        public final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }

        private IContentType[] getValidContentTypes() {
            if (this.fContentTypes == null) {
                this.fContentTypes = new IContentType[]{Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP), Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT)};
            }
            return this.fContentTypes;
        }

        private boolean isJSPType(String fileName) {
            boolean valid = false;
            IContentType[] types = this.getValidContentTypes();
            int i = 0;
            while (i < types.length && !valid) {
                valid = types[i].isAssociatedWith(fileName);
                ++i;
            }
            return valid;
        }
    }

    protected class LocalizedMessage
    extends Message {
        private String _message = null;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }
    }
}

