/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.cleanup;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.cleanup.StructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.cleanup.ElementNodeCleanupHandler;
import org.eclipse.wst.xml.core.internal.cleanup.NodeCleanupHandler;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormatterFormatProcessor;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.w3c.dom.Node;

public class CleanupProcessorXML
extends AbstractStructuredCleanupProcessor {
    protected IStructuredCleanupPreferences fCleanupPreferences = null;

    protected IStructuredCleanupHandler getCleanupHandler(Node node) {
        short nodeType = node.getNodeType();
        NodeCleanupHandler cleanupHandler = null;
        switch (nodeType) {
            case 1: {
                cleanupHandler = new ElementNodeCleanupHandler();
                break;
            }
            case 3: {
                cleanupHandler = new NodeCleanupHandler();
                break;
            }
            default: {
                cleanupHandler = new NodeCleanupHandler();
            }
        }
        cleanupHandler.setCleanupPreferences(this.getCleanupPreferences());
        return cleanupHandler;
    }

    public IStructuredCleanupPreferences getCleanupPreferences() {
        if (this.fCleanupPreferences == null) {
            this.fCleanupPreferences = new StructuredCleanupPreferences();
            Preferences preferences = this.getModelPreferences();
            if (preferences != null) {
                this.fCleanupPreferences.setCompressEmptyElementTags(preferences.getBoolean("compressEmptyElementTags"));
                this.fCleanupPreferences.setInsertRequiredAttrs(preferences.getBoolean("insertRequiredAttrs"));
                this.fCleanupPreferences.setInsertMissingTags(preferences.getBoolean("insertMissingTags"));
                this.fCleanupPreferences.setQuoteAttrValues(preferences.getBoolean("quoteAttrValues"));
                this.fCleanupPreferences.setFormatSource(preferences.getBoolean("formatSource"));
                this.fCleanupPreferences.setConvertEOLCodes(preferences.getBoolean("convertEOLCodes"));
                this.fCleanupPreferences.setEOLCode(preferences.getString("cleanupEOLCode"));
            }
        }
        return this.fCleanupPreferences;
    }

    protected String getContentType() {
        return ContentTypeIdForXML.ContentTypeID_XML;
    }

    protected IStructuredFormatProcessor getFormatProcessor() {
        return new XMLFormatterFormatProcessor();
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void refreshCleanupPreferences() {
        this.fCleanupPreferences = null;
    }
}

