/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PublishHelper {
    private static final int BUFFER = 65536;
    private static byte[] buf = new byte[65536];
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private static final File defaultTempDir = ServerPlugin.getInstance().getStateLocation().toFile();
    private static final String TEMPFILE_PREFIX = "tmp";
    private File tempDir;

    public PublishHelper(File tempDirectory) {
        this.tempDir = tempDirectory;
        if (this.tempDir == null) {
            this.tempDir = defaultTempDir;
        } else if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
    }

    private void copyFile(InputStream in, IPath to, long ts, IModuleFile mf) throws CoreException {
        OutputStream out = null;
        File tempFile = null;
        try {
            try {
                File file = to.toFile();
                tempFile = File.createTempFile(TEMPFILE_PREFIX, "." + to.getFileExtension(), this.tempDir);
                out = new FileOutputStream(tempFile);
                int avail = in.read(buf);
                while (avail > 0) {
                    out.write(buf, 0, avail);
                    avail = in.read(buf);
                }
                out.close();
                out = null;
                this.moveTempFile(tempFile, file);
                if (ts != -1L && ts != 0L) {
                    file.setLastModified(ts);
                }
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                IPath path = mf.getModuleRelativePath().append(mf.getName());
                Trace.trace(3, "Error copying file: " + path.toOSString() + " to " + to.toOSString(), e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object)path.toOSString(), (Object)e.getLocalizedMessage()), null));
            }
        }
        catch (Throwable throwable) {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        if (tempFile != null && tempFile.exists()) {
            tempFile.deleteOnExit();
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception exception) {}
    }

    public static IStatus[] deleteDirectory(File dir, IProgressMonitor monitor) {
        if (!dir.exists() || !dir.isDirectory()) {
            return new IStatus[]{new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorNotADirectory, (Object)dir.getAbsolutePath()), null)};
        }
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        try {
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            boolean deleteCurrent = true;
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    if (!current.delete()) {
                        status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)files[i].getAbsolutePath()), null));
                        deleteCurrent = false;
                    }
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    IStatus[] stat = PublishHelper.deleteDirectory(current, ProgressUtil.getSubMonitorFor(monitor, 10));
                    if (stat != null && stat.length > 0) {
                        deleteCurrent = false;
                        PublishHelper.addArrayToList(status, stat);
                    }
                }
                ++i;
            }
            if (deleteCurrent && !dir.delete()) {
                status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)dir.getAbsolutePath()), null));
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(3, "Error deleting directory " + dir.getAbsolutePath(), e);
            status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, e.getLocalizedMessage(), null));
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishSmart(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        return this.publishSmart(resources, path, null, monitor);
    }

    public IStatus[] publishSmart(IModuleResource[] resources, IPath path, IPath[] ignore, IProgressMonitor monitor) {
        int toSize;
        if (resources == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        File toDir = path.toFile();
        int fromSize = resources.length;
        String[] fromFileNames = new String[fromSize];
        int i = 0;
        while (i < fromSize) {
            fromFileNames[i] = resources[i].getName();
            ++i;
        }
        ArrayList<String> ignoreFileNames = new ArrayList<String>();
        if (ignore != null) {
            int i2 = 0;
            while (i2 < ignore.length) {
                if (ignore[i2].segmentCount() == 1) {
                    ignoreFileNames.add(ignore[i2].toOSString());
                }
                ++i2;
            }
        }
        File[] toFiles = null;
        String[] toFileNames = null;
        boolean foundExistingDir = false;
        if (toDir.exists()) {
            if (toDir.isDirectory()) {
                foundExistingDir = true;
                toFiles = toDir.listFiles();
                toSize = toFiles.length;
                toFileNames = new String[toSize];
                int i3 = 0;
                while (i3 < toSize) {
                    toFileNames[i3] = toFiles[i3].getName();
                    boolean isDir = toFiles[i3].isDirectory();
                    boolean found = false;
                    int j = 0;
                    while (j < fromSize) {
                        if (toFileNames[i3].equals(fromFileNames[j]) && isDir == resources[j] instanceof IModuleFolder) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        boolean delete = true;
                        for (String preserveFileName : ignoreFileNames) {
                            if (!toFileNames[i3].equals(preserveFileName)) continue;
                            delete = false;
                            break;
                        }
                        if (delete) {
                            if (isDir) {
                                IStatus[] stat = PublishHelper.deleteDirectory(toFiles[i3], null);
                                PublishHelper.addArrayToList(status, stat);
                            } else if (!toFiles[i3].delete()) {
                                status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)toFiles[i3].getAbsolutePath()), null));
                            }
                        }
                        toFiles[i3] = null;
                        toFileNames[i3] = null;
                    }
                    ++i3;
                }
            } else if (!toDir.delete()) {
                status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)toDir.getAbsolutePath()), null));
                IStatus[] stat = new IStatus[status.size()];
                status.toArray(stat);
                return stat;
            }
        }
        if (!foundExistingDir && !toDir.mkdirs()) {
            status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorMkdir, (Object)toDir.getAbsolutePath()), null));
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        if (monitor.isCanceled()) {
            return new IStatus[]{Status.CANCEL_STATUS};
        }
        monitor.worked(50);
        if (toFiles == null && (toFiles = toDir.listFiles()) == null) {
            toFiles = new File[]{};
        }
        toSize = toFiles.length;
        int dw = 0;
        if (toSize > 0) {
            dw = 500 / toSize;
        }
        if (toFileNames == null) {
            toFileNames = new String[toSize];
        }
        long[] toFileMod = new long[toSize];
        int i4 = 0;
        while (i4 < toSize) {
            if (toFiles[i4] != null) {
                if (toFileNames[i4] != null) {
                    toFileNames[i4] = toFiles[i4].getName();
                }
                toFileMod[i4] = toFiles[i4].lastModified();
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < fromSize) {
            IModuleResource current = resources[i4];
            String name = fromFileNames[i4];
            boolean currentIsDir = current instanceof IModuleFolder;
            if (!currentIsDir) {
                boolean copy = true;
                IModuleFile mf = (IModuleFile)current;
                long mod = -1L;
                IFile file = (IFile)mf.getAdapter(IFile.class);
                if (file != null) {
                    mod = file.getLocalTimeStamp();
                } else {
                    File file2 = (File)mf.getAdapter(File.class);
                    mod = file2.lastModified();
                }
                int j = 0;
                while (j < toSize) {
                    if (name.equals(toFileNames[j]) && mod == toFileMod[j]) {
                        copy = false;
                        break;
                    }
                    ++j;
                }
                if (copy) {
                    try {
                        this.copyFile(mf, path.append(name));
                    }
                    catch (CoreException ce) {
                        status.add(ce.getStatus());
                    }
                }
                monitor.worked(dw);
            } else {
                IModuleFolder folder = (IModuleFolder)current;
                IModuleResource[] children = folder.members();
                IPath[] ignoreChildren = null;
                if (ignore != null) {
                    ArrayList<IPath> ignoreChildPaths = new ArrayList<IPath>();
                    int j = 0;
                    while (j < ignore.length) {
                        IPath preservePath = ignore[j];
                        if (preservePath.segment(0).equals(name)) {
                            ignoreChildPaths.add(preservePath.removeFirstSegments(1));
                        }
                        ++j;
                    }
                    if (ignoreChildPaths.size() > 0) {
                        ignoreChildren = (IPath[])ignoreChildPaths.toArray(new Path[ignoreChildPaths.size()]);
                    }
                }
                monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{name, name}));
                IStatus[] stat = this.publishSmart(children, path.append(name), ignoreChildren, ProgressUtil.getSubMonitorFor(monitor, dw));
                PublishHelper.addArrayToList(status, stat);
            }
            ++i4;
        }
        if (monitor.isCanceled()) {
            return new IStatus[]{Status.CANCEL_STATUS};
        }
        monitor.worked(500 - dw * toSize);
        monitor.done();
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishDelta(IModuleResourceDelta[] delta, IPath path, IProgressMonitor monitor) {
        if (delta == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        int size2 = delta.length;
        int i = 0;
        while (i < size2) {
            IStatus[] stat = this.publishDelta(delta[i], path, monitor);
            PublishHelper.addArrayToList(status, stat);
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishDelta(IModuleResourceDelta delta, IPath path, IProgressMonitor monitor) {
        IPath path2;
        File file;
        IPath path22;
        File file2;
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        IModuleResource resource = delta.getModuleResource();
        int kind2 = delta.getKind();
        if (resource instanceof IModuleFile) {
            IModuleFile file3 = (IModuleFile)resource;
            try {
                if (kind2 == 3) {
                    PublishHelper.deleteFile(path, file3);
                } else {
                    IPath path23 = path.append(file3.getModuleRelativePath()).append(file3.getName());
                    File f = path23.toFile().getParentFile();
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    this.copyFile(file3, path23);
                }
            }
            catch (CoreException ce) {
                status.add(ce.getStatus());
            }
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        if (kind2 == 1 && !(file2 = (path22 = path.append(resource.getModuleRelativePath()).append(resource.getName())).toFile()).exists() && !file2.mkdirs()) {
            status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorMkdir, (Object)path22), null));
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        IModuleResourceDelta[] childDeltas = delta.getAffectedChildren();
        int size = childDeltas.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = this.publishDelta(childDeltas[i], path, monitor);
            PublishHelper.addArrayToList(status, stat);
            ++i;
        }
        if (kind2 == 3 && (file = (path2 = path.append(resource.getModuleRelativePath()).append(resource.getName())).toFile()).exists() && !file.delete()) {
            status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)path2), null));
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    private static void deleteFile(IPath path, IModuleFile file) throws CoreException {
        Trace.trace(11, "Deleting: " + file.getName() + " from " + path.toString());
        IPath path2 = path.append(file.getModuleRelativePath()).append(file.getName());
        if (path2.toFile().exists() && !path2.toFile().delete()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)path2), null));
        }
    }

    private void copyFile(IModuleFile mf, IPath path) throws CoreException {
        Trace.trace(11, "Copying: " + mf.getName() + " to " + path.toString());
        IFile file = (IFile)mf.getAdapter(IFile.class);
        if (file != null) {
            this.copyFile(file.getContents(), path, file.getLocalTimeStamp(), mf);
        } else {
            File file2 = (File)mf.getAdapter(File.class);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file2);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorReading, (Object)file2.getAbsolutePath()), (Throwable)e));
            }
            this.copyFile(in, path, file2.lastModified(), mf);
        }
    }

    public IStatus[] publishFull(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        if (resources == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        int size = resources.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = this.copy(resources[i], path, monitor);
            PublishHelper.addArrayToList(status, stat);
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    private IStatus[] copy(IModuleResource resource, IPath path, IProgressMonitor monitor) {
        String name = resource.getName();
        Trace.trace(11, "Copying: " + name + " to " + path.toString());
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (resource instanceof IModuleFolder) {
            IModuleFolder folder = (IModuleFolder)resource;
            IStatus[] stat = this.publishFull(folder.members(), path, monitor);
            PublishHelper.addArrayToList(status, stat);
        } else {
            IModuleFile mf = (IModuleFile)resource;
            File f = (path = path.append(mf.getModuleRelativePath()).append(name)).toFile().getParentFile();
            if (!f.exists()) {
                f.mkdirs();
            }
            try {
                this.copyFile(mf, path);
            }
            catch (CoreException ce) {
                status.add(ce.getStatus());
            }
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishZip(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        if (resources == null || resources.length == 0) {
            File file = path.toFile();
            if (file.exists()) {
                file.delete();
            }
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        File tempFile = null;
        try {
            try {
                File file = path.toFile();
                tempFile = File.createTempFile(TEMPFILE_PREFIX, "." + path.getFileExtension(), this.tempDir);
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(tempFile));
                ZipOutputStream zout = new ZipOutputStream(bout);
                PublishHelper.addZipEntries(zout, resources);
                zout.close();
                this.moveTempFile(tempFile, file);
            }
            catch (CoreException e) {
                IStatus[] iStatusArray = new IStatus[]{e.getStatus()};
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                return iStatusArray;
            }
            catch (Exception e) {
                Trace.trace(3, "Error zipping", e);
                Status[] statusArray = new Status[]{new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCreatingZipFile, (Object)path.lastSegment(), (Object)e.getLocalizedMessage()), (Throwable)e)};
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                return statusArray;
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
        }
        return EMPTY_STATUS;
    }

    private static void addZipEntries(ZipOutputStream zout, IModuleResource[] resources) throws Exception {
        if (resources == null) {
            return;
        }
        int size = resources.length;
        int i = 0;
        while (i < size) {
            IModuleResource mf;
            if (resources[i] instanceof IModuleFolder) {
                mf = (IModuleFolder)resources[i];
                IModuleResource[] res = mf.members();
                IPath path = mf.getModuleRelativePath().append(mf.getName());
                String entryPath = path.toPortableString();
                if (!entryPath.endsWith("/")) {
                    entryPath = String.valueOf(entryPath) + '/';
                }
                ZipEntry ze = new ZipEntry(entryPath);
                long ts = 0L;
                IContainer folder = (IContainer)mf.getAdapter(IContainer.class);
                if (folder != null) {
                    ts = folder.getLocalTimeStamp();
                }
                if (ts != -1L && ts != 0L) {
                    ze.setTime(ts);
                }
                zout.putNextEntry(ze);
                zout.closeEntry();
                PublishHelper.addZipEntries(zout, res);
            } else {
                mf = (IModuleFile)resources[i];
                IPath path = mf.getModuleRelativePath().append(mf.getName());
                ZipEntry ze = new ZipEntry(path.toPortableString());
                InputStream in = null;
                long ts = 0L;
                IFile file = (IFile)mf.getAdapter(IFile.class);
                if (file != null) {
                    ts = file.getLocalTimeStamp();
                    in = file.getContents();
                } else {
                    File file2 = (File)mf.getAdapter(File.class);
                    ts = file2.lastModified();
                    in = new FileInputStream(file2);
                }
                if (ts != -1L && ts != 0L) {
                    ze.setTime(ts);
                }
                zout.putNextEntry(ze);
                try {
                    int n = 0;
                    while (n > -1) {
                        n = in.read(buf);
                        if (n <= 0) continue;
                        zout.write(buf, 0, n);
                    }
                }
                finally {
                    in.close();
                }
                zout.closeEntry();
            }
            ++i;
        }
    }

    private void moveTempFile(File tempFile, File file) throws CoreException {
        if (file.exists() && !PublishHelper.safeDelete(file, 2)) {
            try {
                FileInputStream in = new FileInputStream(tempFile);
                IStatus status = this.copyFile(in, file.getPath());
                if (!status.isOK()) {
                    MultiStatus status2 = new MultiStatus("org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)file.toString()), null);
                    status2.add(status);
                    throw new CoreException((IStatus)status2);
                }
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                tempFile.delete();
            }
        }
        if (!PublishHelper.safeRename(tempFile, file, 10)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorRename, (Object)tempFile.toString()), null));
        }
    }

    /*
     * Loose catch block
     */
    private IStatus copyFile(InputStream in, String to) {
        FileOutputStream out = null;
        out = new FileOutputStream(to);
        int avail = in.read(buf);
        while (avail > 0) {
            ((OutputStream)out).write(buf, 0, avail);
            avail = in.read(buf);
        }
        IStatus iStatus = Status.OK_STATUS;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        catch (Exception exception) {}
        return iStatus;
        catch (Exception e) {
            Status status;
            try {
                Trace.trace(3, "Error copying file", e);
                status = new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception exception) {}
            return status;
        }
    }

    private static boolean safeDelete(File f, int retrys) {
        int count = 0;
        while (count < retrys) {
            if (!f.exists()) {
                return true;
            }
            f.delete();
            if (!f.exists()) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static boolean safeRename(File from, File to, int retrys) {
        File dir = to.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        int count = 0;
        while (count < retrys) {
            if (from.renameTo(to)) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static void addArrayToList(List<IStatus> list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

