/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.util;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SoapElementSaxHandler
extends DefaultHandler {
    private HashMap prefixURIMapping = new HashMap();
    private ArrayList uris = new ArrayList();
    private SOAPElement rootElement = null;
    private SOAPElement currentElement = null;
    private SOAPFactory soapFactory;

    public SOAPElement getSOAPElement() {
        return this.rootElement;
    }

    public void startDocument() throws SAXException {
        try {
            this.soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new SAXException("Can't create a SOAPFactory instance", (Exception)((Object)e));
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixURIMapping.put(uri, prefix);
        this.uris.add(uri);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String str = String.valueOf(ch);
        if (length > 0) {
            try {
                this.currentElement.addTextNode(str.substring(start, start + length));
            }
            catch (SOAPException e) {
                throw new SAXException("Can't add a text node into SOAPElement from text", (Exception)((Object)e));
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (this.currentElement != this.rootElement) {
            this.currentElement = this.currentElement.getParentElement();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String prefix = (String)this.prefixURIMapping.get(namespaceURI);
        try {
            int i;
            this.currentElement = this.rootElement == null && this.currentElement == null ? (this.rootElement = this.soapFactory.createElement(localName, prefix, namespaceURI)) : this.currentElement.addChildElement(localName, prefix, namespaceURI);
            if (this.uris.size() > 0) {
                i = 0;
                while (i < this.uris.size()) {
                    String uri = (String)this.uris.get(i);
                    String pre = (String)this.prefixURIMapping.get(uri);
                    this.currentElement.addNamespaceDeclaration(pre, uri);
                    ++i;
                }
                this.uris.clear();
            }
            i = 0;
            while (i < atts.getLength()) {
                Name attriName;
                if (atts.getURI(i) != null) {
                    String attriPre = (String)this.prefixURIMapping.get(atts.getURI(i));
                    attriName = this.soapFactory.createName(atts.getLocalName(i), attriPre, atts.getURI(i));
                } else {
                    attriName = this.soapFactory.createName(atts.getLocalName(i));
                }
                this.currentElement.addAttribute(attriName, atts.getValue(i));
                ++i;
            }
        }
        catch (SOAPException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }
}

