/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSFUtils {
    public static final String JSF_DEFAULT_SERVLET_NAME = "Faces Servlet";
    public static final String JSF_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
    public static final String JSF_CONFIG_CONTEXT_PARAM = "javax.faces.CONFIG_FILES";
    public static final String JSF_DEFAULT_SUFFIX_CONTEXT_PARAM = "javax.faces.DEFAULT_SUFFIX";
    public static final String JSF_DEFAULT_CONFIG_PATH = "/WEB-INF/faces-config.xml";
    public static final String JSF_DEFAULT_URL_MAPPING = "/faces/*";
    public static final String PP_JSF_IMPLEMENTATION_LIBRARIES = "jsf.implementation.libraries";
    public static final String PP_JSF_COMPONENT_LIBRARIES = "jsf.component.libraries";
    public static final String PP_JSF_IMPLEMENTATION_TYPE = "jsf.implementation.type";

    public static IPath[] getJARPathforJSFLibwFilterMissingJars(JSFLibrary jsfLib, boolean logMissingJar) {
        EList archiveFiles = jsfLib.getArchiveFiles();
        int numJars = JSFUtils.numberofValidJar(archiveFiles);
        IPath[] elements = new IPath[numJars];
        ArchiveFile ar = null;
        int idxValidJar = 0;
        int i = 0;
        while (i < archiveFiles.size()) {
            ar = (ArchiveFile)archiveFiles.get(i);
            if (!ar.exists()) {
                if (logMissingJar) {
                    JSFUtils.logErroronMissingJAR(jsfLib, ar);
                }
            } else {
                elements[idxValidJar] = new Path(((ArchiveFile)archiveFiles.get(i)).getResolvedSourceLocation()).makeAbsolute();
                ++idxValidJar;
            }
            ++i;
        }
        return elements;
    }

    public static IPath[] getJARPathforJSFLib(JSFLibrary jsfLib, boolean logMissingJar) {
        EList archiveFiles = jsfLib.getArchiveFiles();
        int numJars = archiveFiles.size();
        IPath[] elements = new IPath[numJars];
        ArchiveFile ar = null;
        int i = 0;
        while (i < numJars) {
            ar = (ArchiveFile)archiveFiles.get(i);
            if (!ar.exists() && logMissingJar) {
                JSFUtils.logErroronMissingJAR(jsfLib, ar);
            }
            elements[i] = new Path(((ArchiveFile)archiveFiles.get(i)).getResolvedSourceLocation()).makeAbsolute();
            ++i;
        }
        return elements;
    }

    private static int numberofValidJar(EList archiveFiles) {
        int total = 0;
        Iterator it = archiveFiles.iterator();
        ArchiveFile ar = null;
        while (it.hasNext()) {
            ar = (ArchiveFile)it.next();
            if (!ar.exists()) continue;
            ++total;
        }
        return total;
    }

    private static void logErroronMissingJAR(JSFLibrary jsfLib, ArchiveFile ar) {
        String msg = NLS.bind((String)Messages.JSFUtils_MissingJAR, (Object)ar.getName(), (Object)jsfLib.getLabel());
        JSFCorePlugin.log(4, msg);
    }

    protected static String getDisplayName(IDataModel config) {
        String displayName = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        if (displayName == null || displayName.trim().equals("")) {
            displayName = JSF_DEFAULT_SERVLET_NAME;
        }
        return displayName.trim();
    }

    protected static String getServletClassname(IDataModel config) {
        String className = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        if (className == null || className.trim().equals("")) {
            className = JSF_SERVLET_CLASS;
        }
        return className.trim();
    }

    public static boolean isPrefixMapping(String mapping) {
        if (mapping == null || mapping.length() < 4) {
            return false;
        }
        return mapping.charAt(0) == '/' && mapping.endsWith("/*");
    }

    public static boolean isExtensionMapping(String mapping) {
        if (mapping == null) {
            return false;
        }
        return mapping.startsWith("*.");
    }

    public static IModelProvider getModelProvider(IProject webProject) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)webProject);
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return null;
        }
        return provider;
    }

    public static MappingSearchResult searchServletMappings(List<String> mappings, String prefExtMapping, String prefPrefixMapping) {
        String firstExtFound = null;
        String firstPrefixFound = null;
        boolean foundExtMapping = false;
        boolean foundPrefixMapping = false;
        if (prefExtMapping == null) {
            prefExtMapping = "NOTANEXTENSIONMAPPING";
        }
        if (prefPrefixMapping == null) {
            prefPrefixMapping = "NOTAPREFIXMAPPING";
        }
        for (String mapping : mappings) {
            if (JSFUtils.isExtensionMapping(mapping)) {
                if (prefExtMapping.equals(mapping.trim())) {
                    firstExtFound = prefExtMapping;
                    continue;
                }
                if (firstExtFound == null) {
                    firstExtFound = mapping.trim();
                }
            } else if (JSFUtils.isPrefixMapping(mapping)) {
                if (prefPrefixMapping.equals(mapping.trim())) {
                    firstPrefixFound = prefPrefixMapping;
                    continue;
                }
                if (firstPrefixFound == null) {
                    firstPrefixFound = mapping.trim();
                }
            }
            if (foundExtMapping && foundPrefixMapping) break;
        }
        return new MappingSearchResult(firstExtFound, firstPrefixFound);
    }

    public static class MappingSearchResult {
        private final String _extensionMapping;
        private final String _prefixMapping;

        MappingSearchResult(String extensionMapping, String prefixMapping) {
            this._extensionMapping = extensionMapping;
            this._prefixMapping = prefixMapping;
        }

        public boolean isResult() {
            return this._extensionMapping != null || this._prefixMapping != null;
        }

        public final String getExtensionMapping() {
            return this._extensionMapping;
        }

        public final String getPrefixMapping() {
            return this._prefixMapping;
        }
    }
}

