/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.ConnectorComponentNestedJARArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorComponentArchiveLoadAdapter
extends ComponentArchiveLoadAdapter {
    private int dotJavaLength = ".java".length();
    private List alreadyIndexed = new ArrayList();
    private Map classesMap;
    private IFile knownDD;
    public static String[] knownLibExtensions = new String[]{".jar", ".zip", ".so", ".o", ".sl", ".dll"};

    public ConnectorComponentArchiveLoadAdapter(IVirtualComponent vComponent) {
        this(vComponent, true);
    }

    public ConnectorComponentArchiveLoadAdapter(IVirtualComponent vComponent, boolean includeClasspathComponents) {
        super(vComponent, includeClasspathComponents);
        this.knownDD = vComponent.getRootFolder().getFile("META-INF/ra.xml").getUnderlyingFile();
    }

    @Override
    public List<IArchiveResource> getArchiveResources() {
        this.addNestedJARsFromSourceRoots();
        this.aggregateSourceFiles();
        return this.filesHolder.getFiles();
    }

    private void addNestedJARsFromSourceRoots() {
        IPackageFragmentRoot[] sourceRoots = J2EEProjectUtilities.getSourceContainers(this.vComponent.getProject());
        int i = 0;
        while (i < sourceRoots.length) {
            try {
                IArchiveResource aFile = this.getNestedJar(sourceRoots[i]);
                if (aFile != null) {
                    this.filesHolder.addFile(aFile);
                }
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (ArchiveOpenFailureException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            ++i;
        }
    }

    private IArchiveResource getNestedJar(IPackageFragmentRoot sourceRoot) throws JavaModelException, ArchiveOpenFailureException {
        IPath outputPath = sourceRoot.getRawClasspathEntry().getOutputLocation();
        if (outputPath == null) {
            IProject project = this.vComponent.getProject();
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    outputPath = javaProject.getOutputLocation();
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            if (outputPath == null) {
                return null;
            }
        }
        IFolder javaOutputFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath);
        this.indexClassesForOutputFolder(javaOutputFolder);
        IContainer sourceContainer = (IContainer)sourceRoot.getResource();
        int sourceContainerSegmentCount = sourceContainer.getProjectRelativePath().segmentCount();
        boolean isModuleRoot = this.knownDD.getProjectRelativePath().toString().startsWith(sourceContainer.getProjectRelativePath().toString());
        HashSet iFilesSet = new HashSet();
        boolean foundJava = this.gatherFilesForJAR(iFilesSet, sourceContainer, isModuleRoot, false, sourceContainerSegmentCount);
        if (!isModuleRoot || foundJava) {
            ArrayList<IFile> iFilesList = Collections.list(Collections.enumeration(iFilesSet));
            int i = 0;
            while (i < iFilesList.size()) {
                this.filesHolder.removeIFile((IFile)iFilesList.get(i));
                ++i;
            }
            IArchive nestedArchive = this.createNestedArchive(iFilesList, sourceContainer, javaOutputFolder);
            return nestedArchive;
        }
        return null;
    }

    private boolean gatherFilesForJAR(Collection iFiles, IContainer current, boolean isModuleRoot, boolean foundJava, int sourceContainerSegmentCount) {
        IResource[] members = null;
        try {
            members = current.members();
        }
        catch (CoreException coreException) {}
        IContainer ddFolder = this.vComponent.getRootFolder().getFolder("META-INF").getUnderlyingFolder();
        int i = 0;
        while (i < members.length) {
            IResource res = members[i];
            if (res.getType() == 2) {
                if (!ddFolder.equals((Object)res)) {
                    foundJava = this.gatherFilesForJAR(iFiles, (IContainer)((IFolder)res), isModuleRoot, foundJava, sourceContainerSegmentCount) || foundJava;
                }
            } else {
                IFile srcFile = (IFile)res;
                if (this.belongsInNestedJAR(srcFile, isModuleRoot)) {
                    if (JavaEEArchiveUtilities.isJava(srcFile)) {
                        if (this.exportSource) {
                            iFiles.add(srcFile);
                        }
                        String className = srcFile.getProjectRelativePath().removeFirstSegments(sourceContainerSegmentCount).toString();
                        List classes = this.retrieveClasses(className = className.substring(0, className.length() - this.dotJavaLength));
                        if (classes != null) {
                            for (IFile clazz : classes) {
                                if (iFiles.contains(clazz)) continue;
                                iFiles.add(clazz);
                            }
                        }
                    } else if (!iFiles.contains(srcFile)) {
                        iFiles.add(srcFile);
                    }
                    if (isModuleRoot) {
                        foundJava = foundJava || JavaEEArchiveUtilities.isJava(srcFile) || JavaEEArchiveUtilities.isClass(srcFile);
                    }
                }
            }
            ++i;
        }
        return foundJava;
    }

    private IArchive createNestedArchive(List<IFile> files, IContainer sourceContainer, IFolder javaOutputFolder) throws ArchiveOpenFailureException {
        ConnectorComponentNestedJARArchiveLoadAdapter nestedLoader = new ConnectorComponentNestedJARArchiveLoadAdapter(files, sourceContainer, javaOutputFolder);
        ArchiveOptions nestedOptions = new ArchiveOptions();
        nestedOptions.setOption((Object)"LOAD_ADAPTER", (Object)nestedLoader);
        IArchive nestedArchive = IArchiveFactory.INSTANCE.openArchive(nestedOptions);
        nestedArchive.setPath((IPath)new Path(this.computeUniqueArchiveURI((IResource)sourceContainer)));
        nestedArchive.setArchive(this.archive);
        return nestedArchive;
    }

    private String computeUniqueArchiveURI(IResource resource) {
        int increment = 0;
        String name = resource.getName();
        StringBuffer sb = null;
        do {
            sb = new StringBuffer(name.length() + 5);
            sb.append('_');
            sb.append(name);
            if (increment > 0) {
                sb.append(increment);
            }
            sb.append(".jar");
            ++increment;
        } while (this.filesHolder.contains((IPath)new Path(sb.toString())));
        return sb.toString();
    }

    private boolean belongsInNestedJAR(IFile iFile, boolean isModuleRoot) {
        if (isModuleRoot && this.isDeploymentDescriptor(iFile)) {
            return false;
        }
        int i = 0;
        while (i < knownLibExtensions.length) {
            if (JavaEEArchiveUtilities.hasExtension(iFile, knownLibExtensions[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected boolean shouldInclude(IPath path) {
        String lastSegment = path.lastSegment();
        return lastSegment != null && !JavaEEArchiveUtilities.hasExtension(lastSegment, ".class") && !JavaEEArchiveUtilities.hasExtension(lastSegment, ".java");
    }

    private void indexClassesForOutputFolder(IFolder javaOutputFolder) {
        if (javaOutputFolder == null || this.alreadyIndexed.contains(javaOutputFolder)) {
            return;
        }
        this.alreadyIndexed.add(javaOutputFolder);
        int segmentCount = javaOutputFolder.getProjectRelativePath().segmentCount();
        this.indexClasses((IResource)javaOutputFolder, segmentCount);
    }

    private void indexClasses(IResource resource, int javaOutputSegmentCount) {
        switch (resource.getType()) {
            case 1: {
                this.indexClass((IFile)resource, javaOutputSegmentCount);
                break;
            }
            case 2: {
                try {
                    IResource[] members = ((IFolder)resource).members();
                    int i = 0;
                    while (i < members.length) {
                        this.indexClasses(members[i], javaOutputSegmentCount);
                        ++i;
                    }
                    break;
                }
                catch (CoreException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
        }
    }

    private void indexClass(IFile iFile, int javaOutputSegmentCount) {
        if (!JavaEEArchiveUtilities.isClass(iFile)) {
            return;
        }
        if (this.classesMap == null) {
            this.classesMap = new HashMap();
        }
        String name = iFile.getName();
        IPath relPath = iFile.getProjectRelativePath().removeFirstSegments(javaOutputSegmentCount);
        String key = relPath.toString();
        key = name.indexOf(36) != -1 ? key.substring(0, key.indexOf(36)) : key.substring(0, key.indexOf(46));
        ArrayList<IFile> inners = (ArrayList<IFile>)this.classesMap.get(key);
        if (inners == null) {
            inners = new ArrayList<IFile>(1);
            this.classesMap.put(key, inners);
        }
        inners.add(iFile);
    }

    public List retrieveClasses(String key) {
        if (this.classesMap == null) {
            return null;
        }
        return (List)this.classesMap.get(key);
    }

    private boolean isDeploymentDescriptor(IFile iFile) {
        return this.knownDD.equals((Object)iFile);
    }

    @Override
    protected IPath getDefaultModelObjectPath() {
        return new Path("META-INF/ra.xml");
    }

    @Override
    protected boolean shouldInclude(IVirtualContainer vContainer) {
        boolean isDDFolder = this.vComponent.getRootFolder().getFolder("META-INF").equals((Object)vContainer);
        return isDDFolder || !this.inJavaSrc((IVirtualResource)vContainer);
    }
}

