/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.operations;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.refactor.RefactorResourceHandler;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactoringProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.DeletedModule;

public abstract class ProjectRefactorOperation
extends AbstractDataModelOperation
implements ProjectRefactoringProperties {
    public ProjectRefactorOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            ProjectRefactorMetadata refactoredMetadata = this.getProjectMetadata();
            if (refactoredMetadata.hasModuleCoreNature()) {
                this.updateProject(refactoredMetadata);
            }
            this.updateDependentProjects(refactoredMetadata, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    protected abstract void updateProject(ProjectRefactorMetadata var1) throws ExecutionException;

    protected void updateDependentProjects(ProjectRefactorMetadata refactoredMetadata, IProgressMonitor monitor) throws ExecutionException {
        ProjectRefactorMetadata[] dependentMetadata = refactoredMetadata.getDependentMetadata();
        if (monitor != null) {
            monitor.beginTask(RefactorResourceHandler.getString("task_name"), dependentMetadata.length);
        }
        int i = 0;
        while (i < dependentMetadata.length) {
            ProjectRefactorMetadata metadata = dependentMetadata[i];
            if (metadata.isEAR()) {
                this.updateDependentEARProject(metadata, refactoredMetadata);
            } else if (metadata.hasModuleCoreNature()) {
                this.updateDependentModuleProject(metadata, refactoredMetadata);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ++i;
        }
    }

    protected void updateServerRefs(ProjectRefactorMetadata originalMetadata, ProjectRefactorMetadata newMetadata) throws ExecutionException {
        IModule originalModule = originalMetadata.getModule();
        if (originalModule == null) {
            return;
        }
        IModule[] toRemove = new IModule[]{new DeletedModule(originalModule.getId(), originalModule.getName(), originalModule.getModuleType())};
        IModule newModule = null;
        IModule[] toAdd = new IModule[]{};
        if (newMetadata != null) {
            newMetadata.computeMetadata();
            newModule = newMetadata.getModule();
            if (newModule == null) {
                return;
            }
            toAdd = new IModule[]{newModule};
        }
        IServer[] server = originalMetadata.getServers();
        IServerWorkingCopy wc = null;
        int i = 0;
        while (i < server.length) {
            try {
                try {
                    wc = server[i].createWorkingCopy();
                    List<IModule> list = Arrays.asList(server[i].getModules());
                    if (list.contains(originalModule)) {
                        ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])toAdd, (IModule[])toRemove, null);
                    }
                }
                catch (CoreException ce) {
                    throw new ExecutionException(RefactorResourceHandler.getString("error_updating_server", new Object[]{server[i].getId(), originalMetadata.getProjectName()}), (Throwable)ce);
                }
            }
            catch (Throwable throwable) {
                try {
                    wc.saveAll(true, null);
                }
                catch (CoreException ce) {
                    throw new ExecutionException(RefactorResourceHandler.getString("error_updating_server", new Object[]{server[i].getId(), originalMetadata.getProjectName()}), (Throwable)ce);
                }
                throw throwable;
            }
            try {
                wc.saveAll(true, null);
            }
            catch (CoreException ce) {
                throw new ExecutionException(RefactorResourceHandler.getString("error_updating_server", new Object[]{server[i].getId(), originalMetadata.getProjectName()}), (Throwable)ce);
            }
            ++i;
        }
    }

    protected abstract void updateDependentEARProject(ProjectRefactorMetadata var1, ProjectRefactorMetadata var2) throws ExecutionException;

    protected abstract void updateDependentModuleProject(ProjectRefactorMetadata var1, ProjectRefactorMetadata var2) throws ExecutionException;

    protected ProjectRefactorMetadata getProjectMetadata() {
        return (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.PROJECT_METADATA");
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }
}

