/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.dependency.tests.AbstractTests;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;

public class EarLibDirContainerTests
extends AbstractTests {
    private static final String EAR_PROJECT_NAME = "TestEAR";
    private static final String LIB_PROJECT_NAME = "TestLib";
    private static final String UTIL_PROJECT_NAME = "TestUtil";

    public EarLibDirContainerTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("EAR Container Library Directory Tests");
        suite.addTest((Test)new EarLibDirContainerTests("testEarLibDirDependency"));
        return suite;
    }

    public void testEarLibDirDependency() throws Exception {
        ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IProject earProject = ProjectUtil.createEARProject(EAR_PROJECT_NAME, 50, false);
        IProject utilProject = ProjectUtil.createUtilityProject(UTIL_PROJECT_NAME, EAR_PROJECT_NAME);
        IProject libProject = ProjectUtil.createUtilityProject(LIB_PROJECT_NAME, null);
        DependencyCreationUtil.createEARDependency(earProject, libProject, true);
        EarLibDirContainerTests.updateEARLibrariesContainer(utilProject);
        EarLibDirContainerTests.waitForCondition(EarLibDirContainerTests.cpContains(utilProject, (IPath)new Path("/TestLib")));
    }

    private static void updateEARLibrariesContainer(IProject project) {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        projectList.add(project);
        J2EEComponentClasspathUpdater.getInstance().forceUpdate(projectList);
    }

    private static ICondition cpContains(IProject project, IPath entry) {
        return new ClasspathContainsCondition(project, entry);
    }

    private static void waitForCondition(ICondition condition) throws Exception {
        EarLibDirContainerTests.waitForCondition(condition, 10);
    }

    private static void waitForCondition(ICondition condition, int seconds) throws Exception {
        int i = 0;
        while (i < seconds && !condition.check()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        EarLibDirContainerTests.assertCondition(condition);
    }

    private static void assertCondition(ICondition condition) throws Exception {
        EarLibDirContainerTests.assertTrue((boolean)condition.check());
    }

    private static abstract class AbstractClasspathCondition
    implements ICondition {
        private final IProject project;
        private final IPath entry;

        public AbstractClasspathCondition(IProject project, IPath entry) {
            this.project = project;
            this.entry = entry;
        }

        protected boolean internalCheck() throws Exception {
            IJavaProject jproj = JavaCore.create((IProject)this.project);
            IClasspathEntry[] cp = jproj.getResolvedClasspath(true);
            int i = 0;
            while (i < cp.length) {
                if (cp[i].getPath().equals((Object)this.entry)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static final class ClasspathContainsCondition
    extends AbstractClasspathCondition {
        public ClasspathContainsCondition(IProject project, IPath entry) {
            super(project, entry);
        }

        public boolean check() throws Exception {
            return this.internalCheck();
        }
    }

    private static interface ICondition {
        public boolean check() throws Exception;
    }
}

