/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.fvtests;

import java.io.IOException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etools.common.test.apitools.ProjectUnzipUtil;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class J2EEFlexProjDeployablePerfTest
extends TestCase {
    private static String[] projectNames = new String[]{"war"};
    private static Path zipFilePath = new Path("/TestData/GenralArtifactTest/perfWAR.zip");

    public static Test suite() {
        return new TestSuite(J2EEFlexProjDeployablePerfTest.class);
    }

    public void testMembersPerformance() {
        ProjectUnzipUtil util = new ProjectUnzipUtil(J2EEFlexProjDeployablePerfTest.getLocalPath(), projectNames);
        util.createProjects();
        IProject project = ProjectUtilities.getProject((String)projectNames[0]);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(project, component);
        try {
            IModuleResource[] members = deployable.members();
            J2EEFlexProjDeployablePerfTest.assertTrue((members.length == 3 ? 1 : 0) != 0);
            int verified = 0;
            int i = 0;
            while (i < members.length) {
                String name = members[i].getName();
                if (name.equals("META-INF")) {
                    IModuleResource manifest = ((ModuleFolder)members[i]).members()[0];
                    J2EEFlexProjDeployablePerfTest.assertTrue((boolean)manifest.getModuleRelativePath().toString().equals("META-INF"));
                    J2EEFlexProjDeployablePerfTest.assertTrue((boolean)manifest.getName().equals("MANIFEST.MF"));
                    ++verified;
                } else if (name.equals("WEB-INF")) {
                    IModuleResource[] webInf = ((ModuleFolder)members[i]).members();
                    J2EEFlexProjDeployablePerfTest.assertTrue((webInf.length == 2 ? 1 : 0) != 0);
                    int j = 0;
                    while (j < webInf.length) {
                        IModuleResource webResource = webInf[j];
                        J2EEFlexProjDeployablePerfTest.assertTrue((boolean)webResource.getModuleRelativePath().toString().equals("WEB-INF"));
                        J2EEFlexProjDeployablePerfTest.assertTrue((webResource.getName().equals("web.xml") || webResource.getName().equals("classes") ? 1 : 0) != 0);
                        ++j;
                    }
                    ++verified;
                } else if (name.equals("pkg0")) {
                    J2EEFlexProjDeployablePerfTest.assertTrue((((ModuleFolder)members[i]).members().length > 0 ? 1 : 0) != 0);
                    ++verified;
                }
                ++i;
            }
            J2EEFlexProjDeployablePerfTest.assertTrue((verified == 3 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
            J2EEFlexProjDeployablePerfTest.fail((String)e.getMessage());
        }
    }

    private static IPath getLocalPath() {
        URL url = HeadlessTestsPlugin.getDefault().find((IPath)zipFilePath);
        try {
            url = Platform.asLocalURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }
}

