/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryconfig;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;

public class JSFLibraryRegistryUtilTestCases
extends TestCase {
    private JSFLibraryRegistry libReg = null;
    private JSFLibraryRegistryUtil libUtilInstance = null;
    private int numCompLibs;

    protected void setUp() throws Exception {
        super.setUp();
        JSFCoreUtilHelper.createJSFLibraryRegistry();
        this.libReg = JSFCoreUtilHelper.getJSFLibraryRegistryFromJSFLibraryHelper();
        this.numCompLibs = this.libReg.getNonImplJSFLibraries().size();
        this.libUtilInstance = JSFLibraryRegistryUtil.getInstance();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.libReg = null;
    }

    public void testGetJSFLibraryRegistry() {
        Assert.assertNotNull((Object)this.libUtilInstance.getJSFLibraryRegistry());
        Assert.assertEquals((Object)this.libReg, (Object)this.libUtilInstance.getJSFLibraryRegistry());
    }

    public void testGetDefaultJSFImplementationLibrary() {
        JSFLibraryInternalReference dftImplLib = this.libUtilInstance.getDefaultJSFImplementationLibrary();
        Assert.assertNotNull((Object)dftImplLib);
        Assert.assertEquals((String)this.libReg.getDefaultImplementation().getID(), (String)dftImplLib.getID());
    }

    public void testGetJSFLibryReferencebyID() {
        JSFLibraryInternalReference lib = this.libUtilInstance.getJSFLibraryReferencebyID(this.libReg.getDefaultImplementationID());
        Assert.assertNotNull((Object)lib);
        Assert.assertEquals((String)this.libReg.getDefaultImplementation().getID(), (String)lib.getID());
    }

    public void testAddJSFLibrary() {
        JSFLibrary jsfLib = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        jsfLib.setName("A_COMP_LIB");
        jsfLib.setImplementation(false);
        JSFLibraryInternalReference jsfLibRef = new JSFLibraryInternalReference(jsfLib, false, false);
        Assert.assertTrue((this.libReg.getNonImplJSFLibraries().size() == this.numCompLibs ? 1 : 0) != 0);
        this.libUtilInstance.addJSFLibrary(jsfLibRef);
        Assert.assertTrue((this.libReg.getNonImplJSFLibraries().size() == this.numCompLibs + 1 ? 1 : 0) != 0);
    }
}

