/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestJSFAppConfigUtils
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
    }

    public void testIsJSFProject() {
        WebProjectTestEnvironment env = this.createTestEnv("1.1", this.getName());
        TestJSFAppConfigUtils.assertTrue((boolean)JSFAppConfigUtils.isValidJSFProject((IProject)env.getTestProject()));
    }

    public void testIsNotJSFProject() {
        WebProjectTestEnvironment env = this.createTestEnv(null, this.getName());
        TestJSFAppConfigUtils.assertFalse((boolean)JSFAppConfigUtils.isValidJSFProject((IProject)env.getTestProject()));
    }

    public void testIsJSFProjectByVersion() {
        WebProjectTestEnvironment env = this.createTestEnv("1.1", String.valueOf(this.getName()) + "1");
        TestJSFAppConfigUtils.assertTrue((boolean)JSFAppConfigUtils.isValidJSFProject((IProject)env.getTestProject(), (String)"1.0"));
        TestJSFAppConfigUtils.assertTrue((boolean)JSFAppConfigUtils.isValidJSFProject((IProject)env.getTestProject(), (String)"1.1"));
        TestJSFAppConfigUtils.assertFalse((boolean)JSFAppConfigUtils.isValidJSFProject((IProject)env.getTestProject(), (String)"1.2"));
        env = this.createTestEnv("1.2", String.valueOf(this.getName()) + "2");
        TestJSFAppConfigUtils.assertTrue((boolean)JSFAppConfigUtils.isValidJSFProject((IProject)env.getTestProject(), (String)"1.0"));
        TestJSFAppConfigUtils.assertTrue((boolean)JSFAppConfigUtils.isValidJSFProject((IProject)env.getTestProject(), (String)"1.1"));
        TestJSFAppConfigUtils.assertTrue((boolean)JSFAppConfigUtils.isValidJSFProject((IProject)env.getTestProject(), (String)"1.2"));
    }

    private WebProjectTestEnvironment createTestEnv(String facetVersion, String name) {
        WebProjectTestEnvironment testEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + name);
        testEnv.createProject(true);
        TestJSFAppConfigUtils.assertNotNull((Object)testEnv);
        TestJSFAppConfigUtils.assertNotNull((Object)testEnv.getTestProject());
        TestJSFAppConfigUtils.assertTrue((boolean)testEnv.getTestProject().isAccessible());
        if (facetVersion != null) {
            JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(testEnv);
            try {
                jsfFacedEnv.initialize(facetVersion);
            }
            catch (CoreException ce) {
                throw new RuntimeException(ce);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return testEnv;
    }
}

