/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.bindingshelper.tests;

import java.io.File;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.bindingshelper.tests.BarBindingsHelper;
import org.eclipse.jst.j2ee.bindingshelper.tests.FooBindingsHelper;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.core.internal.bindings.IJNDIBindingsHelper;
import org.eclipse.jst.j2ee.core.internal.bindings.JNDIBindingsHelperManager;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class BindingsHelperTest
extends TestCase {
    public static String fileSep = System.getProperty("file.separator");
    private IProject earProject;
    private IVirtualComponent earComponent;

    public static String getFullTestDataPath(String dataPath) {
        try {
            String defectTestDataPath = "TestData" + fileSep + "BindingsHelperTests" + fileSep + dataPath;
            HeadlessTestsPlugin plugin = HeadlessTestsPlugin.getDefault();
            if (plugin != null) {
                return ProjectUtility.getFullFileName((Plugin)plugin, (String)defectTestDataPath);
            }
            return String.valueOf(System.getProperty("user.dir")) + File.separatorChar + defectTestDataPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        IDataModel model = BindingsHelperTest.importEar(BindingsHelperTest.getFullTestDataPath("BindingsTestEAR.ear"));
        this.earProject = ProjectUtilities.getProject((String)model.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME"));
        this.earComponent = ComponentCore.createComponent((IProject)this.earProject);
    }

    protected EARFile getEarFile() throws Exception {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            EARFile eARFile = (EARFile)edit.asArchive(true);
            return eARFile;
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public static IDataModel importEar(String earPath) throws Exception {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
        model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)earPath);
        model.getDefaultOperation().execute(null, null);
        return model;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            projects[i].delete(true, null);
            ++i;
        }
    }

    protected String getSourceFileName() {
        return "test.txt";
    }

    public void testHelpers() throws Exception {
        IJNDIBindingsHelper[] helpers = this.checkHelper(null);
        this.checkBindings(this.getEarFile(), helpers[0], "");
        IFile srcFile = this.earComponent.getRootFolder().getFile(this.getSourceFileName()).getUnderlyingFile();
        IFile fooFile = this.earComponent.getRootFolder().getFile(FooBindingsHelper.getFileName()).getUnderlyingFile();
        srcFile.copy((IPath)new Path(fooFile.getFullPath().lastSegment()), true, null);
        BindingsHelperTest.assertTrue((boolean)fooFile.exists());
        helpers = this.checkHelper(FooBindingsHelper.class);
        this.checkBindings(this.getEarFile(), helpers[0], FooBindingsHelper.getFileName());
        fooFile.delete(true, null);
        BindingsHelperTest.assertFalse((boolean)fooFile.exists());
        IFile barFile = this.earComponent.getRootFolder().getFile(BarBindingsHelper.getFileName()).getUnderlyingFile();
        srcFile.copy((IPath)new Path(barFile.getFullPath().lastSegment()), true, null);
        BindingsHelperTest.assertTrue((boolean)barFile.exists());
        helpers = this.checkHelper(BarBindingsHelper.class);
        this.checkBindings(this.getEarFile(), helpers[0], BarBindingsHelper.getFileName());
        srcFile.copy((IPath)new Path(fooFile.getFullPath().lastSegment()), true, null);
        BindingsHelperTest.assertTrue((boolean)fooFile.exists());
        helpers = JNDIBindingsHelperManager.getInstance().getBindingsHelpers(this.earProject);
        BindingsHelperTest.assertEquals((int)2, (int)helpers.length);
        int fooIndex = helpers[0].getClass() == FooBindingsHelper.class ? 0 : 1;
        int barIndex = fooIndex == 0 ? 1 : 0;
        BindingsHelperTest.assertTrue((helpers[fooIndex].getClass() == FooBindingsHelper.class ? 1 : 0) != 0);
        BindingsHelperTest.assertTrue((helpers[barIndex].getClass() == BarBindingsHelper.class ? 1 : 0) != 0);
        EARFile earFile = this.getEarFile();
        IJNDIBindingsHelper[] tempHelpers = JNDIBindingsHelperManager.getInstance().getBindingsHelpers((Archive)earFile);
        BindingsHelperTest.assertEquals((int)2, (int)tempHelpers.length);
        BindingsHelperTest.assertTrue((helpers[0] == tempHelpers[0] ? 1 : 0) != 0);
        BindingsHelperTest.assertTrue((helpers[1] == tempHelpers[1] ? 1 : 0) != 0);
        this.checkBindings(this.getEarFile(), helpers[fooIndex], FooBindingsHelper.getFileName());
        this.checkBindings(this.getEarFile(), helpers[barIndex], BarBindingsHelper.getFileName());
    }

    private IJNDIBindingsHelper[] checkHelper(Class clazz) throws Exception {
        IJNDIBindingsHelper[] helpers = JNDIBindingsHelperManager.getInstance().getBindingsHelpers(this.earProject);
        BindingsHelperTest.assertEquals((int)1, (int)helpers.length);
        if (clazz != null) {
            BindingsHelperTest.assertTrue((helpers[0].getClass() == clazz ? 1 : 0) != 0);
        } else {
            BindingsHelperTest.assertTrue((helpers[0].getClass() != FooBindingsHelper.class ? 1 : 0) != 0);
            BindingsHelperTest.assertTrue((helpers[0].getClass() != BarBindingsHelper.class ? 1 : 0) != 0);
        }
        EARFile earFile = this.getEarFile();
        IJNDIBindingsHelper[] tempHelpers = JNDIBindingsHelperManager.getInstance().getBindingsHelpers((Archive)earFile);
        BindingsHelperTest.assertEquals((int)1, (int)tempHelpers.length);
        BindingsHelperTest.assertTrue((helpers[0] == tempHelpers[0] ? 1 : 0) != 0);
        return helpers;
    }

    private void checkBindings(EARFile earFile, IJNDIBindingsHelper helper, String prefix) {
        List ejbJarFiles = earFile.getEJBJarFiles();
        EJBJarFile ejbJarFile = (EJBJarFile)ejbJarFiles.get(0);
        EJBJar ejbJar = ejbJarFile.getDeploymentDescriptor();
        List cmps = ejbJar.getContainerManagedBeans();
        ContainerManagedEntity cmp = (ContainerManagedEntity)cmps.get(0);
        String jndiName = helper.getJNDIName((EnterpriseBean)cmp);
        String suffix = prefix.length() > 0 ? "ejb" : prefix;
        BindingsHelperTest.assertEquals((String)(String.valueOf(prefix) + cmp.getName() + suffix), (String)jndiName);
        jndiName = helper.getJNDINameForDefaultDataSource(cmp);
        suffix = prefix.length() > 0 ? "cmp" : prefix;
        BindingsHelperTest.assertEquals((String)(String.valueOf(prefix) + ejbJar.getDisplayName() + suffix), (String)jndiName);
        List sessions = ejbJar.getSessionBeans();
        Session session = (Session)sessions.get(0);
        EList resRefs = session.getResourceRefs();
        ResourceRef resRef = (ResourceRef)resRefs.get(0);
        jndiName = helper.getJNDINameForRef((EnterpriseBean)session, resRef);
        suffix = prefix.length() > 0 ? "ejbResRef" : prefix;
        BindingsHelperTest.assertEquals((String)(String.valueOf(prefix) + resRef.getName() + suffix), (String)jndiName);
        EList resEnvRefs = session.getResourceEnvRefs();
        ResourceEnvRef resEnvRef = (ResourceEnvRef)resEnvRefs.get(0);
        jndiName = helper.getJNDINameForRef((EnterpriseBean)session, resEnvRef);
        suffix = prefix.length() > 0 ? "ejbResEnvRef" : prefix;
        BindingsHelperTest.assertEquals((String)(String.valueOf(prefix) + resEnvRef.getName() + suffix), (String)jndiName);
        EList securityRoleRefs = session.getSecurityRoleRefs();
        SecurityRoleRef securityRoleRef = (SecurityRoleRef)securityRoleRefs.get(0);
        jndiName = helper.getJNDINameForRef((EnterpriseBean)session, securityRoleRef);
        suffix = prefix.length() > 0 ? "ejbSecRoleRef" : prefix;
        BindingsHelperTest.assertEquals((String)(String.valueOf(prefix) + securityRoleRef.getName() + suffix), (String)jndiName);
        List warFiles = earFile.getWARFiles();
        WARFile warFile = (WARFile)warFiles.get(0);
        WebApp webApp = warFile.getDeploymentDescriptor();
        resRefs = webApp.getResourceRefs();
        resRef = (ResourceRef)resRefs.get(0);
        jndiName = helper.getJNDINameForRef(webApp, resRef);
        suffix = prefix.length() > 0 ? "webResRef" : prefix;
        BindingsHelperTest.assertEquals((String)(String.valueOf(prefix) + resRef.getName() + suffix), (String)jndiName);
        resEnvRefs = session.getResourceEnvRefs();
        resEnvRef = (ResourceEnvRef)resEnvRefs.get(0);
        jndiName = helper.getJNDINameForRef(webApp, resEnvRef);
        suffix = prefix.length() > 0 ? "webResEnvRef" : prefix;
        BindingsHelperTest.assertEquals((String)(String.valueOf(prefix) + resEnvRef.getName() + suffix), (String)jndiName);
    }
}

