/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class ConnectorArtifactEditTest
extends TestCase {
    private IProject jcaProject;
    private String jcaModuleName;

    public ConnectorArtifactEditTest() {
        if (TestWorkspace.init()) {
            this.jcaProject = TestWorkspace.getTargetProject("JCAArtifactEditTest");
            this.jcaModuleName = "JCAArtifactEditTestModule";
        } else {
            ConnectorArtifactEditTest.fail();
        }
    }

    public void testGetJ2EEVersion() {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.jcaProject);
        ConnectorArtifactEditTest.assertTrue((boolean)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)vc.getProject()).equals("1.5"));
    }

    public void testGetDeploymentDescriptorResource() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)this.jcaProject);
            String uri = edit.getDeploymentDescriptorResource().getURI().toString();
            ConnectorArtifactEditTest.assertTrue((boolean)uri.equals("platform:/resource/JCAArtifactEditTestModule/JCAArtifactEditTestModule/connectorModule/META-INF/ra.xml"));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testCreateModelRoot() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForWrite((IProject)this.jcaProject);
            EObject object = edit.createModelRoot();
            ConnectorArtifactEditTest.assertNotNull((Object)object);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testCreateModelRootint() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)this.jcaProject);
            EObject object = edit.createModelRoot(14);
            ConnectorArtifactEditTest.assertNotNull((Object)object);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testConnectorArtifactEditComponentHandleboolean() {
        StructureEdit moduleCore = null;
        ConnectorArtifactEdit edit = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.jcaProject);
            moduleCore.getComponent();
            edit = new ConnectorArtifactEdit(this.jcaProject, true);
            ConnectorArtifactEditTest.assertNotNull((Object)edit);
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
                edit.dispose();
            }
        }
    }

    public void testConnectorArtifactEditArtifactEditModel() {
        ConnectorArtifactEdit edit = new ConnectorArtifactEdit(this.getArtifactEditModelforRead());
        ConnectorArtifactEditTest.assertNotNull((Object)edit);
        edit.dispose();
    }

    public void testGetConnectorArtifactEditForReadComponentHandle() {
        StructureEdit moduleCore = null;
        ConnectorArtifactEdit edit = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)this.jcaProject);
            moduleCore.getComponent();
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)this.jcaProject);
            ConnectorArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
                edit.dispose();
            }
        }
    }

    public void testGetConnectorArtifactEditForWriteComponentHandle() {
        StructureEdit moduleCore = null;
        ConnectorArtifactEdit edit = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.jcaProject);
            moduleCore.getComponent();
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForWrite((IProject)this.jcaProject);
        }
        catch (Throwable throwable) {
            if (moduleCore != null) {
                moduleCore.dispose();
                edit.dispose();
            }
            ConnectorArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (moduleCore != null) {
            moduleCore.dispose();
            edit.dispose();
        }
        ConnectorArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testGetConnectorArtifactEditForReadWorkbenchComponent() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)this.jcaProject);
            ConnectorArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetConnectorArtifactEditForWriteWorkbenchComponent() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForWrite((IProject)this.jcaProject);
            ConnectorArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIsValidConnectorModule() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.jcaProject);
        ConnectorArtifactEditTest.assertTrue((boolean)ArtifactEdit.isValidEditableModule((IVirtualComponent)component));
    }

    public void testGetConnectorXmiResource() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)this.jcaProject);
            String uri = edit.getDeploymentDescriptorResource().getURI().toString();
            ConnectorArtifactEditTest.assertTrue((boolean)uri.equals("platform:/resource/JCAArtifactEditTestModule/JCAArtifactEditTestModule/connectorModule/META-INF/ra.xml"));
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            ConnectorArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        ConnectorArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testAddApplicationIfNecessary() {
        this.pass();
    }

    public void pass() {
        ConnectorArtifactEditTest.assertTrue((boolean)true);
    }

    public ArtifactEditModel getArtifactEditModelforRead() {
        EMFWorkbenchContext context = new EMFWorkbenchContext(this.jcaProject);
        return new ArtifactEditModel(this.toString(), context, true, TestWorkspace.JCA_MODULE_URI);
    }

    public ConnectorArtifactEdit getArtifactEditForRead() {
        return new ConnectorArtifactEdit(this.getArtifactEditModelforRead());
    }

    public void testGetDeploymentDescriptorRoot() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)this.jcaProject);
            EObject obj = edit.getDeploymentDescriptorRoot();
            ConnectorArtifactEditTest.assertNotNull((Object)obj);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAddConnectorIfNecessary() {
        this.pass();
    }

    public void testGetConnector() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)this.jcaProject);
            Connector obj = edit.getConnector();
            ConnectorArtifactEditTest.assertNotNull((Object)obj);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

